/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.cli.cmd;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.ehrbase.cli.cmd.CliCommand;
import org.ehrbase.configuration.config.flyway.MigrationStrategy;
import org.ehrbase.configuration.config.flyway.MigrationStrategyConfig;
import org.flywaydb.core.Flyway;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationStrategy;
import org.springframework.stereotype.Component;

@Component
public class CliDataBaseCommand
extends CliCommand {
    protected final DataSource dataSource;
    protected final Flyway flyway;
    protected final MigrationStrategyConfig migrationStrategyConfig;

    public CliDataBaseCommand(DataSource dataSource, Flyway flyway, MigrationStrategyConfig migrationStrategyConfig) {
        super("database");
        this.dataSource = dataSource;
        this.flyway = flyway;
        this.migrationStrategyConfig = migrationStrategyConfig;
    }

    @Override
    public void run(List<String> args) throws Exception {
        this.consumeArgs(args, arg -> switch (arg.key()) {
            case "check-connection" -> this.executeCheckConnection();
            case "migration-validate" -> this.executeMigration(MigrationStrategy.VALIDATE);
            case "migration-migrate" -> this.executeMigration(MigrationStrategy.MIGRATE);
            default -> CliCommand.Result.Unknown;
        });
    }

    protected CliCommand.Result executeCheckConnection() {
        CliCommand.Result result;
        block8: {
            this.printStep("executing Database connection check: %s".formatted(this.jdbUrl()));
            Connection connection = this.dataSource.getConnection();
            try {
                String url = connection.getMetaData().getURL();
                this.println("Connection established to %s".formatted(url));
                result = CliCommand.Result.OK;
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.exitFail("Failed to open connection %s".formatted(this.jdbUrl()));
                    return CliCommand.Result.Unknown;
                }
            }
            connection.close();
        }
        return result;
    }

    protected CliCommand.Result executeMigration(MigrationStrategy migrationStrategy) {
        this.printStep("executing Flyway with strategy: %s".formatted(migrationStrategy));
        FlywayMigrationStrategy strategy = this.migrationStrategyConfig.flywayMigrationStrategy(migrationStrategy, migrationStrategy);
        strategy.migrate(this.flyway);
        return CliCommand.Result.OK;
    }

    protected String jdbUrl() {
        return ((HikariDataSource)this.dataSource).getJdbcUrl();
    }

    @Override
    protected void printUsage() {
        this.println("Database related operation like connection verification or migration.\n\nArguments:\n  --check-connection    verifies database access by open/close a connection\n  --migration-validate  validate flyway migration\n  --migration-migrate   executes flyway migration\n\nExample:\n\ndatabase --check-connection --migration-validate\n");
    }
}

