/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.cli;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.ehrbase.cli.cmd.CliCommand;
import org.ehrbase.cli.cmd.CliHelpCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CliRunner {
    public static final String CLI = "cli";
    private final Logger logger = LoggerFactory.getLogger(CliRunner.class);
    private final CliHelpCommand helpCommand;
    private final List<CliCommand> commands;

    public CliRunner(List<CliCommand> commands, CliHelpCommand helpCommand) {
        this.helpCommand = helpCommand;
        this.commands = commands.stream().sorted(Comparator.comparing(CliCommand::getName)).toList();
    }

    public void run(String ... args) {
        this.run((t, t2) -> {
            throw new IllegalStateException(String.format("Duplicate command for name %s (attempted merging values %s and %s)", t.getName(), t, t2));
        }, args);
    }

    public void run(BinaryOperator<CliCommand> onDuplicatedCmd, String ... args) {
        List<String> argList = Arrays.asList(args);
        Iterator<String> argIter = argList.iterator();
        Optional<String> commandName = this.extractCmd(argIter);
        Map<String, CliCommand> namedCommands = this.commands.stream().collect(Collectors.toMap(CliCommand::getName, item -> item, onDuplicatedCmd));
        commandName.ifPresentOrElse(name -> Optional.ofNullable((CliCommand)namedCommands.get(name)).ifPresentOrElse(command -> this.runCommand((CliCommand)command, StreamSupport.stream(Spliterators.spliteratorUnknownSize(argIter, 16), false).toList()), () -> this.helpCommand.exitFail("Unknown command %s".formatted(name))), () -> this.helpCommand.exitFail("No command specified"));
    }

    private Optional<String> extractCmd(Iterator<String> argIter) {
        String next;
        if (!argIter.hasNext()) {
            return Optional.empty();
        }
        while (argIter.hasNext() && !(next = argIter.next()).equals(CLI)) {
        }
        if (!argIter.hasNext()) {
            return Optional.empty();
        }
        return Optional.of(argIter.next());
    }

    private void runCommand(CliCommand command, List<String> args) {
        try {
            command.run(args);
        }
        catch (Throwable e) {
            this.logger.error("Failed to execute [%s]".formatted(command.getName()), e);
            this.helpCommand.exitFail(e.getMessage());
        }
    }
}

