/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.cli.cmd;

import java.util.Iterator;
import java.util.List;
import org.ehrbase.cli.util.ExceptionFriendlyFunction;

public abstract class CliCommand {
    protected final String name;

    protected CliCommand(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract void run(List<String> var1) throws Throwable;

    protected void println(String line) {
        System.out.println(line);
    }

    protected void printStep(String line) {
        this.println("---------------------------------------------------------------------------");
        this.println(line);
        this.println("---------------------------------------------------------------------------");
    }

    public void exitFail(String reason) {
        System.err.println(reason);
        this.printUsage();
        this.exit(-1);
    }

    void exit(int code) {
        System.exit(code);
    }

    protected abstract void printUsage();

    protected void consumeArgs(Iterable<String> args, ExceptionFriendlyFunction<CliArgument, Result> consumer) throws Exception {
        Iterator<String> argIter = args.iterator();
        if (!argIter.hasNext()) {
            this.exitFail("No argument provided");
            return;
        }
        while (argIter.hasNext()) {
            String next = argIter.next();
            if (next.equals("help")) {
                this.printUsage();
                return;
            }
            String[] split = next.split("=");
            CliArgument arg = new CliArgument(next, split[0].replace("--", ""), split.length > 1 ? split[1] : null);
            Result result = consumer.apply(arg);
            if (!(result instanceof Result.Unknown)) continue;
            this.exitFail("Unknown argument [%s]".formatted(arg.arg()));
        }
    }

    public record CliArgument(String arg, String key, String value) {
    }

    public static sealed interface Result {
        public static final Result OK = new OK();
        public static final Result Unknown = new Unknown();

        public static final class OK
        implements Result {
        }

        public static final class Unknown
        implements Result {
        }
    }
}

