/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.ehrscape.controller;

import java.rmi.UnmarshalException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.exception.BadGatewayException;
import org.ehrbase.api.exception.DuplicateObjectException;
import org.ehrbase.api.exception.GeneralRequestProcessingException;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.StateConflictException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class BaseController {
    public Map<String, Map<String, String>> add2MetaMap(Map<String, Map<String, String>> metaMap, String key, String value) {
        Map<String, String> contentMap;
        if (metaMap == null) {
            metaMap = new HashMap<String, Map<String, String>>();
            contentMap = new HashMap<String, String>();
            metaMap.put("meta", contentMap);
        } else {
            contentMap = metaMap.get("meta");
        }
        contentMap.put(key, value);
        return metaMap;
    }

    protected String getBaseEnvLinkURL() {
        String baseEnvLinkURL = null;
        HttpServletRequest currentRequest = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        baseEnvLinkURL = "http://" + currentRequest.getLocalName();
        if (currentRequest.getLocalPort() != 80) {
            baseEnvLinkURL = baseEnvLinkURL + ":" + currentRequest.getLocalPort();
        }
        if (!StringUtils.isEmpty((CharSequence)currentRequest.getContextPath())) {
            baseEnvLinkURL = baseEnvLinkURL + currentRequest.getContextPath();
        }
        return baseEnvLinkURL;
    }

    @ExceptionHandler(value={DuplicateObjectException.class})
    public ResponseEntity<Map<String, String>> restErrorHandler(DuplicateObjectException e) {
        return this.createErrorResponse(e.getMessage(), HttpStatus.ALREADY_REPORTED);
    }

    @Deprecated
    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<Map<String, String>> restErrorHandler(IllegalArgumentException e) {
        return this.createErrorResponse(e.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={GeneralRequestProcessingException.class})
    public ResponseEntity<Map<String, String>> restErrorHandler(GeneralRequestProcessingException e) {
        return this.createErrorResponse(e.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={InvalidApiParameterException.class})
    public ResponseEntity<Map<String, String>> restErrorHandler(InvalidApiParameterException e) {
        return this.createErrorResponse(e.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public ResponseEntity<Map<String, String>> restErrorHandler(MissingServletRequestParameterException e) {
        return this.createErrorResponse(e.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ObjectNotFoundException.class})
    public ResponseEntity<Map<String, String>> restErrorHandler(ObjectNotFoundException e) {
        return this.createErrorResponse(e.getMessage(), HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={UnmarshalException.class})
    public ResponseEntity<Map<String, String>> restErrorHandler(UnmarshalException e) {
        return this.createErrorResponse(e.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={StateConflictException.class})
    public ResponseEntity<Map<String, String>> restErrorHandler(StateConflictException e) {
        return this.createErrorResponse(e.getMessage(), HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={InternalServerException.class})
    public ResponseEntity<Map<String, String>> restErrorHandler(InternalServerException e) {
        return this.createErrorResponse("Internal Server Error: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={BadGatewayException.class})
    public ResponseEntity<Map<String, String>> restErrorHandler(BadGatewayException e) {
        return this.createErrorResponse("Bad Gateway: Proxied connection failed", HttpStatus.BAD_GATEWAY);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Map<String, String>> restErrorHandler(Exception e) {
        return this.createErrorResponse(e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    protected ResponseEntity<Map<String, String>> createErrorResponse(String message, HttpStatus status) {
        HashMap<String, String> error = new HashMap<String, String>();
        error.put("error", message);
        error.put("status", status.getReasonPhrase());
        return new ResponseEntity(error, status);
    }
}

