/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.ehrscape.controller;

import java.util.Objects;
import org.ehrbase.api.service.TemplateService;
import org.ehrbase.response.ehrscape.CompositionFormat;
import org.ehrbase.rest.ehrscape.controller.BaseController;
import org.ehrbase.rest.ehrscape.responsedata.Action;
import org.ehrbase.rest.ehrscape.responsedata.Meta;
import org.ehrbase.rest.ehrscape.responsedata.RestHref;
import org.ehrbase.rest.ehrscape.responsedata.TemplateExampleResponseData;
import org.ehrbase.rest.ehrscape.responsedata.TemplateResponseData;
import org.ehrbase.rest.ehrscape.responsedata.TemplatesResponseData;
import org.ehrbase.webtemplate.filter.Filter;
import org.ehrbase.webtemplate.model.WebTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/rest/ecis/v1/template"}, produces={"application/json", "application/xml"})
public class TemplateController
extends BaseController {
    private final TemplateService templateService;

    @Autowired
    public TemplateController(TemplateService templateService) {
        this.templateService = Objects.requireNonNull(templateService);
    }

    @GetMapping
    public ResponseEntity<TemplatesResponseData> getTemplate() {
        TemplatesResponseData responseData = new TemplatesResponseData();
        responseData.setAction(Action.LIST);
        responseData.setTemplates(this.templateService.getAllTemplates());
        return ResponseEntity.ok((Object)responseData);
    }

    @PostMapping
    public ResponseEntity<TemplatesResponseData> createTemplate(@RequestBody String content) {
        this.templateService.create(content);
        TemplatesResponseData responseData = new TemplatesResponseData();
        responseData.setAction(Action.LIST);
        responseData.setTemplates(this.templateService.getAllTemplates());
        return ResponseEntity.ok((Object)responseData);
    }

    @GetMapping(path={"/{templateId}/example"})
    public ResponseEntity<TemplateExampleResponseData> getTemplateExample(@PathVariable(value="templateId") String templateId, @RequestParam(value="format", defaultValue="XML") CompositionFormat format) {
        TemplateExampleResponseData responseData = new TemplateExampleResponseData();
        responseData.setComposition(this.templateService.buildExample(templateId, format));
        responseData.setAction(Action.RETRIEVE);
        RestHref url = new RestHref();
        url.setUrl(this.getBaseEnvLinkURL() + "/rest/ecis/v1/template" + templateId + "/example");
        Meta meta = new Meta();
        meta.setHref(url);
        responseData.setMeta(meta);
        return ResponseEntity.ok((Object)responseData);
    }

    @GetMapping(path={"/{templateId}"})
    public ResponseEntity<TemplateResponseData> getTemplate(@PathVariable(value="templateId") String templateId) {
        TemplateResponseData responseData = new TemplateResponseData();
        responseData.setWebTemplate((WebTemplate)new Filter().filter(this.templateService.findTemplate(templateId)));
        responseData.setAction(Action.RETRIEVE);
        RestHref url = new RestHref();
        url.setUrl(this.getBaseEnvLinkURL() + "/rest/ecis/v1/template" + templateId + "/");
        Meta meta = new Meta();
        meta.setHref(url);
        responseData.setMeta(meta);
        return ResponseEntity.ok((Object)responseData);
    }
}

