/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.ehrscape.controller;

import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.service.CompositionService;
import org.ehrbase.response.ehrscape.CompositionDto;
import org.ehrbase.response.ehrscape.CompositionFormat;
import org.ehrbase.response.ehrscape.StructuredString;
import org.ehrbase.rest.ehrscape.controller.BaseController;
import org.ehrbase.rest.ehrscape.responsedata.Action;
import org.ehrbase.rest.ehrscape.responsedata.ActionRestResponseData;
import org.ehrbase.rest.ehrscape.responsedata.CompositionResponseData;
import org.ehrbase.rest.ehrscape.responsedata.CompositionWriteRestResponseData;
import org.ehrbase.rest.ehrscape.responsedata.Meta;
import org.ehrbase.rest.ehrscape.responsedata.RestHref;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/rest/ecis/v1/composition"}, produces={"application/json", "application/xml"})
public class CompositionController
extends BaseController {
    private final CompositionService compositionService;

    public CompositionController(CompositionService compositionService) {
        this.compositionService = Objects.requireNonNull(compositionService);
    }

    @PostMapping
    public ResponseEntity<CompositionWriteRestResponseData> createComposition(@RequestParam(value="format", defaultValue="XML") CompositionFormat format, @RequestParam(value="templateId", required=false) String templateId, @RequestParam(value="ehrId") UUID ehrId, @RequestBody String content) {
        if ((format == CompositionFormat.FLAT || format == CompositionFormat.STRUCTURED || format == CompositionFormat.ECISFLAT) && StringUtils.isEmpty((CharSequence)templateId)) {
            throw new InvalidApiParameterException(String.format("Template Id needs to specified for format %s", format));
        }
        Composition composition = this.compositionService.buildComposition(content, format, templateId);
        UUID compositionUuid = this.compositionService.create(ehrId, (Locatable)composition).map(CompositionDto::getUuid).orElseThrow(() -> new InternalServerException("Failed to create composition"));
        CompositionWriteRestResponseData responseData = new CompositionWriteRestResponseData();
        responseData.setAction(Action.CREATE);
        responseData.setCompositionUid(compositionUuid + "::" + this.compositionService.getServerConfig().getNodename() + "::1");
        responseData.setMeta(this.buildMeta(responseData.getCompositionUid()));
        return ResponseEntity.created((URI)URI.create(responseData.getMeta().getHref().getUrl())).body((Object)responseData);
    }

    @GetMapping(path={"/{uid}"})
    public ResponseEntity<CompositionResponseData> getComposition(@PathVariable(value="uid") String compositionUid, @RequestParam(value="format", defaultValue="XML") CompositionFormat format) {
        Optional compositionDto;
        UUID identifier = this.getCompositionIdentifier(compositionUid);
        Integer version = null;
        if (this.isFullCompositionUid(compositionUid)) {
            version = this.getCompositionVersion(compositionUid);
        }
        if ((compositionDto = this.compositionService.retrieve(identifier, version)).isPresent()) {
            StructuredString serialize = this.compositionService.serialize((CompositionDto)compositionDto.get(), format);
            CompositionResponseData responseDto = new CompositionResponseData();
            responseDto.setComposition(serialize);
            responseDto.setAction(Action.RETRIEVE);
            responseDto.setFormat(format);
            responseDto.setTemplateId(((CompositionDto)compositionDto.get()).getTemplateId());
            responseDto.setCompositionUid(((CompositionDto)compositionDto.get()).getUuid().toString());
            responseDto.setEhrId(((CompositionDto)compositionDto.get()).getEhrId());
            Meta meta = this.buildMeta(responseDto.getCompositionUid());
            responseDto.setMeta(meta);
            return ResponseEntity.ok((Object)responseDto);
        }
        return ResponseEntity.notFound().build();
    }

    @PutMapping(path={"/{uid}"})
    public ResponseEntity<ActionRestResponseData> update(@PathVariable(value="uid") String compositionUid, @RequestParam(value="format", defaultValue="XML") CompositionFormat format, @RequestParam(value="templateId", required=false) String templateId, @RequestBody String content) {
        if ((format == CompositionFormat.FLAT || format == CompositionFormat.STRUCTURED || format == CompositionFormat.ECISFLAT) && StringUtils.isEmpty((CharSequence)templateId)) {
            throw new InvalidApiParameterException(String.format("Template Id needs to specified for format %s", format));
        }
        ObjectVersionId objectVersionId = this.getObjectVersionId(compositionUid);
        UUID compositionIdentifier = this.getCompositionIdentifier(compositionUid);
        UUID ehrId = this.getEhrId(compositionIdentifier);
        Composition compoObj = this.compositionService.buildComposition(content, format, templateId);
        Optional dtoOptional = this.compositionService.update(ehrId, objectVersionId, (Locatable)compoObj);
        String compositionVersionUid = ((CompositionDto)dtoOptional.orElseThrow(() -> new InternalServerException("Failed to create composition"))).getComposition().getUid().toString();
        ActionRestResponseData responseData = new ActionRestResponseData();
        responseData.setAction(Action.UPDATE);
        responseData.setMeta(this.buildMeta(compositionVersionUid));
        return ResponseEntity.ok((Object)responseData);
    }

    @DeleteMapping(path={"/{uid}"})
    public ResponseEntity<ActionRestResponseData> delete(@PathVariable(value="uid") String compositionUid) {
        ObjectVersionId objectVersionId = this.getObjectVersionId(compositionUid);
        UUID compositionIdentifier = this.getCompositionIdentifier(compositionUid);
        UUID ehrId = this.getEhrId(compositionIdentifier);
        this.compositionService.delete(ehrId, objectVersionId);
        ActionRestResponseData responseData = new ActionRestResponseData();
        responseData.setAction(Action.DELETE);
        responseData.setMeta(this.buildMeta(""));
        return ResponseEntity.ok((Object)responseData);
    }

    private UUID getEhrId(UUID compositionId) {
        Optional dtoOptionalForEhr = this.compositionService.retrieve(compositionId, Integer.valueOf(1));
        return ((CompositionDto)dtoOptionalForEhr.orElseThrow(() -> new InvalidApiParameterException("Invalid composition ID."))).getEhrId();
    }

    private ObjectVersionId getLatestVersionId(UUID compositionId) {
        return new ObjectVersionId(compositionId.toString(), this.compositionService.getServerConfig().getNodename(), this.compositionService.getLastVersionNumber(compositionId).toString());
    }

    private Meta buildMeta(String compositionUid) {
        RestHref url = new RestHref();
        url.setUrl(this.getBaseEnvLinkURL() + "/rest/ecis/v1/composition/" + compositionUid);
        Meta meta = new Meta();
        meta.setHref(url);
        return meta;
    }

    private boolean isFullCompositionUid(String compositionUid) {
        return StringUtils.contains((CharSequence)compositionUid, (CharSequence)"::");
    }

    private UUID getCompositionIdentifier(String compositionUid) {
        if (this.isFullCompositionUid(compositionUid)) {
            return UUID.fromString(compositionUid.substring(0, compositionUid.indexOf("::")));
        }
        return UUID.fromString(compositionUid);
    }

    private int getCompositionVersion(String compositionUid) {
        if (!compositionUid.contains("::")) {
            throw new IllegalArgumentException("UID of the composition does not contain domain and version parts");
        }
        return Integer.parseInt(compositionUid.substring(compositionUid.lastIndexOf("::") + 2));
    }

    private ObjectVersionId getObjectVersionId(String compositionUid) {
        if (this.isFullCompositionUid(compositionUid)) {
            return new ObjectVersionId(compositionUid);
        }
        return this.getLatestVersionId(UUID.fromString(compositionUid));
    }
}

