/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.ehrscape.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.nedap.archie.rm.ehr.EhrStatus;
import com.nedap.archie.rm.generic.PartySelf;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.PartyRef;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.response.ehrscape.CompositionFormat;
import org.ehrbase.response.ehrscape.EhrStatusDto;
import org.ehrbase.rest.ehrscape.controller.BaseController;
import org.ehrbase.rest.ehrscape.responsedata.Action;
import org.ehrbase.rest.ehrscape.responsedata.EhrResponseData;
import org.ehrbase.rest.ehrscape.responsedata.Meta;
import org.ehrbase.rest.ehrscape.responsedata.RestHref;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/rest/ecis/v1/ehr"})
public class EhrController
extends BaseController {
    private static final String MODIFIABLE = "modifiable";
    private static final String QUERYABLE = "queryable";
    private final EhrService ehrService;

    public EhrController(EhrService ehrService) {
        this.ehrService = Objects.requireNonNull(ehrService);
    }

    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<EhrResponseData> createEhr(@RequestParam(value="subjectId", required=false) String subjectId, @RequestParam(value="subjectNamespace", required=false) String subjectNamespace, @RequestParam(value="committerId", required=false) String committerId, @RequestParam(value="committerName", required=false) String committerName, @RequestHeader(value="Content-Type", required=false) String contentType, @RequestBody(required=false) String content) {
        if (subjectId == null || subjectNamespace == null) {
            throw new InvalidApiParameterException("subjectId or subjectNamespace missing");
        }
        if (subjectId.isEmpty() || subjectNamespace.isEmpty()) {
            throw new InvalidApiParameterException("subjectId or subjectNamespace emtpy");
        }
        EhrStatus ehrStatus = this.extractEhrStatus(content);
        PartySelf partySelf = new PartySelf(new PartyRef((ObjectId)new HierObjectId(subjectId), subjectNamespace, null));
        ehrStatus.setSubject(partySelf);
        UUID ehrId = this.ehrService.create(ehrStatus, null);
        URI url = URI.create(this.getBaseEnvLinkURL() + "/rest/ecis/v1/ehr/" + ehrId.toString());
        return Optional.ofNullable(ehrId).flatMap(i -> this.buildEhrResponseData((UUID)i, Action.CREATE, contentType)).map(arg_0 -> ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)url)).body(arg_0)).orElse(ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    @GetMapping
    public ResponseEntity<EhrResponseData> getEhr(@RequestParam(value="subjectId") String subjectId, @RequestParam(value="subjectNamespace") String subjectNamespace, @RequestHeader(value="Content-Type", required=false) String contentType) {
        Optional ehrId = this.ehrService.findBySubject(subjectId, subjectNamespace);
        return ehrId.flatMap(i -> this.buildEhrResponseData((UUID)i, Action.RETRIEVE, contentType)).map(ResponseEntity::ok).orElse(ResponseEntity.noContent().build());
    }

    @GetMapping(path={"/{uuid}"})
    public ResponseEntity<EhrResponseData> getEhr(@PathVariable(value="uuid") UUID ehrId, @RequestHeader(value="Content-Type", required=false) String contentType) {
        return Optional.ofNullable(ehrId).flatMap(i -> this.buildEhrResponseData((UUID)i, Action.RETRIEVE, contentType)).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @PutMapping(path={"/{uuid}/status"})
    public ResponseEntity<EhrResponseData> updateStatus(@PathVariable(value="uuid") UUID ehrId, @RequestBody String ehrStatus, @RequestHeader(value="Content-Type", required=false) String contentType) {
        this.ehrService.updateStatus(ehrId, this.extractEhrStatus(ehrStatus), null);
        return Optional.ofNullable(ehrId).flatMap(i -> this.buildEhrResponseData((UUID)i, Action.UPDATE, contentType)).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    private EhrStatus extractEhrStatus(@RequestBody String content) {
        EhrStatus ehrStatus = new EhrStatus();
        if (StringUtils.isNotBlank((CharSequence)content)) {
            Gson json = new GsonBuilder().create();
            Map atributes = (Map)json.fromJson(content, Map.class);
            if (atributes.containsKey(MODIFIABLE)) {
                ehrStatus.setModifiable(((Boolean)atributes.get(MODIFIABLE)).booleanValue());
            }
            if (atributes.containsKey(QUERYABLE)) {
                ehrStatus.setQueryable(((Boolean)atributes.get(QUERYABLE)).booleanValue());
            }
        }
        return ehrStatus;
    }

    private Optional<EhrResponseData> buildEhrResponseData(UUID ehrId, Action create, String contentType) {
        CompositionFormat format;
        if (contentType == null) {
            format = CompositionFormat.RAW;
        } else {
            MediaType mediaType = MediaType.parseMediaType((String)contentType);
            if (mediaType.isCompatibleWith(MediaType.APPLICATION_JSON)) {
                format = CompositionFormat.RAW;
            } else if (mediaType.isCompatibleWith(MediaType.APPLICATION_XML)) {
                format = CompositionFormat.XML;
            } else {
                throw new InvalidApiParameterException("Wrong Content-Type header in request");
            }
        }
        Optional ehrStatus = this.ehrService.getEhrStatusEhrScape(ehrId, format);
        if (!ehrStatus.isPresent()) {
            return Optional.empty();
        }
        EhrResponseData responseData = new EhrResponseData();
        responseData.setAction(create);
        responseData.setEhrId(ehrId);
        responseData.setEhrStatus((EhrStatusDto)ehrStatus.get());
        RestHref url = new RestHref();
        url.setUrl(this.getBaseEnvLinkURL() + "/rest/ecis/v1/ehr/" + responseData.getEhrId());
        Meta meta = new Meta();
        meta.setHref(url);
        responseData.setMeta(meta);
        return Optional.of(responseData);
    }
}

