/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.ehrscape.controller;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ehrbase.api.definitions.QueryMode;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.service.QueryService;
import org.ehrbase.rest.ehrscape.controller.BaseController;
import org.ehrbase.rest.ehrscape.responsedata.Action;
import org.ehrbase.rest.ehrscape.responsedata.QueryResponseData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/rest/ecis/v1/query"}, produces={"application/json", "application/xml"})
public class QueryController
extends BaseController {
    private final QueryService queryService;

    @Autowired
    public QueryController(QueryService queryService) {
        this.queryService = Objects.requireNonNull(queryService);
    }

    @PostMapping
    public ResponseEntity<QueryResponseData> query(@RequestParam(value="explain", defaultValue="false") Boolean explain, @RequestBody String content) {
        String queryString;
        QueryMode queryMode;
        Map<String, String> kvPairs = QueryController.extractQuery(new String(content.getBytes()));
        if (kvPairs.containsKey(QueryMode.AQL.getCode())) {
            queryMode = QueryMode.AQL;
            queryString = kvPairs.get(QueryMode.AQL.getCode());
        } else if (kvPairs.containsKey(QueryMode.SQL.getCode())) {
            queryMode = QueryMode.SQL;
            queryString = kvPairs.get(QueryMode.SQL.getCode());
        } else {
            throw new InvalidApiParameterException("No query parameter supplied");
        }
        QueryResponseData responseData = new QueryResponseData(this.queryService.query(queryString, null, queryMode, explain.booleanValue(), new HashMap()));
        responseData.setAction(Action.EXECUTE);
        return ResponseEntity.ok((Object)responseData);
    }

    private static Map<String, String> extractQuery(String content) {
        Pattern patternKey = Pattern.compile("(?<=\\\")(.*?)(?=\")");
        Matcher matcherKey = patternKey.matcher(content);
        if (matcherKey.find()) {
            String type = matcherKey.group(1);
            String query = content.substring(content.indexOf(58) + 1, content.lastIndexOf(34));
            query = query.substring(query.indexOf(34) + 1);
            HashMap<String, String> queryMap = new HashMap<String, String>();
            queryMap.put(type.toLowerCase(), query);
            return queryMap;
        }
        throw new IllegalArgumentException("Could not identified query type (sql or aql) in content:" + content);
    }
}

