/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.ehrscape.controller;

import java.util.HashMap;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ehrbase.api.authorization.EhrbaseAuthorization;
import org.ehrbase.api.authorization.EhrbasePermission;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.service.QueryService;
import org.ehrbase.rest.ehrscape.controller.BaseController;
import org.ehrbase.rest.ehrscape.responsedata.Action;
import org.ehrbase.rest.ehrscape.responsedata.QueryResponseData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/rest/ecis/v1/query"}, produces={"application/json", "application/xml"})
public class QueryController
extends BaseController {
    private final QueryService queryService;

    @Autowired
    public QueryController(QueryService queryService) {
        this.queryService = Objects.requireNonNull(queryService);
    }

    @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_QUERY_SEARCH_AD_HOC)
    @PostMapping
    public ResponseEntity<QueryResponseData> query(@RequestParam(value="explain", defaultValue="false") Boolean explain, @RequestBody String content) {
        String aqlString = QueryController.extractQuery(content);
        QueryResponseData responseData = new QueryResponseData(this.queryService.query(aqlString, null, explain.booleanValue(), new HashMap()));
        responseData.setAction(Action.EXECUTE);
        return ResponseEntity.ok((Object)responseData);
    }

    private static String extractQuery(String content) {
        Pattern patternKey = Pattern.compile("(?<=\\\")(.*?)(?=\")");
        Matcher matcherKey = patternKey.matcher(content);
        if (!matcherKey.find()) {
            throw new IllegalArgumentException("Could not identified query type in content: " + content);
        }
        String type = matcherKey.group(1);
        if ("aql".equalsIgnoreCase(type)) {
            String query = content.substring(content.indexOf(58) + 1, content.lastIndexOf(34));
            return query.substring(query.indexOf(34) + 1);
        }
        if ("sql".equalsIgnoreCase(type)) {
            throw new InvalidApiParameterException("SQL queries are no longer supported");
        }
        throw new InvalidApiParameterException("No query parameter supplied");
    }
}

