/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.ehrscape.controller;

import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.service.CompositionService;
import org.ehrbase.api.service.SystemService;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.CompositionDto;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.CompositionFormat;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.StructuredString;
import org.ehrbase.rest.ehrscape.controller.BaseController;
import org.ehrbase.rest.ehrscape.responsedata.Action;
import org.ehrbase.rest.ehrscape.responsedata.ActionRestResponseData;
import org.ehrbase.rest.ehrscape.responsedata.CompositionResponseData;
import org.ehrbase.rest.ehrscape.responsedata.CompositionWriteRestResponseData;
import org.ehrbase.rest.ehrscape.responsedata.Meta;
import org.ehrbase.rest.ehrscape.responsedata.RestHref;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@ConditionalOnMissingBean(name={"primarycompositioncontroller"})
@RestController
@RequestMapping(path={"/rest/ecis/v1/composition"}, produces={"application/json", "application/xml"})
@Tag(name="COMPOSITION")
public class CompositionController
extends BaseController {
    private final CompositionService compositionService;
    private final SystemService systemService;

    public CompositionController(CompositionService compositionService, SystemService systemService) {
        this.compositionService = Objects.requireNonNull(compositionService);
        this.systemService = systemService;
    }

    @PostMapping
    @Operation(summary="Deprecated since 2.0.0 and marked for removal", description="Replaced by [/rest/openehr/v1/ehr/{ehr_id}/composition](./index.html?urls.primaryName=1.%20openEHR%20API#/COMPOSITION/createComposition)", deprecated=true)
    @Deprecated(since="2.0.0", forRemoval=true)
    public ResponseEntity<CompositionWriteRestResponseData> createComposition(@RequestParam(value="format", defaultValue="XML") CompositionFormat format, @RequestParam(value="templateId", required=false) String templateId, @RequestParam(value="ehrId") UUID ehrId, @RequestBody String content) {
        if ((format == CompositionFormat.FLAT || format == CompositionFormat.STRUCTURED || format == CompositionFormat.ECISFLAT) && StringUtils.isEmpty((CharSequence)templateId)) {
            throw new InvalidApiParameterException(String.format("Template Id needs to specified for format %s", format));
        }
        Composition composition = this.compositionService.buildComposition(content, format, templateId);
        UUID compositionUuid = (UUID)this.compositionService.create(ehrId, (Locatable)composition).orElseThrow(() -> new InternalServerException("Failed to create composition"));
        CompositionWriteRestResponseData responseData = new CompositionWriteRestResponseData();
        responseData.setAction(Action.CREATE);
        responseData.setCompositionUid(String.valueOf(compositionUuid) + "::" + this.systemService.getSystemId() + "::1");
        responseData.setMeta(this.buildMeta(responseData.getCompositionUid()));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)URI.create(responseData.getMeta().getHref().getUrl())).headers(this.deprecationHeaders("COMPOSITION/createComposition", "COMPOSITION/createComposition"))).body((Object)responseData);
    }

    @GetMapping(path={"/{uid}"})
    @Operation(summary="Deprecated since 2.0.0 and marked for removal", description="Replaced by [/rest/openehr/v1/ehr/{ehr_id}/composition/{versioned_object_uid}](./index.html?urls.primaryName=1.%20openEHR%20API#/COMPOSITION/getComposition)", deprecated=true)
    @Deprecated(since="2.0.0", forRemoval=true)
    public ResponseEntity<CompositionResponseData> getComposition(@PathVariable(value="uid") String compositionUid, @RequestParam(value="format", defaultValue="XML") CompositionFormat format) {
        UUID ehrId;
        Optional<CompositionDto> compositionDto;
        UUID identifier = this.getCompositionIdentifier(compositionUid);
        Integer version = null;
        if (this.isFullCompositionUid(compositionUid)) {
            version = this.getCompositionVersion(compositionUid);
        }
        if ((compositionDto = this.compositionService.retrieve(ehrId = this.getEhrIdForComposition(identifier), identifier, version).map(c -> CompositionService.from((UUID)ehrId, (Composition)c))).isPresent()) {
            StructuredString serialize = this.compositionService.serialize(compositionDto.get(), format);
            CompositionResponseData responseDto = new CompositionResponseData();
            responseDto.setComposition(serialize);
            responseDto.setAction(Action.RETRIEVE);
            responseDto.setFormat(format);
            responseDto.setTemplateId(compositionDto.get().getTemplateId());
            String fullUid = String.valueOf(compositionDto.get().getUuid()) + "::" + this.systemService.getSystemId() + "::" + this.compositionService.getLastVersionNumber(compositionDto.get().getUuid());
            responseDto.setCompositionUid(fullUid);
            responseDto.setEhrId(compositionDto.get().getEhrId());
            Meta meta = this.buildMeta(responseDto.getCompositionUid());
            responseDto.setMeta(meta);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.deprecationHeaders("COMPOSITION/getComposition", "COMPOSITION/getComposition"))).body((Object)responseDto);
        }
        return ResponseEntity.notFound().headers(this.deprecationHeaders("COMPOSITION/getComposition", "COMPOSITION/getComposition")).build();
    }

    @PutMapping(path={"/{uid}"})
    @Operation(summary="Deprecated since 2.0.0 and marked for removal", description="Replaced by [/rest/openehr/v1/ehr/{ehr_id}/composition/{versioned_object_uid}](./index.html?urls.primaryName=1.%20openEHR%20API#/COMPOSITION/updateComposition)", deprecated=true)
    @Deprecated(since="2.0.0", forRemoval=true)
    public ResponseEntity<ActionRestResponseData> update(@PathVariable(value="uid") String compositionUid, @RequestParam(value="format", defaultValue="XML") CompositionFormat format, @RequestParam(value="templateId", required=false) String templateId, @RequestBody String content) {
        if ((format == CompositionFormat.FLAT || format == CompositionFormat.STRUCTURED || format == CompositionFormat.ECISFLAT) && StringUtils.isEmpty((CharSequence)templateId)) {
            throw new InvalidApiParameterException(String.format("Template Id needs to specified for format %s", format));
        }
        ObjectVersionId objectVersionId = this.getObjectVersionId(compositionUid);
        UUID compositionIdentifier = this.getCompositionIdentifier(compositionUid);
        UUID ehrId = this.getEhrIdForComposition(compositionIdentifier);
        Composition compoObj = this.compositionService.buildComposition(content, format, templateId);
        Optional dtoOptional = this.compositionService.update(ehrId, objectVersionId, (Locatable)compoObj);
        String compositionVersionUid = ((UUID)dtoOptional.orElseThrow(() -> new InternalServerException("Failed to create composition"))).toString();
        ActionRestResponseData responseData = new ActionRestResponseData();
        responseData.setAction(Action.UPDATE);
        responseData.setMeta(this.buildMeta(compositionVersionUid));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.deprecationHeaders("COMPOSITION/update", "COMPOSITION/updateComposition"))).body((Object)responseData);
    }

    @DeleteMapping(path={"/{uid}"})
    @Operation(summary="Deprecated since 2.0.0 and marked for removal", description="Replaced by [/rest/openehr/v1/ehr/{ehr_id}/composition/{versioned_object_uid}](./index.html?urls.primaryName=1.%20openEHR%20API#/COMPOSITION/deleteComposition)", deprecated=true)
    @Deprecated(since="2.0.0", forRemoval=true)
    public ResponseEntity<ActionRestResponseData> delete(@PathVariable(value="uid") String compositionUid) {
        ObjectVersionId objectVersionId = this.getObjectVersionId(compositionUid);
        UUID compositionIdentifier = this.getCompositionIdentifier(compositionUid);
        UUID ehrId = this.getEhrIdForComposition(compositionIdentifier);
        this.compositionService.delete(ehrId, objectVersionId);
        ActionRestResponseData responseData = new ActionRestResponseData();
        responseData.setAction(Action.DELETE);
        responseData.setMeta(this.buildMeta(""));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.deprecationHeaders("COMPOSITION/delete", "COMPOSITION/deleteComposition"))).body((Object)responseData);
    }

    private ObjectVersionId getLatestVersionId(UUID compositionId) {
        return new ObjectVersionId(compositionId.toString(), this.systemService.getSystemId(), Integer.toString(this.compositionService.getLastVersionNumber(compositionId)));
    }

    private Meta buildMeta(String compositionUid) {
        RestHref url = new RestHref();
        url.setUrl(this.createLocationUri("composition", compositionUid));
        Meta meta = new Meta();
        meta.setHref(url);
        return meta;
    }

    private boolean isFullCompositionUid(String compositionUid) {
        return StringUtils.contains((CharSequence)compositionUid, (CharSequence)"::");
    }

    private UUID getCompositionIdentifier(String compositionUid) {
        if (this.isFullCompositionUid(compositionUid)) {
            return UUID.fromString(compositionUid.substring(0, compositionUid.indexOf("::")));
        }
        return UUID.fromString(compositionUid);
    }

    private int getCompositionVersion(String compositionUid) {
        if (!compositionUid.contains("::")) {
            throw new IllegalArgumentException("UID of the composition does not contain domain and version parts");
        }
        return Integer.parseInt(compositionUid.substring(compositionUid.lastIndexOf("::") + 2));
    }

    private ObjectVersionId getObjectVersionId(String compositionUid) {
        if (this.isFullCompositionUid(compositionUid)) {
            return new ObjectVersionId(compositionUid);
        }
        return this.getLatestVersionId(UUID.fromString(compositionUid));
    }

    private UUID getEhrIdForComposition(UUID compositionUid) {
        return (UUID)this.compositionService.getEhrIdForComposition(compositionUid).orElseThrow(() -> new ObjectNotFoundException("Composition", "Composition with id %s does not exist".formatted(compositionUid)));
    }
}

