/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.ehrscape.controller;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

public abstract class BaseController {
    public static final String TEMPLATE = "template";
    public static final String API_ECIS_CONTEXT_PATH_WITH_VERSION = "/rest/ecis/v1";
    public static final String COMPOSITION = "composition";
    private static final String SWAGGER_EHR_SCAPE_API = "swagger-ui/index.html?urls.primaryName=2.%20EhrScape%20API#";
    private static final String SWAGGER_OPENEHR_API = "swagger-ui/index.html?urls.primaryName=1.%20openEHR%20API#";

    protected String getContextPath() {
        return ServletUriComponentsBuilder.fromCurrentContextPath().build().toUriString();
    }

    protected String createLocationUri(String ... pathSegments) {
        return UriComponentsBuilder.fromHttpUrl((String)this.getContextPath()).path(API_ECIS_CONTEXT_PATH_WITH_VERSION).pathSegment(pathSegments).build().toUriString();
    }

    protected HttpHeaders deprecationHeaders(String deprecatedPath, String successorVersion) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Deprecated", "Mon, 22 Jan 2024 00:00:00 GMT");
        List<String> links = List.of("<%s/%s/%s>; rel=\"deprecation\"; type=\"text/html\"".formatted(this.getContextPath(), SWAGGER_EHR_SCAPE_API, UriUtils.encode((String)deprecatedPath, (Charset)StandardCharsets.US_ASCII)), "<%s/%s/%s>; rel=\"successor-version\"".formatted(this.getContextPath(), SWAGGER_OPENEHR_API, UriUtils.encode((String)successorVersion, (Charset)StandardCharsets.US_ASCII)));
        headers.add("Link", String.join((CharSequence)", ", links));
        return headers;
    }
}

