/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.ehrscape;

import java.net.URI;
import java.nio.file.AccessDeniedException;
import java.util.HashMap;
import org.ehrbase.api.exception.AqlFeatureNotImplementedException;
import org.ehrbase.api.exception.GeneralRequestProcessingException;
import org.ehrbase.api.exception.IllegalAqlException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.NotAcceptableException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.PreconditionFailedException;
import org.ehrbase.api.exception.StateConflictException;
import org.ehrbase.api.exception.UnprocessableEntityException;
import org.ehrbase.api.exception.UnsupportedMediaTypeException;
import org.ehrbase.api.exception.ValidationException;
import org.ehrbase.openehr.sdk.serialisation.exception.UnmarshalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.server.ResponseStatusException;

@RestControllerAdvice(basePackages={"org.ehrbase.rest.ehrscape.controller"})
@Order(value=-2147483648)
public class EhrScapeExceptionHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @ExceptionHandler(value={HttpMessageNotReadableException.class, MethodArgumentTypeMismatchException.class, MissingServletRequestPartException.class, BindException.class, ServletRequestBindingException.class, IllegalArgumentException.class, GeneralRequestProcessingException.class, InvalidApiParameterException.class, UnprocessableEntityException.class, ValidationException.class, UnmarshalException.class, AqlFeatureNotImplementedException.class, IllegalAqlException.class})
    public ResponseEntity<Object> handleBadRequestExceptions(Exception ex) {
        return this.handleExceptionInternal(ex, ex.getMessage(), new HttpHeaders(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public ResponseEntity<Object> handleObjectNotFoundException(AccessDeniedException ex) {
        return this.handleExceptionInternal(ex, ex.getMessage(), new HttpHeaders(), (HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={ObjectNotFoundException.class})
    public ResponseEntity<Object> handleObjectNotFoundException(ObjectNotFoundException ex) {
        return this.handleExceptionInternal((Exception)ex, ex.getMessage(), new HttpHeaders(), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class, NotAcceptableException.class})
    public ResponseEntity<Object> handleNotAcceptableException(NotAcceptableException ex) {
        return this.handleExceptionInternal((Exception)ex, ex.getMessage(), new HttpHeaders(), (HttpStatusCode)HttpStatus.NOT_ACCEPTABLE);
    }

    @ExceptionHandler(value={StateConflictException.class})
    public ResponseEntity<Object> handleStateConflictException(StateConflictException ex) {
        return this.handleExceptionInternal((Exception)ex, ex.getMessage(), new HttpHeaders(), (HttpStatusCode)HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={PreconditionFailedException.class})
    public ResponseEntity<Object> handlePreconditionFailedException(PreconditionFailedException ex) {
        HttpHeaders headers = new HttpHeaders();
        if (ex.getUrl() != null && ex.getCurrentVersionUid() != null) {
            headers.setETag("\"" + ex.getCurrentVersionUid() + "\"");
            headers.setLocation(URI.create(ex.getUrl()));
        }
        return this.handleExceptionInternal((Exception)ex, ex.getMessage(), headers, (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class, UnsupportedMediaTypeException.class})
    public ResponseEntity<Object> handleUnsupportedMediaTypeException(UnsupportedMediaTypeException ex) {
        return this.handleExceptionInternal((Exception)ex, ex.getMessage(), new HttpHeaders(), (HttpStatusCode)HttpStatus.UNSUPPORTED_MEDIA_TYPE);
    }

    @ExceptionHandler(value={ResponseStatusException.class})
    public ResponseEntity<Object> handleSpringResponseStatusException(ResponseStatusException ex) {
        return this.handleExceptionInternal((Exception)ex, ex.getReason(), ex.getResponseHeaders(), ex.getStatusCode());
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Object> handleUncaughtException(Exception ex) {
        String message = "An internal error has occurred. Please contact your administrator.";
        return this.handleExceptionInternal(ex, message, new HttpHeaders(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private ResponseEntity<Object> handleExceptionInternal(Exception ex, String message, HttpHeaders headers, HttpStatusCode status) {
        if (status.is5xxServerError()) {
            this.logger.error("", (Throwable)ex);
        } else {
            this.logger.warn(ex.getMessage());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Exception stack trace", (Throwable)ex);
            }
        }
        HashMap<String, String> body = new HashMap<String, String>();
        if (status instanceof HttpStatus) {
            HttpStatus httpStatus = (HttpStatus)status;
            body.put("error", httpStatus.getReasonPhrase());
        }
        body.put("message", message);
        return new ResponseEntity(body, (MultiValueMap)headers, status);
    }
}

