/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.ehrbase.api.service.QueryService;
import org.ehrbase.rest.openehr.controller.BaseController;
import org.ehrbase.rest.openehr.response.ErrorBodyPayload;
import org.ehrbase.rest.openehr.response.QueryDefinitionListResponseData;
import org.ehrbase.rest.openehr.response.QueryDefinitionResponseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Stored Query"})
@RestController
@RequestMapping(path={"/rest/openehr/v1/definition/query"}, produces={"application/json", "application/xml"})
public class OpenehrDefinitionQueryController
extends BaseController {
    static final Logger log = LoggerFactory.getLogger(OpenehrDefinitionQueryController.class);
    private QueryService queryService;

    @Autowired
    public OpenehrDefinitionQueryController(QueryService queryService) {
        this.queryService = Objects.requireNonNull(queryService);
    }

    @RequestMapping(value={"/{qualified_query_name}", ""}, method={RequestMethod.GET})
    @ApiOperation(value="List stored queries", response=QueryDefinitionResponseData.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class)})})
    public ResponseEntity<QueryDefinitionListResponseData> getStoredQueryList(@ApiParam(value="Client should specify expected format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="query name to be listed, example: org.openehr::compositions", required=false) @PathVariable(value="qualified_query_name", required=false) String qualifiedQueryName) {
        log.debug("getStoredQueryList invoked with the following input: " + qualifiedQueryName);
        QueryDefinitionListResponseData responseData = new QueryDefinitionListResponseData(this.queryService.retrieveStoredQueries(qualifiedQueryName));
        return ResponseEntity.ok((Object)responseData);
    }

    @RequestMapping(value={"/{qualified_query_name}/{version}"}, method={RequestMethod.GET})
    @ApiOperation(value="Get stored query and info/metadata", response=QueryDefinitionResponseData.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class)}), @ApiResponse(code=400, message="Invalid input, e.g. a request with missing required field q or invalid query syntax."), @ApiResponse(code=404, message="The specified query doesn't exist.")})
    public ResponseEntity<QueryDefinitionResponseData> getStoredQueryVersion(@ApiParam(value="Client should specify expected format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="query name to be listed, example: org.openehr::compositions", required=true) @PathVariable(value="qualified_query_name") String qualifiedQueryName, @ApiParam(value="query version (SEMVER), example: 1.2.3") @PathVariable(value="version") Optional<String> version) {
        log.debug("getStoredQueryVersion invoked with the following input: " + qualifiedQueryName + ", version:" + version);
        QueryDefinitionResponseData queryDefinitionResponseData = new QueryDefinitionResponseData(this.queryService.retrieveStoredQuery(qualifiedQueryName, version.isPresent() ? version.get() : null));
        return ResponseEntity.ok((Object)queryDefinitionResponseData);
    }

    @RequestMapping(value={"/{qualified_query_name}/{version}{?type}", "/{qualified_query_name}{?type}"}, method={RequestMethod.PUT})
    @ApiOperation(value="Store a query", response=QueryDefinitionResponseData.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class)}), @ApiResponse(code=400, message="Invalid input, e.g. a request with missing required field q or invalid query syntax."), @ApiResponse(code=409, message="Query already exists.")})
    public ResponseEntity<QueryDefinitionResponseData> putStoreQuery(@ApiParam(value="Client should specify expected format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="query name to store, example: org.openehr::compositions", required=true) @PathVariable(value="qualified_query_name") String qualifiedQueryName, @ApiParam(value="query version (SEMVER), example: 1.2.3") @PathVariable(value="version") Optional<String> version, @ApiParam(value="query type (default AQL)") @RequestParam(value="type", required=false, defaultValue="AQL") String type, @ApiParam(value="The query to store", required=true) @RequestBody String queryPayload) {
        log.debug("putStoreQuery invoked with the following input: " + qualifiedQueryName + ", version:" + version + ", query:" + queryPayload + ", type=" + type);
        Gson gson = new GsonBuilder().create();
        Map mapped = (Map)gson.fromJson(queryPayload, Map.class);
        String aql = (String)mapped.get("q");
        if (aql == null || aql.isEmpty()) {
            return new ResponseEntity((Object)new ErrorBodyPayload("Invalid query", "no aql query provided in payload").toString(), HttpStatus.BAD_REQUEST);
        }
        QueryDefinitionResponseData queryDefinitionResponseData = new QueryDefinitionResponseData(this.queryService.createStoredQuery(qualifiedQueryName, version.isPresent() ? version.get() : null, aql));
        return ResponseEntity.ok((Object)queryDefinitionResponseData);
    }

    @RequestMapping(value={"/{qualified_query_name}/{version}"}, method={RequestMethod.DELETE})
    @ApiOperation(value="Delete a query", response=QueryDefinitionResponseData.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class)}), @ApiResponse(code=400, message="Invalid input, e.g. a request with missing required field q or invalid query syntax."), @ApiResponse(code=409, message="Query already exists.")})
    public ResponseEntity<QueryDefinitionResponseData> deleteStoredQuery(@ApiParam(value="Client should specify expected format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="query name to store, example: org.openehr::compositions", required=true) @PathVariable(value="qualified_query_name") String qualifiedQueryName, @ApiParam(value="query version (SEMVER), example: 1.2.3", required=true) @PathVariable(value="version") String version) {
        log.debug("deleteStoredQuery for the following input: " + qualifiedQueryName + ", version:" + version);
        QueryDefinitionResponseData queryDefinitionResponseData = new QueryDefinitionResponseData(this.queryService.deleteStoredQuery(qualifiedQueryName, version));
        return ResponseEntity.ok((Object)queryDefinitionResponseData);
    }
}

