/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr.controller;

import com.nedap.archie.rm.directory.Folder;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import java.net.URI;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import org.ehrbase.api.dto.FolderDto;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.api.service.FolderService;
import org.ehrbase.rest.openehr.annotation.RequestUrl;
import org.ehrbase.rest.openehr.controller.BaseController;
import org.ehrbase.rest.openehr.controller.OperationNotesResourcesReaderOpenehr;
import org.ehrbase.rest.openehr.response.DirectoryResponseData;
import org.ehrbase.rest.openehr.response.ErrorResponseData;
import org.ehrbase.rest.openehr.util.VersionUidHelper;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Directory"})
@RestController
@RequestMapping(path={"/rest/openehr/v1/ehr"})
public class OpenehrDirectoryController
extends BaseController {
    private final FolderService folderService;
    private final EhrService ehrService;

    @Autowired
    public OpenehrDirectoryController(FolderService folderService, EhrService ehrService) {
        this.folderService = Objects.requireNonNull(folderService);
        this.ehrService = Objects.requireNonNull(ehrService);
    }

    @PostMapping(value={"/{ehr_id}/directory"})
    @ApiOperation(value="Create a new directory folder associated with the EHR identified by ehr_id.")
    @OperationNotesResourcesReaderOpenehr.ApiNotes(value="directoryPost.md")
    @ApiResponses(value={@ApiResponse(code=201, response=DirectoryResponseData.class, message="Created successfully - new FOLDER created was created. Content body is only returned when Prefer header has return=representation, otherwise only headers are returned.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="Location", description="Location of resource", response=URI.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class), @ResponseHeader(name="Last-Modified", description="Time of last modification of resource", response=long.class)}), @ApiResponse(code=204, message="No Content - New FOLDER was created but not full representation requested. Details in response headers.", responseHeaders={@ResponseHeader(name="Location", description="Location of resource", response=URI.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class), @ResponseHeader(name="Last-Modified", description="Time of last modification of resource", response=long.class)}), @ApiResponse(code=400, message="Bad Request - New FOLDER could not be created due to a malformed request data. Request must be modified to match the expected formats.", response=ErrorResponseData.class), @ApiResponse(code=404, message="Not Found - New FOLDER could not be created due to the EHR identified by the ehr_id could not be found.", response=ErrorResponseData.class)})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<DirectoryResponseData> createFolder(@ApiParam(value="Optional custom request header for versioning") @RequestHeader(value="openEHR-VERSION", required=false) String openEhrVersion, @ApiParam(value="Optional custom request header for auditing") @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openEhrAuditDetails, @ApiParam(value="Format of transferred body") @RequestHeader(value="Content-Type") String contentType, @ApiParam(value="Client should specify expected format") @RequestHeader(value="Accept", required=false, defaultValue="application/json") String accept, @ApiParam(value="May be used by clients for resource representation negotiation") @RequestHeader(value="PREFER", required=false, defaultValue="return=minimal") String prefer, @ApiParam(value="EHR identifier from resource path after ehr/", required=true) @PathVariable(value="ehr_id") UUID ehrId, @ApiParam(value="The FOLDER to create.", required=true) @RequestBody Folder folder) {
        if (!this.ehrService.doesEhrExist(ehrId)) {
            throw new ObjectNotFoundException("ehr", "EHR with id " + ehrId + " not found.");
        }
        UUID folderId = this.folderService.create(ehrId, folder);
        Optional newFolder = this.folderService.retrieve(folderId, Integer.valueOf(1), null);
        if (newFolder.isEmpty()) {
            throw new InternalServerException("Something went wrong. Folder could be persisted but not fetched again.");
        }
        return this.createDirectoryResponse(HttpMethod.POST, prefer, accept, (FolderDto)newFolder.get(), ehrId);
    }

    @GetMapping(path={"/{ehr_id}/directory/{version_uid}{?path}"})
    @ApiOperation(value="Get an existing FOLDER in EHR identified by id ")
    @ApiResponses(value={@ApiResponse(code=200, response=DirectoryResponseData.class, message="Success - FOLDER found and will be returned inside response body.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="Location", description="Location of resource", response=URI.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class), @ResponseHeader(name="Last-Modified", description="Time of last modification of resource", response=long.class)}), @ApiResponse(code=204, message="No Content - No FOLDER found at specified path."), @ApiResponse(code=404, message="Not Found - Either specified EHR with ehr_id or directory with the directory_id do not exist.")})
    public ResponseEntity<DirectoryResponseData> getFolder(@ApiParam(value="Client should specify expected format") @RequestHeader(value="Accept", required=false, defaultValue="application/json") String accept, @ApiParam(value="EHR identifier from resource path after ehr/", required=true) @PathVariable(value="ehr_id") UUID ehrId, @ApiParam(value="DIRECTORY identifier from resource path after directory/", required=true) @PathVariable(value="version_uid") String versionUid, @ApiParam(value="Path parameter to specify a subfolder at directory") @RequestParam(value="path", required=false) String path) {
        if (path != null && !this.isValidPath(path)) {
            throw new IllegalArgumentException("Value for path is malformed. Expecting a unix like notation, e.g. '/episodes/a/b/c'");
        }
        UUID versionUUID = this.extractVersionedObjectUidFromVersionUid(versionUid);
        if (!this.ehrService.doesEhrExist(ehrId)) {
            throw new ObjectNotFoundException("ehr", "EHR with id " + ehrId + " not found.");
        }
        Optional foundFolder = this.folderService.retrieve(versionUUID, Integer.valueOf(1), path);
        if (foundFolder.isEmpty()) {
            throw new ObjectNotFoundException("folder", "The FOLDER with id " + versionUUID.toString() + " does not exist.");
        }
        return this.createDirectoryResponse(HttpMethod.GET, "return=representation", accept, (FolderDto)foundFolder.get(), ehrId);
    }

    @GetMapping(path={"/{ehr_id}/directory{?version_at_time,path}"})
    @ApiOperation(value="Get an existing FOLDER in EHR which was actual at given version at time.")
    @ApiResponses(value={@ApiResponse(code=200, response=DirectoryResponseData.class, message="Success - FOLDER found and will be returned inside response body.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="Location", description="Location of resource", response=URI.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class), @ResponseHeader(name="Last-Modified", description="Time of last modification of resource", response=long.class)}), @ApiResponse(code=204, message="No Content - EHR has no version at time or no folder at path"), @ApiResponse(code=404, message="Not Found - Specified EHR with ehr_id does not exist.")})
    public ResponseEntity<DirectoryResponseData> getFolderVersionAtTime(@ApiParam(value="Client should specify expected format") @RequestHeader(value="Accept", required=false, defaultValue="application/json") String accept, @ApiParam(value="EHR identifier from resource path after ehr/", required=true) @PathVariable(value="ehr_id") UUID ehrId, @ApiParam(value="Timestamp in extended ISO8601 format to identify version of folder.") @RequestParam(value="version_at_time", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) ZonedDateTime versionAtTime, @ApiParam(value="Path parameter to specify a subfolder at directory") @RequestParam(value="path", required=false) String path) {
        if (path != null && !this.isValidPath(path)) {
            throw new IllegalArgumentException("Value for path is malformed. Expecting a unix like notation, e.g. '/episodes/a/b/c'");
        }
        UUID rootDirectoryId = this.ehrService.getDirectoryId(ehrId);
        Optional foundFolder = versionAtTime != null ? this.folderService.retrieveByTimestamp(rootDirectoryId, Timestamp.from(versionAtTime.toInstant()), path) : this.folderService.retrieveLatest(ehrId, path);
        if (foundFolder.isEmpty()) {
            throw new ObjectNotFoundException("folder", "The FOLDER for ehrId " + ehrId.toString() + " does not exist.");
        }
        return this.createDirectoryResponse(HttpMethod.GET, "return=representation", accept, (FolderDto)foundFolder.get(), ehrId);
    }

    @PutMapping(path={"/{ehr_id}/directory"})
    @ApiOperation(value="Update an existing folder in directory. The folder will be identified by the latest version_uid specified in the If-Match header")
    @OperationNotesResourcesReaderOpenehr.ApiNotes(value="directoryPut.md")
    @ApiResponses(value={@ApiResponse(code=200, response=DirectoryResponseData.class, message="Success - FOLDER has been updated successfully.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="Location", description="Location of resource", response=URI.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class), @ResponseHeader(name="Last-Modified", description="Time of last modification of resource", response=long.class)}), @ApiResponse(code=204, message="Success - FOLDER has been updated successfully but no representation has been requested. Details at response headers.", responseHeaders={@ResponseHeader(name="Location", description="Location of resource", response=URI.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class), @ResponseHeader(name="Last-Modified", description="Time of last modification of resource", response=long.class)}), @ApiResponse(code=400, response=ErrorResponseData.class, message="Bad Request - FOLDER could not be updated due to one or more malformed request parameters or data."), @ApiResponse(code=404, response=ErrorResponseData.class, message="Not Found - EHR with given id from path could not be found."), @ApiResponse(code=412, response=ErrorResponseData.class, message="Precondition failed - The version specified in the If-Match header does not match the latest version of the FOLDER. Returns the latest version_uid in Location and ETag header.", responseHeaders={@ResponseHeader(name="Location", description="Location of resource", response=URI.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=URI.class)})})
    public ResponseEntity<DirectoryResponseData> updateFolder(@ApiParam(value="Optional custom request header for versioning") @RequestHeader(value="openEHR-VERSION", required=false) String openEhrVersion, @ApiParam(value="Optional custom request header for auditing") @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openEhrAuditDetails, @ApiParam(value="Format of transferred body") @RequestHeader(value="Content-Type") String contentType, @ApiParam(value="Client should specify expected format") @RequestHeader(value="Accept", required=false, defaultValue="application/json") String accept, @ApiParam(value="May be used by clients for resource representation negotiation") @RequestHeader(value="PREFER", required=false, defaultValue="return=minimal") String prefer, @ApiParam(value="{preceding_version_uid}", required=true) @RequestHeader(value="If-Match") String ifMatch, @ApiParam(value="EHR identifier from resource path after ehr/", required=true) @PathVariable(value="ehr_id") UUID ehrId, @ApiParam(value="Update data for the target FOLDER") @RequestBody Folder folder, @RequestUrl String requestUrl) {
        if (!this.ehrService.doesEhrExist(ehrId)) {
            throw new ObjectNotFoundException("ehr", "EHR with id " + ehrId + " not found");
        }
        UUID folderId = this.extractVersionedObjectUidFromVersionUid(ifMatch);
        Optional updatedFolder = this.folderService.update(folderId, folder, ehrId);
        if (updatedFolder.isEmpty()) {
            throw new InternalServerException("Something went wrong. Folder could be persisted but not fetched again.");
        }
        return this.createDirectoryResponse(HttpMethod.PUT, prefer, accept, (FolderDto)updatedFolder.get(), ehrId);
    }

    @DeleteMapping(path={"/{ehr_id}/directory"})
    @ApiOperation(value="Delete an existing folder in directory. The folder will be identified by the latest version_uid specified in the If-Match header")
    @ApiResponses(value={@ApiResponse(code=204, message="Success - DIRECTORY has been deleted successfully.", responseHeaders={@ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class), @ResponseHeader(name="Last-Modified", description="Time of last modification of resource", response=long.class)}), @ApiResponse(code=400, response=ErrorResponseData.class, message="Bad Request - FOLDER could not be deleted due to one or more malformed request parameters or data."), @ApiResponse(code=404, response=ErrorResponseData.class, message="Not Found - EHR with given id from path could not be found."), @ApiResponse(code=412, response=ErrorResponseData.class, message="Precondition failed - The version specified in the If-Match header does not match the latest version of the FOLDER. Returns the latest version_uid in Location and ETag header.", responseHeaders={@ResponseHeader(name="Location", description="Location of resource", response=URI.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=URI.class)})})
    public ResponseEntity deleteFolder(@ApiParam(value="Optional custom request header for versioning") @RequestHeader(value="openEHR-VERSION", required=false) String openEhrVersion, @ApiParam(value="Optional custom request header for auditing") @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openEhrAuditDetails, @ApiParam(value="Client should specify expected format") @RequestHeader(value="Accept", required=false, defaultValue="application/json") String accept, @ApiParam(value="{preceding_version_uid}", required=true) @RequestHeader(value="If-Match") String ifMatch, @ApiParam(value="EHR identifier from resource path after ehr/", required=true) @PathVariable(value="ehr_id") String ehrIdString) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        if (!this.ehrService.doesEhrExist(ehrId)) {
            throw new ObjectNotFoundException("EHR with id " + ehrIdString + " not found", "FOLDER");
        }
        this.folderService.delete(VersionUidHelper.extractUUID(ifMatch));
        return this.createDirectoryResponse(HttpMethod.DELETE, null, accept, null, ehrId);
    }

    private DirectoryResponseData buildResponse(FolderDto folderDto) {
        DirectoryResponseData resBody = new DirectoryResponseData();
        resBody.setDetails(folderDto.getDetails());
        resBody.setFolders(folderDto.getFolders());
        resBody.setItems(folderDto.getItems());
        resBody.setName(folderDto.getName());
        resBody.setUid(folderDto.getUid());
        return resBody;
    }

    private ResponseEntity<DirectoryResponseData> createDirectoryResponse(HttpMethod method, String prefer, String accept, FolderDto folderDto, UUID ehrId) {
        HttpStatus successStatus;
        DirectoryResponseData body;
        HttpHeaders headers = new HttpHeaders();
        if (prefer != null && prefer.equals("return=representation")) {
            headers.setContentType(this.extractMediaType(accept));
            body = this.buildResponse(folderDto);
            successStatus = this.getSuccessStatus(method);
        } else {
            body = null;
            successStatus = HttpStatus.NO_CONTENT;
        }
        if (folderDto != null) {
            String versionUid = folderDto.getUid().toString() + "::" + this.folderService.getServerConfig().getNodename() + "::" + this.folderService.getLastVersionNumber(UUID.fromString(folderDto.getUid().toString()));
            headers.setETag("\"" + versionUid + "\"");
            headers.setLocation(URI.create(this.encodePath(this.getBaseEnvLinkURL() + "/rest/openehr/v1/ehr/" + ehrId.toString() + "/directory/" + versionUid)));
            headers.setLastModified(DateTime.now().getMillis());
        }
        return new ResponseEntity(body, (MultiValueMap)headers, successStatus);
    }

    private HttpStatus getSuccessStatus(HttpMethod method) {
        switch (method) {
            case POST: {
                return HttpStatus.CREATED;
            }
            case DELETE: {
                return HttpStatus.NO_CONTENT;
            }
        }
        return HttpStatus.OK;
    }

    private boolean isValidPath(String path) {
        Pattern pathPattern = Pattern.compile("^(?:/?(?:\\w+|\\s)*/?)+$");
        return pathPattern.matcher(path).matches();
    }
}

