/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.ehrbase.api.definitions.QueryMode;
import org.ehrbase.api.dto.QueryDefinitionResultDto;
import org.ehrbase.api.service.QueryService;
import org.ehrbase.rest.openehr.controller.BaseController;
import org.ehrbase.rest.openehr.response.ErrorBodyPayload;
import org.ehrbase.rest.openehr.response.QueryDefinitionResponseData;
import org.ehrbase.rest.openehr.response.QueryResponseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Query"})
@RestController
@RequestMapping(path={"/rest/openehr/v1/query"}, produces={"application/json"})
public class OpenehrQueryController
extends BaseController {
    static final Logger log = LoggerFactory.getLogger(OpenehrQueryController.class);
    private QueryService queryService;
    private final String QUERY_PARAMETERS = "query_parameters";

    @Autowired
    public OpenehrQueryController(QueryService queryService) {
        this.queryService = Objects.requireNonNull(queryService);
    }

    @GetMapping(value={"/aql{?q, offset, fetch, query_parameter}"})
    @ApiOperation(value="Execute ad-hoc (non-stored) AQL query", response=QueryResponseData.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class)}), @ApiResponse(code=400, message="Invalid input, e.g. a request with missing required field q or invalid query syntax."), @ApiResponse(code=204, message="The query didn't give any result.")})
    public ResponseEntity<QueryResponseData> getAdhocQuery(@ApiParam(value="Client should specify expected format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="AQL query to be executed", required=true) @RequestParam(value="q") String query, @ApiParam(value="row number in result-set to start result-set from (0-based), default 0") @RequestParam(value="offset", required=false) Integer offset, @ApiParam(value="number of rows to fetch, default depends on the implementation") @RequestParam(value="fetch", required=false) Integer fetch, @ApiParam(value="query parameters (can appear multiple times)") @RequestParam Map<String, Object> queryParameters) {
        if (fetch != null) {
            query = this.withFetch(query, fetch);
        }
        if (offset != null) {
            query = this.withOffset(query, offset);
        }
        if (query != null) {
            QueryResponseData queryResponseData = queryParameters != null && !queryParameters.isEmpty() ? new QueryResponseData(this.queryService.query(query, queryParameters, QueryMode.AQL, false)) : new QueryResponseData(this.queryService.query(query, QueryMode.AQL, false));
            if (queryResponseData.getRows().size() > 0) {
                return ResponseEntity.ok((Object)queryResponseData);
            }
            return ResponseEntity.noContent().build();
        }
        return this.missingRequestResponseEntity();
    }

    @PostMapping(value={"/aql"})
    @ApiOperation(value="Execute ad-hoc (non-stored) AQL query", response=QueryResponseData.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class)}), @ApiResponse(code=400, message="Invalid input, e.g. a request with missing required field q or invalid query syntax."), @ApiResponse(code=204, message="The query didn't give any result.")})
    public ResponseEntity<QueryResponseData> postAdhocQuery(@ApiParam(value="Client should specify expected format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="Format of transferred body", required=true) @RequestHeader(value="Content-Type") String contentType, @ApiParam(value="AQL query to be executed", required=true) @RequestBody String query) {
        log.debug("Got following input: " + query);
        Gson gson = new GsonBuilder().create();
        Map mapped = (Map)gson.fromJson(query, Map.class);
        String aql = (String)mapped.get("q");
        Map parameters = (Map)mapped.get("query_parameters");
        QueryResponseData queryResponseData = null;
        if (aql != null) {
            aql = this.withOffsetLimit(aql, mapped);
            queryResponseData = parameters != null && !parameters.isEmpty() ? new QueryResponseData(this.queryService.query(aql, parameters, QueryMode.AQL, false)) : new QueryResponseData(this.queryService.query(aql, QueryMode.AQL, false));
        } else {
            return this.missingRequestResponseEntity();
        }
        if (queryResponseData == null) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.ok((Object)queryResponseData);
    }

    private String withFetch(String query, String value) {
        return this.withFetch(query, this.double2int(value));
    }

    private String withFetch(String query, Integer value) {
        return query + " LIMIT " + value;
    }

    private String withOffset(String query, String value) {
        return this.withOffset(query, this.double2int(value));
    }

    private String withOffset(String query, Integer value) {
        return query + " OFFSET " + value;
    }

    private Integer double2int(String value) {
        return Double.valueOf(value.toString()).intValue();
    }

    @GetMapping(value={"/{qualified_query_name}/{version}{?offset,fetch,query_parameter}", "/{qualified_query_name}{?offset,fetch,query_parameter}"})
    @ApiOperation(value="Execute stored AQL query", response=QueryResponseData.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class)})})
    public ResponseEntity<QueryResponseData> getStoredQuery(@ApiParam(value="Client should specify expected format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="query name to be executed, example: org.openehr::compositions", required=true) @PathVariable(value="qualified_query_name") String qualifiedQueryName, @ApiParam(value="query version (SEMVER), default is LATEST") @PathVariable(value="version") Optional<String> version, @ApiParam(value="row number in result-set to start result-set from (0-based), default 0") @RequestParam(value="offset", required=false) Integer offset, @ApiParam(value="number of rows to fetch, default depends on the implementation") @RequestParam(value="fetch", required=false) Integer fetch, @ApiParam(value="query parameters (can appear multiple times)") @RequestParam Map<String, Object> queryParameter) {
        QueryResponseData queryResponseData;
        log.debug("getStoredQuery not implemented but got following input: " + qualifiedQueryName + " - " + version + " - " + offset + " - " + fetch + " - " + queryParameter);
        QueryDefinitionResultDto queryDefinitionResultDto = this.queryService.retrieveStoredQuery(qualifiedQueryName, version.isPresent() ? version.get() : "LATEST");
        String query = queryDefinitionResultDto.getQueryText();
        if (fetch != null) {
            query = this.withFetch(query, fetch);
        }
        if (offset != null) {
            query = this.withOffset(query, offset);
        }
        if ((queryResponseData = this.invoke(query, queryParameter)) == null) {
            return ResponseEntity.noContent().build();
        }
        queryResponseData.setName(queryDefinitionResultDto.getQualifiedName() + "/" + queryDefinitionResultDto.getVersion());
        return ResponseEntity.ok((Object)queryResponseData);
    }

    @PostMapping(value={"/{qualified_query_name}/{version}", "/{qualified_query_name}"})
    @ApiOperation(value="Execute stored AQL query", response=QueryDefinitionResponseData.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class)}), @ApiResponse(code=400, message="Invalid input, e.g. a request with missing required field q or invalid query syntax."), @ApiResponse(code=412, message="Precondition failed, ID given as If-None-Match header already exists.")})
    public ResponseEntity<QueryResponseData> postStoredQuery(@ApiParam(value="Client should specify expected format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="Format of transferred body", required=true) @RequestHeader(value="Content-Type") String contentType, @ApiParam(value="use this ehrid") @RequestHeader(value="If-None-Match", required=false) String ifNoneMatch, @ApiParam(value="query name to be executed, example: org.openehr::compositions", required=true) @PathVariable(value="qualified_query_name") String qualifiedQueryName, @ApiParam(value="query version (SEMVER), default is LATEST") @PathVariable(value="version") Optional<String> version, @ApiParam(value="parameters used to execute the query") @RequestBody(required=false) String parameterBody) {
        log.debug("postStoredQuery with the following input: " + qualifiedQueryName + " - " + version + " - " + parameterBody);
        QueryDefinitionResultDto queryDefinitionResultDto = this.queryService.retrieveStoredQuery(qualifiedQueryName, version.isPresent() ? version.get() : "LATEST");
        String query = queryDefinitionResultDto.getQueryText();
        if (query != null) {
            QueryResponseData queryResponseData;
            Map queryParameter = null;
            if (parameterBody != null && !parameterBody.isEmpty()) {
                Gson gson = new GsonBuilder().create();
                Map mapped = (Map)gson.fromJson(parameterBody, Map.class);
                queryParameter = (Map)mapped.get("query_parameters");
                query = this.withOffsetLimit(query, mapped);
            }
            if ((queryResponseData = this.invoke(query, queryParameter)) == null) {
                return this.badRequestResponseEntity(qualifiedQueryName, version);
            }
            queryResponseData.setName(queryDefinitionResultDto.getQualifiedName() + "/" + queryDefinitionResultDto.getVersion());
            return ResponseEntity.ok((Object)queryResponseData);
        }
        return this.badRequestResponseEntity(qualifiedQueryName, version);
    }

    public ResponseEntity badRequestResponseEntity(String qualifiedQueryName, Optional<String> version) {
        String errorBody = new ErrorBodyPayload("Invalid query", "could not retrieve query identified by:" + qualifiedQueryName + "/" + (version.isPresent() ? version.get() : "LATEST")).toString();
        return new ResponseEntity((Object)errorBody, HttpStatus.BAD_REQUEST);
    }

    public ResponseEntity missingRequestResponseEntity() {
        String errorBody = new ErrorBodyPayload("Invalid query", "no aql query provided").toString();
        return new ResponseEntity((Object)errorBody, HttpStatus.BAD_REQUEST);
    }

    QueryResponseData invoke(String query, Map<String, Object> queryParameter) {
        QueryResponseData queryResponseData;
        if (queryParameter != null && !queryParameter.isEmpty()) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.putAll(queryParameter);
            queryResponseData = new QueryResponseData(this.queryService.query(query, parameters, QueryMode.AQL, false));
        } else {
            queryResponseData = new QueryResponseData(this.queryService.query(query, QueryMode.AQL, false));
        }
        return queryResponseData;
    }

    String withOffsetLimit(String query, Map<String, Object> mapped) {
        if (mapped.containsKey("fetch")) {
            query = this.withFetch(query, mapped.get("fetch").toString());
        }
        if (mapped.containsKey("offset")) {
            query = this.withOffset(query, mapped.get("offset").toString());
        }
        return query;
    }
}

