/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.definitions.OperationalTemplateFormat;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.NotAcceptableException;
import org.ehrbase.api.service.TemplateService;
import org.ehrbase.rest.openehr.controller.BaseController;
import org.ehrbase.rest.openehr.response.ErrorResponseData;
import org.ehrbase.rest.openehr.response.InternalResponse;
import org.ehrbase.rest.openehr.response.ResponseData;
import org.ehrbase.rest.openehr.response.TemplateResponseData;
import org.ehrbase.rest.openehr.response.TemplatesResponseData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Template"})
@RestController
@RequestMapping(path={"/rest/openehr/v1/definition/template"}, produces={"application/json", "application/xml"})
public class OpenehrTemplateController
extends BaseController {
    private final TemplateService templateService;

    @Autowired
    public OpenehrTemplateController(TemplateService templateService) {
        this.templateService = Objects.requireNonNull(templateService);
    }

    @PostMapping(value={"/adl1.4"})
    @ApiOperation(value="Upload a new ADL 1.4 operational template (OPT).", response=TemplateResponseData.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Created successfully. Depending on the header Prefer either an empty body or a full representation body is returned.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="Location", description="Location of resource", response=URI.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class), @ResponseHeader(name="Last-Modified", description="Time of last modification of resource", response=long.class)}), @ApiResponse(code=400, response=ErrorResponseData.class, message="Bad request - unable to upload a template, because of invalid content."), @ApiResponse(code=409, response=ErrorResponseData.class, message="Version Conflict - template with given id and version already exists."), @ApiResponse(code=406, response=ErrorResponseData.class, message="Not Acceptable - Service can not fulfill requested format via accept header."), @ApiResponse(code=415, response=ErrorResponseData.class, message="Unsupported Media Type - request's content-type not supported.")})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity createTemplateClassic(@ApiParam(value="Optional custom request header for versioning") @RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @ApiParam(value="Optional custom request header for auditing") @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @ApiParam(value="Format of transferred body", required=true) @RequestHeader(value="Content-Type") String contentType, @ApiParam(value="Client should specify expected format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="May be used by clients for resource representation negotiation") @RequestHeader(value="PREFER", required=false) String prefer, @ApiParam(value="The template to create", required=true) @RequestBody String template) {
        if (!MediaType.parseMediaType((String)contentType).isCompatibleWith(MediaType.APPLICATION_XML)) {
            return ResponseEntity.status((HttpStatus)HttpStatus.UNSUPPORTED_MEDIA_TYPE).body((Object)"Only XML is supported at the moment");
        }
        String templateId = this.templateService.create(template);
        URI uri = URI.create(this.encodePath(this.getBaseEnvLinkURL() + "/rest/openehr/v1/definition/template/adl1.4/" + templateId));
        List<String> headerList = Arrays.asList("Location", "ETag", "Last-Modified");
        Optional<InternalResponse<ResponseData>> respData = Optional.ofNullable(prefer).map(i -> i.equals("return=representation")).orElse(false) != false ? this.buildTemplateResponseData(templateId, accept, uri, headerList, () -> new TemplateResponseData()) : this.buildTemplateResponseData(templateId, accept, uri, headerList, () -> null);
        return respData.map(i -> Optional.ofNullable((ResponseData)i.getResponseData()).map(j -> ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)uri).headers(i.getHeaders())).body(j.get())).orElse(ResponseEntity.noContent().headers(i.getHeaders()).build())).orElse(ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    @GetMapping(value={"/adl1.4"})
    @ApiOperation(value="List all available ADL 1.4 operational templates on the system.", response=TemplateResponseData.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Ok. Successfully retrieved.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class)}), @ApiResponse(code=406, response=ErrorResponseData.class, message="Not Acceptable - Service can not fulfill requested format via accept header.")})
    public ResponseEntity getTemplatesClassic(@ApiParam(value="Optional custom request header for versioning") @RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @ApiParam(value="Optional custom request header for auditing") @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @ApiParam(value="Client should specify expected format") @RequestHeader(value="Accept", required=false) String accept) {
        URI uri = URI.create(this.encodePath(this.getBaseEnvLinkURL() + "/rest/openehr/v1/definition/template/adl1.4"));
        List<String> headerList = Collections.emptyList();
        Optional<InternalResponse<ResponseData>> respData = this.buildTemplateResponseData("", accept, uri, headerList, () -> new TemplatesResponseData());
        return respData.map(i -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(i.getHeaders())).body(((ResponseData)i.getResponseData()).get())).orElse(ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    @GetMapping(value={"/adl1.4/{template_id}"})
    @ApiOperation(value="Gets a specified ADL 1.4 operational template.", response=TemplateResponseData.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Ok. Successfully retrieved.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="Location", description="Location of resource", response=URI.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class), @ResponseHeader(name="Last-Modified", description="Time of last modification of resource", response=long.class)}), @ApiResponse(code=404, response=ErrorResponseData.class, message="Object Not Found - template with the specified id does not exist."), @ApiResponse(code=406, response=ErrorResponseData.class, message="Not Acceptable - Service can not fulfill requested format via accept header.")})
    public ResponseEntity getTemplateClassic(@ApiParam(value="Optional custom request header for versioning") @RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @ApiParam(value="Optional custom request header for auditing") @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @ApiParam(value="Client should specify expected format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="Template ID", required=true) @PathVariable(value="template_id") String templateId) {
        URI uri = URI.create(this.encodePath(this.getBaseEnvLinkURL() + "/rest/openehr/v1/definition/template/adl1.4/" + templateId));
        List<String> headerList = Arrays.asList("Location", "ETag", "Last-Modified");
        Optional<InternalResponse<ResponseData>> respData = this.buildTemplateResponseData(templateId, accept, uri, headerList, () -> new TemplateResponseData());
        return respData.map(i -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(i.getHeaders())).body(((ResponseData)i.getResponseData()).get())).orElse(ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    @PostMapping(value={"/adl2/{?version}"})
    @ApiOperation(value="Upload a new ADL 2 operational template.", response=TemplateResponseData.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Created successfully. Depending on the header Prefer either an empty body or a full representation body is returned.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="Location", description="Location of resource", response=URI.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class), @ResponseHeader(name="Last-Modified", description="Time of last modification of resource", response=long.class)}), @ApiResponse(code=400, response=ErrorResponseData.class, message="Bad request - unable to upload a template, because of invalid content."), @ApiResponse(code=409, response=ErrorResponseData.class, message="Version Conflict - template with given id and version already exists."), @ApiResponse(code=406, response=ErrorResponseData.class, message="Not Acceptable - Service can not fulfill requested format via accept header."), @ApiResponse(code=415, response=ErrorResponseData.class, message="Unsupported Media Type - request's content-type not supported.")})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<TemplateResponseData> createTemplateNew(@ApiParam(value="Optional custom request header for versioning") @RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @ApiParam(value="Optional custom request header for auditing") @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @ApiParam(value="Format of transferred body") @RequestHeader(value="Content-Type", required=false) String contentType, @ApiParam(value="Client should specify expected format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="May be used by clients for resource representation negotiation") @RequestHeader(value="PREFER", required=false) String prefer, @ApiParam(value="a SEMVER version format, i.e. 1.0.1") @RequestParam(value="version", required=false) String version, @ApiParam(value="The template to create", required=true) @RequestBody String template) {
        TemplateResponseData data = new TemplateResponseData();
        URI url = URI.create("todo");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setLocation(url);
        headers.setETag("\"something...\"");
        headers.setLastModified(1234565778L);
        return Optional.ofNullable(data).map(i -> new ResponseEntity(i, (MultiValueMap)headers, HttpStatus.CREATED)).orElse(ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    @GetMapping(value={"/adl2/{template_id}/{version_pattern}"})
    @ApiOperation(value="List all available ADL 2 operational templates on the system or a specific one. (Combined endpoint)", response=TemplateResponseData.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Ok. Successfully retrieved.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="Location", description="Location of resource", response=URI.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class), @ResponseHeader(name="Last-Modified", description="Time of last modification of resource", response=long.class)}), @ApiResponse(code=404, response=ErrorResponseData.class, message="Object Not Found - template with the specified id does not exist."), @ApiResponse(code=406, response=ErrorResponseData.class, message="Not Acceptable - Service can not fulfill requested format via accept header.")})
    public ResponseEntity<TemplateResponseData> getTemplateNew(@ApiParam(value="Optional custom request header for versioning") @RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @ApiParam(value="Optional custom request header for auditing") @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @ApiParam(value="Client should specify expected format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="Template ID") @PathVariable(value="template_id", required=false) String templateId, @ApiParam(value="SEMVER version pattern") @PathVariable(value="version_pattern", required=false) String versionPattern) {
        TemplateResponseData data = new TemplateResponseData();
        URI url = URI.create("todo");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setLocation(url);
        headers.setETag("\"something...\"");
        headers.setLastModified(1234565778L);
        return Optional.ofNullable(data).map(i -> new ResponseEntity(i, (MultiValueMap)headers, HttpStatus.CREATED)).orElse(ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    private <T> Optional<InternalResponse<T>> buildTemplateResponseData(String templateId, String accept, URI uri, List<String> headerList, Supplier<T> factory) {
        OperationalTemplateFormat format;
        T oneOrAllTemplates = factory.get();
        HttpHeaders respHeaders = new HttpHeaders();
        Iterator<String> iterator = headerList.iterator();
        while (iterator.hasNext()) {
            String header;
            switch (header = iterator.next()) {
                case "Location": {
                    respHeaders.setLocation(uri);
                    break;
                }
                case "ETag": {
                    respHeaders.setETag("\"" + templateId + "\"");
                    break;
                }
                case "Last-Modified": {
                    respHeaders.setLastModified(123124442L);
                }
            }
        }
        if (MediaType.parseMediaType((String)accept).isCompatibleWith(MediaType.APPLICATION_XML)) {
            format = OperationalTemplateFormat.XML;
        } else if (MediaType.parseMediaType((String)accept).isCompatibleWith(MediaType.APPLICATION_JSON)) {
            format = OperationalTemplateFormat.JSON;
        } else if (StringUtils.isBlank((CharSequence)accept) || "*/*".equals(accept)) {
            format = OperationalTemplateFormat.XML;
        } else {
            throw new NotAcceptableException("Currently only xml (or emtpy for fallback) is allowed");
        }
        if (oneOrAllTemplates != null) {
            ResponseData<String> objByReference;
            if (oneOrAllTemplates.getClass().equals(TemplateResponseData.class)) {
                objByReference = (TemplateResponseData)oneOrAllTemplates;
                String template = this.templateService.findOperationalTemplate(templateId, format);
                ((TemplateResponseData)objByReference).set(template);
                respHeaders.setContentType(MediaType.APPLICATION_XML);
            } else if (oneOrAllTemplates.getClass().equals(TemplatesResponseData.class)) {
                objByReference = (TemplatesResponseData)oneOrAllTemplates;
                List templates = this.templateService.getAllTemplates();
                ((TemplatesResponseData)objByReference).set(templates);
            } else {
                throw new InternalServerException("Building template response data failed");
            }
        }
        return Optional.of(new InternalResponse<T>(oneOrAllTemplates, respHeaders));
    }
}

