/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr.response;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ehrbase.api.dto.QueryResultDto;

@JacksonXmlRootElement
public class QueryResponseData {
    @JsonProperty(value="q")
    private String query;
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String name;
    @JsonProperty(value="columns")
    private List<Map<String, String>> columns;
    @JsonProperty(value="rows")
    private List<List<Object>> rows;

    public QueryResponseData(QueryResultDto queryResultDto) {
        this.query = queryResultDto.getExecutedAQL();
        this.name = null;
        this.columns = new ArrayList<Map<String, String>>();
        this.rows = new ArrayList<List<Object>>();
        if (queryResultDto.getVariables().size() > 0 && queryResultDto.getResultSet().size() > 0) {
            Map record = (Map)queryResultDto.getResultSet().get(0);
            int count = 0;
            for (String columnId : record.keySet()) {
                HashMap<String, Object> fieldMap = new HashMap<String, Object>();
                if (!queryResultDto.getVariables().containsKey((Object)columnId) && !queryResultDto.getVariables().inverse().containsKey((Object)columnId)) continue;
                if (queryResultDto.getVariables().containsKey((Object)columnId)) {
                    fieldMap.put("name", columnId);
                    fieldMap.put("path", (String)queryResultDto.getVariables().get((Object)columnId));
                } else {
                    fieldMap.put("name", "#" + count);
                    fieldMap.put("path", columnId);
                }
                ++count;
                this.columns.add(fieldMap);
            }
            for (Map valueSet : queryResultDto.getResultSet()) {
                ArrayList values = new ArrayList();
                Iterator iterator = valueSet.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry;
                    Map.Entry entryMap = entry = iterator.next();
                    String entryKey = (String)entryMap.getKey();
                    if (!queryResultDto.getVariables().containsKey((Object)entryKey) && !queryResultDto.getVariables().inverse().containsKey((Object)entryKey)) continue;
                    values.add(entryMap.getValue());
                }
                this.rows.add(values);
            }
        }
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public List<Map<String, String>> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Map<String, String>> columns) {
        this.columns = columns;
    }

    public List<List<Object>> getRows() {
        return this.rows;
    }

    public void setRows(List<List<Object>> rows) {
        this.rows = rows;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

