/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr.util;

import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionUidHelper {
    public static final Pattern UUID_PATTERN = Pattern.compile("^([a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12})");
    public static final Pattern VERSION_PATTERN = Pattern.compile("::(\\d+)$");
    public static final Pattern SYSTEM_ID_PATTERN = Pattern.compile("::(\\w+.\\w+.\\w+)");
    public static final Pattern VERSION_UID_PATTERN = Pattern.compile(UUID_PATTERN.toString() + SYSTEM_ID_PATTERN.toString() + VERSION_PATTERN.toString());

    public static boolean isVersionUid(String testString) {
        return VERSION_UID_PATTERN.matcher(testString).matches();
    }

    public static boolean isUUID(String testString) {
        return UUID_PATTERN.matcher(testString).matches();
    }

    public static boolean isSystemId(String testString) {
        return SYSTEM_ID_PATTERN.matcher(testString).matches();
    }

    public static boolean isVersion(String testString) {
        return VERSION_PATTERN.matcher(testString).matches();
    }

    public static UUID extractUUID(String versionUid) {
        Matcher matcher = UUID_PATTERN.matcher(versionUid);
        if (matcher.find()) {
            return UUID.fromString(matcher.group(1));
        }
        return null;
    }

    public static String extractSystemId(String versionUid) {
        Matcher matcher = SYSTEM_ID_PATTERN.matcher(versionUid);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static Integer extractVersion(String versionUid) {
        Matcher matcher = VERSION_PATTERN.matcher(versionUid);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1));
        }
        return null;
    }
}

