/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr.controller;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.definitions.CompositionFormat;
import org.ehrbase.api.exception.BadGatewayException;
import org.ehrbase.api.exception.DuplicateObjectException;
import org.ehrbase.api.exception.GeneralRequestProcessingException;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.NotAcceptableException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.PreconditionFailedException;
import org.ehrbase.api.exception.StateConflictException;
import org.ehrbase.api.exception.UnprocessableEntityException;
import org.ehrbase.api.exception.UnsupportedMediaTypeException;
import org.ehrbase.api.exception.ValidationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.UriUtils;

public abstract class BaseController {
    static final String RETURN_MINIMAL = "return=minimal";
    static final String RETURN_REPRESENTATION = "return=representation";
    static final String CONTENT_TYPE = "Content-Type";
    static final String LOCATION = "Location";
    static final String ETAG = "ETag";
    static final String LAST_MODIFIED = "Last-Modified";
    static final String ACCEPT = "Accept";
    static final String PREFER = "PREFER";
    static final String IF_MATCH = "If-Match";
    static final String IF_NONE_MATCH = "If-None-Match";
    static final String REQ_OPENEHR_VERSION = "Optional custom request header for versioning";
    static final String REQ_OPENEHR_AUDIT = "Optional custom request header for auditing";
    static final String REQ_CONTENT_TYPE = "Client may request content format";
    static final String REQ_CONTENT_TYPE_BODY = "Format of transferred body";
    static final String REQ_ACCEPT = "Client should specify expected format";
    static final String REQ_PREFER = "May be used by clients for resource representation negotiation";
    static final String RESP_CONTENT_TYPE_DESC = "Format of response";
    static final String RESP_LOCATION_DESC = "Location of resource";
    static final String RESP_ETAG_DESC = "Entity tag for resource";
    static final String RESP_LAST_MODIFIED_DESC = "Time of last modification of resource";
    static final String RESP_NOT_ACCEPTABLE_DESC = "Not Acceptable - Service can not fulfill requested format via accept header.";
    static final String RESP_UNSUPPORTED_MEDIA_DESC = "Unsupported Media Type - request's content-type not supported.";

    public Map<String, Map<String, String>> add2MetaMap(Map<String, Map<String, String>> metaMap, String key, String value) {
        Map<String, String> contentMap;
        if (metaMap == null) {
            metaMap = new HashMap<String, Map<String, String>>();
            contentMap = new HashMap<String, String>();
            metaMap.put("meta", contentMap);
        } else {
            contentMap = metaMap.get("meta");
        }
        contentMap.put(key, value);
        return metaMap;
    }

    protected String getBaseEnvLinkURL() {
        String baseEnvLinkURL = null;
        HttpServletRequest currentRequest = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        baseEnvLinkURL = "http://" + currentRequest.getLocalName();
        if (currentRequest.getLocalPort() != 80) {
            baseEnvLinkURL = baseEnvLinkURL + ":" + currentRequest.getLocalPort();
        }
        if (!StringUtils.isEmpty((CharSequence)currentRequest.getContextPath())) {
            baseEnvLinkURL = baseEnvLinkURL + currentRequest.getContextPath();
        }
        return baseEnvLinkURL;
    }

    protected UUID getEhrUuid(String ehrIdString) {
        return this.extractUUIDFromStringWithError(ehrIdString, "ehr", "EHR not found, in fact, only UUID-type IDs are supported");
    }

    protected UUID getCompositionVersionedObjectUidString(String compositionVersionedObjectUidString) {
        return this.extractUUIDFromStringWithError(compositionVersionedObjectUidString, "composition", "Composition not found, in fact, only UUID-type versionedObjectUids are supported");
    }

    protected UUID getContributionVersionedObjectUidString(String compositionVersionedObjectUidString) {
        return this.extractUUIDFromStringWithError(compositionVersionedObjectUidString, "contribution", "Contribution not found, in fact, only UUID-type versionedObjectUids are supported");
    }

    private UUID extractUUIDFromStringWithError(String uuidString, String type, String error) {
        UUID uuid = null;
        try {
            uuid = UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException e) {
            throw new ObjectNotFoundException(type, error);
        }
        return uuid;
    }

    protected CompositionFormat extractCompositionFormat(String contentType) {
        CompositionFormat compositionFormat;
        if (MediaType.parseMediaType((String)contentType).isCompatibleWith(MediaType.APPLICATION_XML)) {
            compositionFormat = CompositionFormat.XML;
        } else if (MediaType.parseMediaType((String)contentType).isCompatibleWith(MediaType.APPLICATION_JSON)) {
            compositionFormat = CompositionFormat.JSON;
        } else {
            throw new NotAcceptableException("Only compositions in XML or JSON are supported at the moment");
        }
        return compositionFormat;
    }

    protected MediaType extractMediaType(String accept) {
        MediaType mediaType;
        if (StringUtils.isBlank((CharSequence)accept) || "*/*".equals(accept)) {
            return MediaType.APPLICATION_XML;
        }
        if (MediaType.parseMediaType((String)accept).isCompatibleWith(MediaType.APPLICATION_XML)) {
            mediaType = MediaType.APPLICATION_XML;
        } else if (MediaType.parseMediaType((String)accept).isCompatibleWith(MediaType.APPLICATION_JSON)) {
            mediaType = MediaType.APPLICATION_JSON;
        } else {
            throw new NotAcceptableException("Only  XML or JSON are supported at the moment");
        }
        return mediaType;
    }

    public String encodePath(String path) {
        path = UriUtils.encodePath((String)path, (String)"UTF-8");
        return path;
    }

    protected ResponseEntity<Map<String, String>> createErrorResponse(String message, HttpStatus status) {
        HashMap<String, String> error = new HashMap<String, String>();
        error.put("error", message);
        error.put("status", status.getReasonPhrase());
        return new ResponseEntity(error, status);
    }

    protected UUID extractVersionedObjectUidFromVersionUid(String versionUid) {
        if (!versionUid.contains("::")) {
            return UUID.fromString(versionUid);
        }
        return UUID.fromString(versionUid.substring(0, versionUid.indexOf("::")));
    }

    protected int extractVersionFromVersionUid(String versionUid) {
        if (!versionUid.contains("::")) {
            return 0;
        }
        return Integer.valueOf(versionUid.substring(versionUid.lastIndexOf("::") + 2));
    }

    @ExceptionHandler(value={DuplicateObjectException.class})
    public ResponseEntity<Map<String, String>> restErrorHandler(DuplicateObjectException e) {
        return this.createErrorResponse(e.getMessage(), HttpStatus.ALREADY_REPORTED);
    }

    @Deprecated
    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<Map<String, String>> restErrorHandler(IllegalArgumentException e) {
        return this.createErrorResponse(e.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={GeneralRequestProcessingException.class})
    public ResponseEntity<Map<String, String>> restErrorHandler(GeneralRequestProcessingException e) {
        return this.createErrorResponse(e.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={InvalidApiParameterException.class})
    public ResponseEntity<Map<String, String>> restErrorHandler(InvalidApiParameterException e) {
        return this.createErrorResponse(e.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public ResponseEntity<Map<String, String>> restErrorHandler(MissingServletRequestParameterException e) {
        return this.createErrorResponse(e.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<Map<String, String>> restErrorHandler(HttpMessageNotReadableException e) {
        return this.createErrorResponse("Bad Request: HTTP message not readable, for instance, due to missing parameter. Error: " + e.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ObjectNotFoundException.class})
    public ResponseEntity<Map<String, String>> restErrorHandler(ObjectNotFoundException e) {
        return this.createErrorResponse(e.getMessage(), HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={NotAcceptableException.class})
    public ResponseEntity<Map<String, String>> restErrorHandler(NotAcceptableException e) {
        return this.createErrorResponse(e.getMessage(), HttpStatus.NOT_ACCEPTABLE);
    }

    @ExceptionHandler(value={StateConflictException.class})
    public ResponseEntity<Map<String, String>> restErrorHandler(StateConflictException e) {
        return this.createErrorResponse(e.getMessage(), HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={PreconditionFailedException.class})
    public ResponseEntity<Map<String, String>> restErrorHandler(PreconditionFailedException e) {
        return this.createErrorResponse(e.getMessage(), HttpStatus.PRECONDITION_FAILED);
    }

    @ExceptionHandler(value={UnsupportedMediaTypeException.class})
    public ResponseEntity<Map<String, String>> restErrorHandler(UnsupportedMediaTypeException e) {
        return this.createErrorResponse(e.getMessage(), HttpStatus.UNSUPPORTED_MEDIA_TYPE);
    }

    @ExceptionHandler(value={UnprocessableEntityException.class})
    public ResponseEntity<Map<String, String>> restErrorHandler(UnprocessableEntityException e) {
        return this.createErrorResponse(e.getMessage(), HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @ExceptionHandler(value={InternalServerException.class})
    public ResponseEntity<Map<String, String>> restErrorHandler(InternalServerException e) {
        return this.createErrorResponse("Internal Server Error: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={BadGatewayException.class})
    public ResponseEntity<Map<String, String>> restErrorHandler(BadGatewayException e) {
        return this.createErrorResponse("Bad Gateway: Proxied connection failed", HttpStatus.BAD_GATEWAY);
    }

    @ExceptionHandler(value={ValidationException.class})
    public ResponseEntity<Map<String, String>> restErrorHandler(ValidationException e) {
        return this.createErrorResponse(e.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Map<String, String>> restErrorHandler(Exception e) {
        return this.createErrorResponse(e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

