/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import java.net.URI;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.ehrbase.api.definitions.CompositionFormat;
import org.ehrbase.api.definitions.StructuredString;
import org.ehrbase.api.dto.CompositionDto;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.PreconditionFailedException;
import org.ehrbase.api.service.CompositionService;
import org.ehrbase.rest.openehr.controller.BaseController;
import org.ehrbase.rest.openehr.controller.OperationNotesResourcesReaderOpenehr;
import org.ehrbase.rest.openehr.response.CompositionResponseData;
import org.ehrbase.rest.openehr.response.ErrorResponseData;
import org.ehrbase.rest.openehr.response.InternalResponse;
import org.ehrbase.rest.openehr.response.VersionedCompositionResponseData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Composition"})
@RestController
@RequestMapping(path={"/rest/openehr/v1/ehr"}, produces={"application/json", "application/xml"})
public class OpenehrCompositionController
extends BaseController {
    final CompositionService compositionService;

    @Autowired
    public OpenehrCompositionController(CompositionService compositionService) {
        this.compositionService = Objects.requireNonNull(compositionService);
    }

    @PostMapping(value={"/{ehr_id}/composition"}, consumes={"application/xml", "application/json"})
    @ApiOperation(value="Create a new composition.")
    @OperationNotesResourcesReaderOpenehr.ApiNotes(value="compositionPost.md")
    @ApiResponses(value={@ApiResponse(code=201, response=CompositionResponseData.class, message="Successfully created - New COMPOSITION was created. Content body is only returned when Prefer header has return=representation, otherwise only headers are returned.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="Location", description="Location of resource", response=URI.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class), @ResponseHeader(name="Last-Modified", description="Time of last modification of resource", response=long.class)}), @ApiResponse(code=204, message="No Content - New COMPOSITION was created but not full representation requested. Details in response headers.", responseHeaders={@ResponseHeader(name="Location", description="Location of resource", response=URI.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class), @ResponseHeader(name="Last-Modified", description="Time of last modification of resource", response=long.class)}), @ApiResponse(code=400, response=ErrorResponseData.class, message="Bad request - Body of the request could not be read (or converted to a COMPOSITION object) or there were COMPOSITION validation errors. Or invalid ehr_id. E.g. parsing an inconrrectly formatted ehr_id. Some implementing systems may require that all ehr_id are GUIDs, i.e. formatted as five groups of characters separated by hyphens: 01234567-0123-0123-0123-012345678abc"), @ApiResponse(code=404, response=ErrorResponseData.class, message="Not Found - The EHR with the supplied ehr_id did not exist.")})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity createComposition(@ApiParam(value="Optional custom request header for versioning") @RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @ApiParam(value="Optional custom request header for auditing") @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @ApiParam(value="Format of transferred body", required=true) @RequestHeader(value="Content-Type") String contentType, @ApiParam(value="Client should specify expected format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="May be used by clients for resource representation negotiation") @RequestHeader(value="PREFER", required=false) String prefer, @ApiParam(value="EHR identifier taken from EHR.ehr_id.value", required=true) @PathVariable(value="ehr_id") String ehrIdString, @ApiParam(value="The composition to create", required=true) @RequestBody String composition) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        CompositionFormat compositionFormat = this.extractCompositionFormat(contentType);
        UUID compositionUuid = this.compositionService.create(ehrId, composition, compositionFormat);
        URI uri = URI.create(this.encodePath(this.getBaseEnvLinkURL() + "/rest/openehr/v1/ehr/" + ehrId.toString() + "/composition/" + compositionUuid.toString()));
        List<String> headerList = Arrays.asList("Location", "ETag", "Last-Modified");
        Optional<InternalResponse<CompositionResponseData>> respData = Optional.ofNullable(prefer).map(i -> i.equals("return=representation")).orElse(false) != false ? this.buildCompositionResponseData(compositionUuid, 0, accept, uri, headerList, () -> new CompositionResponseData(null, null)) : this.buildCompositionResponseData(compositionUuid, 0, accept, uri, headerList, () -> null);
        return respData.map(i -> Optional.ofNullable((CompositionResponseData)((Object)((Object)i.getResponseData()))).map(StructuredString::getValue).map(j -> ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)uri).headers(i.getHeaders())).body(j)).orElse(ResponseEntity.noContent().headers(i.getHeaders()).build())).orElse(ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    @PutMapping(value={"/{ehr_id}/composition/{versioned_object_uid}"})
    @ApiOperation(value="Update existing composition.", response=CompositionResponseData.class)
    @OperationNotesResourcesReaderOpenehr.ApiNotes(value="compositionPut.md")
    @ApiResponses(value={@ApiResponse(code=200, message="Success.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="Location", description="Location of resource", response=URI.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class), @ResponseHeader(name="Last-Modified", description="Time of last modification of resource", response=long.class)}), @ApiResponse(code=204, message="No Content - COMPOSITION was updated but no full representation requested. Details in response headers.", responseHeaders={@ResponseHeader(name="Location", description="Location of resource", response=URI.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class), @ResponseHeader(name="Last-Modified", description="Time of last modification of resource", response=long.class)}), @ApiResponse(code=201, message="(not valid, ignore. documentation produces this entry automatically."), @ApiResponse(code=400, response=ErrorResponseData.class, message="Bad request - either the body of the request could not be read (or converted to a COMPOSITION object) or there were composition validation errors."), @ApiResponse(code=404, response=ErrorResponseData.class, message="Not Found - No EHR with the supplied ehr_id or no COMPOSITION with the supplied object_id."), @ApiResponse(code=409, response=ErrorResponseData.class, message="Version Conflict - Returned when supplied version_uid is not the latest version. Returns latest version in the Location and ETag headers.")})
    public ResponseEntity updateComposition(@ApiParam(value="Optional custom request header for versioning") @RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @ApiParam(value="Optional custom request header for auditing") @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @ApiParam(value="Format of transferred body") @RequestHeader(value="Content-Type", required=false) String contentType, @ApiParam(value="Client should specify expected format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="May be used by clients for resource representation negotiation") @RequestHeader(value="PREFER", required=false) String prefer, @ApiParam(value="{preceding_version_uid}", required=true) @RequestHeader(value="If-Match") String ifMatch, @ApiParam(value="EHR identifier taken from EHR.ehr_id.value", required=true) @PathVariable(value="ehr_id") String ehrIdString, @ApiParam(value="identifier of the VERSIONED COMPOSITION to be updated.", required=true) @PathVariable(value="versioned_object_uid") String versionedObjectUidString, @ApiParam(value="The composition to create", required=true) @RequestBody String composition) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        UUID versionedObjectUid = this.getCompositionVersionedObjectUidString(versionedObjectUidString);
        CompositionFormat compositionFormat = this.extractCompositionFormat(contentType);
        this.compositionService.exists(versionedObjectUid);
        if (!(versionedObjectUid + "::" + this.compositionService.getServerConfig().getNodename() + "::" + this.compositionService.getLastVersionNumber(this.extractVersionedObjectUidFromVersionUid(versionedObjectUid.toString()))).equals(ifMatch)) {
            throw new PreconditionFailedException("If-Match header does not match latest existing version");
        }
        Optional<String> inputUuid = Optional.ofNullable(this.compositionService.getUidFromInputComposition(composition, compositionFormat));
        inputUuid.ifPresent(id -> {
            if (!versionedObjectUid.equals(this.extractVersionedObjectUidFromVersionUid((String)id))) {
                throw new PreconditionFailedException("UUID from input must match given versioned_object_uid in request URL");
            }
        });
        Optional<Object> respData = Optional.empty();
        try {
            String compositionVersionUid = this.compositionService.update(versionedObjectUid, compositionFormat, composition);
            URI uri = URI.create(this.encodePath(this.getBaseEnvLinkURL() + "/rest/openehr/v1/ehr/" + ehrId.toString() + "/composition/" + compositionVersionUid));
            List<String> headerList = Arrays.asList("Location", "ETag", "Last-Modified");
            respData = "return=representation".equals(prefer) ? this.buildCompositionResponseData(this.extractVersionedObjectUidFromVersionUid(compositionVersionUid), this.extractVersionFromVersionUid(compositionVersionUid), accept, uri, headerList, () -> new CompositionResponseData(null, null)) : this.buildCompositionResponseData(this.extractVersionedObjectUidFromVersionUid(compositionVersionUid), this.extractVersionFromVersionUid(compositionVersionUid), accept, uri, headerList, () -> null);
        }
        catch (ObjectNotFoundException e) {
            return ResponseEntity.notFound().build();
        }
        return respData.map(i -> Optional.ofNullable((CompositionResponseData)((Object)((Object)i.getResponseData()))).map(StructuredString::getValue).map(j -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(i.getHeaders())).body(j)).orElse(ResponseEntity.noContent().headers(i.getHeaders()).build())).orElse(ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    @DeleteMapping(value={"/{ehr_id}/composition/{preceding_version_uid}"})
    @ApiOperation(value="Deletes existing composition.")
    @ApiResponses(value={@ApiResponse(code=204, message="COMPOSITION was deleted.", responseHeaders={@ResponseHeader(name="Location", description="Location of resource", response=URI.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class), @ResponseHeader(name="Last-Modified", description="Time of last modification of resource", response=long.class)}), @ApiResponse(code=400, response=ErrorResponseData.class, message="Bad request - The composition with preceding_version_uid is already deleted."), @ApiResponse(code=404, response=ErrorResponseData.class, message="Not Found - No EHR with the supplied ehr_id or no COMPOSITION with the supplied preceding_version_uid."), @ApiResponse(code=409, response=ErrorResponseData.class, message="Version Conflict - Returned when supplied preceding_version_uid doesn\u2019t match the latest version. Returns latest version in the Location and ETag headers.", responseHeaders={@ResponseHeader(name="Location", description="Location of resource", response=URI.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class)})})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity deleteComposition(@ApiParam(value="Optional custom request header for versioning") @RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @ApiParam(value="Optional custom request header for auditing") @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @ApiParam(value="EHR identifier taken from EHR.ehr_id.value", required=true) @PathVariable(value="ehr_id") String ehrIdString, @ApiParam(value="Identifier of the COMPOSITION to be updated. This MUST be the last (most recent) version.", required=true) @PathVariable(value="preceding_version_uid") String precedingVersionUid) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        HttpHeaders headers = new HttpHeaders();
        this.compositionService.retrieve(this.extractVersionedObjectUidFromVersionUid(precedingVersionUid), Integer.valueOf(1)).orElseThrow(() -> new ObjectNotFoundException("composition", "No EHR with the supplied ehr_id or no COMPOSITION with the supplied preceding_version_uid."));
        String latestVersionId = this.extractVersionedObjectUidFromVersionUid(precedingVersionUid) + "::" + this.compositionService.getServerConfig().getNodename() + "::" + this.compositionService.getLastVersionNumber(this.extractVersionedObjectUidFromVersionUid(precedingVersionUid));
        URI uri = URI.create(this.encodePath(this.getBaseEnvLinkURL() + "/rest/openehr/v1/ehr/" + ehrId.toString() + "/composition/" + latestVersionId));
        if (!this.compositionService.getLastVersionNumber(this.extractVersionedObjectUidFromVersionUid(precedingVersionUid)).equals(this.extractVersionFromVersionUid(precedingVersionUid))) {
            headers.setLocation(uri);
            headers.setETag("\"" + latestVersionId + "\"");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).headers(headers)).build();
        }
        try {
            LocalDateTime time = this.compositionService.delete(this.extractVersionedObjectUidFromVersionUid(precedingVersionUid));
            headers.setLocation(uri);
            headers.setETag("\"" + latestVersionId + "\"");
            headers.setLastModified(ZonedDateTime.of(time, ZoneId.systemDefault()).toInstant().toEpochMilli());
            return ResponseEntity.noContent().headers(headers).build();
        }
        catch (ObjectNotFoundException e) {
            throw new ObjectNotFoundException("composition", "No EHR with the supplied ehr_id or no COMPOSITION with the supplied preceding_version_uid.");
        }
        catch (Exception e) {
            throw new InternalServerException("Deleting of composition failed", e);
        }
    }

    @GetMapping(value={"/{ehr_id}/composition/{version_uid}"})
    @ApiOperation(value="Get composition by version id.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class)}), @ApiResponse(code=204, message="No Content - Returned when the composition is deleted (logically). (Note: ignore body)", response=ResponseEntity.class, responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class)}), @ApiResponse(code=404, response=ErrorResponseData.class, message="Not Found - No EHR with the supplied ehr_id or no COMPOSITION with the supplied version_uid.")})
    public ResponseEntity<CompositionResponseData> getCompositionByVersionId(@ApiParam(value="Client should specify expected format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="EHR identifier taken from EHR.ehr_id.value", required=true) @PathVariable(value="ehr_id") String ehrIdString, @ApiParam(value="VERSION identifier", required=true) @PathVariable(value="version_uid") String versionUid, @ApiParam(value="A timestamp in the ISO8601 format", hidden=true) @RequestParam(value="version_at_time", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime versionAtTime) {
        return this.getCompositionByTime(accept, ehrIdString, versionUid, versionAtTime);
    }

    @GetMapping(value={"/{ehr_id}/composition/{versioned_object_uid}{?version_at_time}"})
    @ApiOperation(value="Get composition at time.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="Location", description="Location of resource", response=URI.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class)}), @ApiResponse(code=204, message="No Content - The COMPOSITION at specified version_at_time time has been deleted. (Note: ignore body)", response=ResponseEntity.class, responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class)}), @ApiResponse(code=404, response=ErrorResponseData.class, message="Not Found - No EHR with the supplied ehr_id or no VERSIONED_COMPOSITION with the supplied versioned_object_uid or no COMPOSITION at specified version_at_time time.")})
    public ResponseEntity getCompositionByTime(@ApiParam(value="Client should specify expected format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="EHR identifier taken from EHR.ehr_id.value", required=true) @PathVariable(value="ehr_id") String ehrIdString, @ApiParam(value="VERSIONED_COMPOSITION identifier taken from VERSIONED_COMPOSITION.uid.value", required=true) @PathVariable(value="versioned_object_uid") String versionedObjectUid, @ApiParam(value="A timestamp in the ISO8601 format") @RequestParam(value="version_at_time", required=false) LocalDateTime versionAtTime) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        UUID compositionUid = this.extractVersionedObjectUidFromVersionUid(versionedObjectUid);
        if (this.compositionService.isDeleted(compositionUid)) {
            return this.createErrorResponse("Composition is logically deleted.", HttpStatus.NO_CONTENT);
        }
        int version = 0;
        if (this.extractVersionFromVersionUid(versionedObjectUid) != 0) {
            version = this.extractVersionFromVersionUid(versionedObjectUid);
        } else if (versionAtTime != null) {
            Optional<Integer> versionFromTimestamp = Optional.ofNullable(this.compositionService.getVersionByTimestamp(compositionUid, versionAtTime));
            version = versionFromTimestamp.orElseThrow(() -> new ObjectNotFoundException("composition", "No composition version matching the timestamp condition"));
        }
        URI uri = URI.create(this.encodePath(this.getBaseEnvLinkURL() + "/rest/openehr/v1/ehr/" + ehrId.toString() + "/composition/" + versionedObjectUid));
        List<String> headerList = Arrays.asList("Location", "ETag", "Last-Modified");
        Optional<InternalResponse<CompositionResponseData>> respData = this.buildCompositionResponseData(compositionUid, version, accept, uri, headerList, () -> new CompositionResponseData(null, null));
        return respData.map(i -> Optional.ofNullable(((CompositionResponseData)((Object)((Object)i.getResponseData()))).getValue()).map(j -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(i.getHeaders())).body(j)).orElse(ResponseEntity.noContent().headers(i.getHeaders()).build())).orElse(ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    @GetMapping(value={"/{ehr_id}/versioned_composition/{versioned_object_uid}"})
    @ApiOperation(value="Get versioned composition")
    @ApiResponses(value={@ApiResponse(code=200, message="OK.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="Location", description="Location of resource", response=URI.class)}), @ApiResponse(code=404, response=ErrorResponseData.class, message="Not Found - No EHR with the supplied ehr_id or no VERSIONED_COMPOSITION with the supplied versioned_object_uid.")})
    public ResponseEntity<VersionedCompositionResponseData> getVersionedCompositionById(@ApiParam(value="EHR identifier taken from EHR.ehr_id.value", required=true) @PathVariable(value="ehr_id") String ehrIdString, @ApiParam(value="VERSIONED_COMPOSITION identifier taken from VERSIONED_COMPOSITION.uid.value", required=true) @PathVariable(value="versioned_object_uid") String versionedObjectUidString) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        UUID versionedObjectUid = this.getCompositionVersionedObjectUidString(versionedObjectUidString);
        VersionedCompositionResponseData data = new VersionedCompositionResponseData();
        URI url = URI.create("todo");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setLocation(url);
        headers.setLastModified(1234565778L);
        return Optional.ofNullable(data).map(i -> new ResponseEntity(i, (MultiValueMap)headers, HttpStatus.OK)).orElse(ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).build());
    }

    @GetMapping(value={"/{ehr_id}/versioned_composition/{versioned_object_uid}/revision_history"})
    @ApiOperation(value="Get versioned composition revision history")
    @ApiResponses(value={@ApiResponse(code=200, message="OK.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="Location", description="Location of resource", response=URI.class)}), @ApiResponse(code=404, response=ErrorResponseData.class, message="Not Found - No EHR with the supplied ehr_id or no VERSIONED_COMPOSITION with the supplied versioned_object_uid.")})
    public ResponseEntity<VersionedCompositionResponseData> getRevisionHistoryVersionedCompositionById(@ApiParam(value="EHR identifier taken from EHR.ehr_id.value", required=true) @PathVariable(value="ehr_id") String ehrIdString, @ApiParam(value="VERSIONED_COMPOSITION identifier taken from VERSIONED_COMPOSITION.uid.value", required=true) @PathVariable(value="versioned_object_uid") String versionedObjectUidString) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        UUID versionedObjectUid = this.getCompositionVersionedObjectUidString(versionedObjectUidString);
        VersionedCompositionResponseData data = new VersionedCompositionResponseData();
        URI url = URI.create("todo");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setLocation(url);
        headers.setLastModified(1234565778L);
        return Optional.ofNullable(data).map(i -> new ResponseEntity(i, (MultiValueMap)headers, HttpStatus.OK)).orElse(ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).build());
    }

    @GetMapping(value={"/{ehr_id}/versioned_composition/{versioned_object_uid}/version/{version_uid}"})
    @ApiOperation(value="Get versioned composition version by id and reference to revision history")
    @ApiResponses(value={@ApiResponse(code=200, message="OK.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class)}), @ApiResponse(code=404, response=ErrorResponseData.class, message="Not Found - No EHR with the supplied ehr_id or no VERSIONED_COMPOSITION with the supplied versioned_object_uid or no VERSION with the supplied versione_uid.")})
    public ResponseEntity<CompositionResponseData> getCompositionByRevisionHistory(@ApiParam(value="EHR identifier taken from EHR.ehr_id.value", required=true) @PathVariable(value="ehr_id") String ehrIdString, @ApiParam(value="VERSIONED_COMPOSITION identifier taken from VERSIONED_COMPOSITION.uid.value", required=true) @PathVariable(value="versioned_object_uid") String versionedObjectUidString, @ApiParam(value="VERSIONED identifier taken from VERSIONED.uid.value", required=true) @PathVariable(value="version_uid") String versionUid) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        UUID versionedObjectUid = this.getCompositionVersionedObjectUidString(versionedObjectUidString);
        CompositionResponseData data = new CompositionResponseData(null, null);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setLastModified(1234565778L);
        return Optional.ofNullable(data).map(i -> new ResponseEntity((Object)i, (MultiValueMap)headers, HttpStatus.OK)).orElse(ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).build());
    }

    @GetMapping(value={"/{ehr_id}/versioned_composition/{versioned_object_uid}/version{?version_at_time}"})
    @ApiOperation(value="Get versioned composition version at time")
    @ApiResponses(value={@ApiResponse(code=200, message="OK.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="Location", description="Location of resource", response=URI.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class)}), @ApiResponse(code=404, response=ErrorResponseData.class, message="Not Found - No EHR with the supplied ehr_id or no VERSIONED_COMPOSITION with the supplied versioned_object_uid or no VERSION with the supplied versione_uid.")})
    public ResponseEntity<CompositionResponseData> getVersionedCompositionAtTime(@ApiParam(value="EHR identifier taken from EHR.ehr_id.value", required=true) @PathVariable(value="ehr_id") String ehrIdString, @ApiParam(value="VERSIONED_COMPOSITION identifier taken from VERSIONED_COMPOSITION.uid.value", required=true) @PathVariable(value="versioned_object_uid") String versionedObjectUidString, @ApiParam(value="A timestamp in the ISO8601 format") @RequestParam(value="version_at_time", required=false) String versionAtTime) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        UUID versionedObjectUid = this.getCompositionVersionedObjectUidString(versionedObjectUidString);
        CompositionResponseData data = new CompositionResponseData(null, null);
        URI url = URI.create("todo");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setLocation(url);
        headers.setETag("\"something...\"");
        headers.setLastModified(1234565778L);
        return Optional.ofNullable(data).map(i -> new ResponseEntity((Object)i, (MultiValueMap)headers, HttpStatus.OK)).orElse(ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).build());
    }

    private <T extends CompositionResponseData> Optional<InternalResponse<T>> buildCompositionResponseData(UUID compositionId, Integer version, String accept, URI uri, List<String> headerList, Supplier<T> factory) {
        CompositionResponseData minimalOrRepresentation = (CompositionResponseData)((Object)factory.get());
        HttpHeaders respHeaders = new HttpHeaders();
        Iterator<String> iterator = headerList.iterator();
        while (iterator.hasNext()) {
            String header;
            switch (header = iterator.next()) {
                case "Location": {
                    respHeaders.setLocation(uri);
                    break;
                }
                case "ETag": {
                    respHeaders.setETag("\"" + compositionId + "::" + this.compositionService.getServerConfig().getNodename() + "::" + this.compositionService.getLastVersionNumber(compositionId) + "\"");
                    break;
                }
                case "Last-Modified": {
                    respHeaders.setLastModified(123124442L);
                }
            }
        }
        if (minimalOrRepresentation != null) {
            Optional compositionDto;
            CompositionResponseData objByReference = minimalOrRepresentation;
            if (accept.equals("*/*") || accept.isEmpty()) {
                accept = MediaType.APPLICATION_XML.toString();
            }
            CompositionFormat format = this.extractCompositionFormat(accept);
            Integer versionNumber = version;
            if (versionNumber == 0) {
                versionNumber = this.compositionService.getLastVersionNumber(compositionId);
            }
            if (!(compositionDto = this.compositionService.retrieve(compositionId, versionNumber)).isPresent()) {
                throw new ObjectNotFoundException("composition", "Couldn't retrieve composition");
            }
            StructuredString ss = this.compositionService.serialize((CompositionDto)compositionDto.get(), format);
            objByReference.setValue(ss.getValue());
            objByReference.setFormat(ss.getFormat());
            if (format.equals((Object)CompositionFormat.XML)) {
                respHeaders.setContentType(MediaType.APPLICATION_XML);
            } else if (format.equals((Object)CompositionFormat.FLAT) || format.equals((Object)CompositionFormat.ECISFLAT) || format.equals((Object)CompositionFormat.RAW)) {
                respHeaders.setContentType(MediaType.APPLICATION_JSON);
            }
        }
        return Optional.of(new InternalResponse<CompositionResponseData>(minimalOrRepresentation, respHeaders));
    }
}

