/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr.controller;

import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.ehrbase.api.definitions.CompositionFormat;
import org.ehrbase.api.dto.ContributionDto;
import org.ehrbase.api.exception.NotAcceptableException;
import org.ehrbase.api.service.ContributionService;
import org.ehrbase.rest.openehr.controller.BaseController;
import org.ehrbase.rest.openehr.controller.OperationNotesResourcesReaderOpenehr;
import org.ehrbase.rest.openehr.response.CompositionResponseData;
import org.ehrbase.rest.openehr.response.ContributionResponseData;
import org.ehrbase.rest.openehr.response.ErrorResponseData;
import org.ehrbase.rest.openehr.response.InternalResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Contribution"})
@RestController
@RequestMapping(path={"/rest/openehr/v1/ehr"}, produces={"application/json", "application/xml"})
public class OpenehrContributionController
extends BaseController {
    private final ContributionService contributionService;

    @Autowired
    public OpenehrContributionController(ContributionService contributionService) {
        this.contributionService = Objects.requireNonNull(contributionService);
    }

    @PostMapping(value={"/{ehr_id}/contribution"}, consumes={"application/xml", "application/json"})
    @OperationNotesResourcesReaderOpenehr.ApiNotes(value="contributionPost.md")
    @ApiOperation(value="Create a new composition.")
    @ApiResponses(value={@ApiResponse(code=201, response=CompositionResponseData.class, message="New Contribution was created. Content body is only returned when Prefer header has return=representation, otherwise only headers are returned.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="Location", description="Location of resource", response=URI.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class), @ResponseHeader(name="Last-Modified", description="Time of last modification of resource", response=long.class)}), @ApiResponse(code=204, message="No Content - New Contribution was created but not full representation requested. Details in response headers.", responseHeaders={@ResponseHeader(name="Location", description="Location of resource", response=URI.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class), @ResponseHeader(name="Last-Modified", description="Time of last modification of resource", response=long.class)}), @ApiResponse(code=400, response=ErrorResponseData.class, message="Bad request: validation errors in one of the attached locatables, modification type doesn\u2019t match the operation - i.e. first version of a composition with MODIFICATION."), @ApiResponse(code=404, response=ErrorResponseData.class, message="Not Found - The EHR with the supplied ehr_id did not exist.")})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity createContribution(@ApiParam(value="Optional custom request header for versioning") @RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @ApiParam(value="Optional custom request header for auditing") @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @ApiParam(value="Format of transferred body", required=true) @RequestHeader(value="Content-Type") String contentType, @ApiParam(value="Client should specify expected format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="May be used by clients for resource representation negotiation") @RequestHeader(value="PREFER", required=false) String prefer, @ApiParam(value="EHR identifier taken from EHR.ehr_id.value", required=true) @PathVariable(value="ehr_id") String ehrIdString, @ApiParam(value="The contribution to create", required=true) @RequestBody String contribution) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        UUID contributionId = this.contributionService.commitContribution(ehrId, contribution, this.extractCompositionFormat(contentType));
        URI uri = URI.create(this.encodePath(this.getBaseEnvLinkURL() + "/rest/openehr/v1/ehr/" + ehrId.toString() + "/contribution/" + contributionId.toString()));
        List<String> headerList = Arrays.asList("Location", "ETag");
        Optional<InternalResponse<ContributionResponseData>> respData = Optional.ofNullable(prefer).map(i -> i.equals("return=representation")).orElse(false) != false ? this.buildContributionResponseData(contributionId, ehrId, accept, uri, headerList, () -> new ContributionResponseData(null, null, null)) : this.buildContributionResponseData(contributionId, ehrId, accept, uri, headerList, () -> null);
        return respData.map(i -> Optional.ofNullable((ContributionResponseData)i.getResponseData()).map(j -> ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)uri).headers(i.getHeaders())).body(j)).orElse(ResponseEntity.noContent().headers(i.getHeaders()).build())).orElse(ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    @GetMapping(value={"/{ehr_id}/contribution/{contribution_uid}"})
    @ApiOperation(value="Get contribution by id.")
    @ApiResponses(value={@ApiResponse(code=200, response=CompositionResponseData.class, message="Contribution found and returned.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="Location", description="Location of resource", response=URI.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class), @ResponseHeader(name="Last-Modified", description="Time of last modification of resource", response=long.class)}), @ApiResponse(code=404, response=ErrorResponseData.class, message="Not Found - No EHR with the supplied ehr_id or no Contribution with the supplied contribution_uid was found.")})
    public ResponseEntity getContribution(@ApiParam(value="Optional custom request header for versioning") @RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @ApiParam(value="Optional custom request header for auditing") @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @ApiParam(value="Client should specify expected format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="EHR identifier taken from EHR.ehr_id.value", required=true) @PathVariable(value="ehr_id") String ehrIdString, @ApiParam(value="", required=true) @PathVariable(value="contribution_uid") String contributionUidString) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        UUID contributionUid = this.getContributionVersionedObjectUidString(contributionUidString);
        URI uri = URI.create(this.encodePath(this.getBaseEnvLinkURL() + "/rest/openehr/v1/ehr/" + ehrId.toString() + "/contribution/" + contributionUid.toString()));
        List<String> headerList = Arrays.asList("Location", "ETag", "Last-Modified");
        Optional<InternalResponse<ContributionResponseData>> respData = this.buildContributionResponseData(contributionUid, ehrId, accept, uri, headerList, () -> new ContributionResponseData(null, null, null));
        return respData.map(i -> Optional.ofNullable((ContributionResponseData)i.getResponseData()).map(j -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(i.getHeaders())).body(j)).orElse(ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build())).orElse(ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    private <T extends ContributionResponseData> Optional<InternalResponse<T>> buildContributionResponseData(UUID contributionId, UUID ehrId, String accept, URI uri, List<String> headerList, Supplier<T> factory) {
        ContributionResponseData minimalOrRepresentation = (ContributionResponseData)factory.get();
        HttpHeaders respHeaders = new HttpHeaders();
        Iterator<String> iterator = headerList.iterator();
        while (iterator.hasNext()) {
            String header;
            switch (header = iterator.next()) {
                case "Location": {
                    respHeaders.setLocation(uri);
                    break;
                }
                case "ETag": {
                    respHeaders.setETag("\"" + contributionId + "\"");
                    break;
                }
                case "Last-Modified": {
                    respHeaders.setLastModified(123124442L);
                }
            }
        }
        if (minimalOrRepresentation != null) {
            CompositionFormat format;
            ContributionResponseData objByReference = minimalOrRepresentation;
            Optional contribution = this.contributionService.getContribution(ehrId, contributionId);
            objByReference.setUid(new HierObjectId(contributionId.toString()));
            LinkedList<ObjectRef<ObjectVersionId>> refs = new LinkedList<ObjectRef<ObjectVersionId>>();
            ((ContributionDto)contribution.get()).getObjectReferences().forEach((id, type) -> refs.add(new ObjectRef((ObjectId)new ObjectVersionId(id), "local", type)));
            objByReference.setVersions(refs);
            objByReference.setAudit(((ContributionDto)contribution.get()).getAuditDetails());
            if (accept.equals("*/*") || accept.isEmpty()) {
                accept = MediaType.APPLICATION_XML.toString();
            }
            if ((format = this.extractCompositionFormat(accept)).equals((Object)CompositionFormat.XML)) {
                respHeaders.setContentType(MediaType.APPLICATION_XML);
            } else if (format.equals((Object)CompositionFormat.JSON) || format.equals((Object)CompositionFormat.FLAT) || format.equals((Object)CompositionFormat.ECISFLAT) || format.equals((Object)CompositionFormat.RAW)) {
                respHeaders.setContentType(MediaType.APPLICATION_JSON);
            } else {
                throw new NotAcceptableException("Wrong Accept header in request");
            }
        }
        return Optional.of(new InternalResponse<ContributionResponseData>(minimalOrRepresentation, respHeaders));
    }
}

