/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr.controller;

import com.nedap.archie.rm.ehr.EhrStatus;
import com.nedap.archie.rm.support.identification.HierObjectId;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.StateConflictException;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.rest.openehr.controller.BaseController;
import org.ehrbase.rest.openehr.controller.OperationNotesResourcesReaderOpenehr;
import org.ehrbase.rest.openehr.response.EhrResponseData;
import org.ehrbase.rest.openehr.response.InternalResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"EHR"})
@RestController
@RequestMapping(path={"/rest/openehr/v1/ehr"}, produces={"application/json", "application/xml"})
public class OpenehrEhrController
extends BaseController {
    private final EhrService ehrService;

    @Autowired
    public OpenehrEhrController(EhrService ehrService) {
        this.ehrService = Objects.requireNonNull(ehrService);
    }

    @PostMapping
    @ApiOperation(value="Create a new EHR with an auto-generated identifier.", response=EhrResponseData.class)
    @OperationNotesResourcesReaderOpenehr.ApiNotes(value="ehrPostPutEhrWithStatus.md")
    @ApiResponses(value={@ApiResponse(code=201, message="Successfully created - new EHR has been successfully created. The EHR resource is returned in the body when the Prefer header has the value of return=representation. The default for Prefer header (or when Prefer header if missing) is return=minimal. The Location header is always returned.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="Location", description="Location of resource", response=URI.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class), @ResponseHeader(name="Last-Modified", description="Time of last modification of resource", response=long.class)}), @ApiResponse(code=400, message="Bad request - Request body (if provided) could not be parsed."), @ApiResponse(code=406, message="Not Acceptable - Service can not fulfil requested Accept format."), @ApiResponse(code=409, message="Conflict - Unable to create a new EHR due to a conflict with an already existing EHR with the same subject id, namespace pair.")})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity createEhr(@ApiParam(value="Optional custom request header for versioning") @RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @ApiParam(value="Optional custom request header for auditing") @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @ApiParam(value="Format of transferred body") @RequestHeader(value="Content-Type", required=false) String contentType, @ApiParam(value="Client should specify expected response format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="May be used by clients for resource representation negotiation") @RequestHeader(value="PREFER", required=false, defaultValue="return=minimal") String prefer, @ApiParam(value="An ehr_status may be supplied as the request body") @RequestBody(required=false) EhrStatus ehrStatus) {
        UUID ehrId = ehrStatus != null ? this.ehrService.create(ehrStatus, null) : this.ehrService.create(null, null);
        return this.internalPostEhrProcessing(accept, prefer, ehrId);
    }

    @PutMapping(path={"/{ehr_id}"})
    @ApiOperation(value="Create a new EHR with the specified EHR identifier.", response=EhrResponseData.class)
    @OperationNotesResourcesReaderOpenehr.ApiNotes(value="ehrPostPutEhrWithStatus.md")
    @ApiResponses(value={@ApiResponse(code=201, message="Successfully created - new EHR has been successfully created. The EHR resource is returned in the body when the Prefer header has the value of return=representation. The default for Prefer header (or when Prefer header if missing) is return=minimal. The Location header is always returned.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="Location", description="Location of resource", response=URI.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class), @ResponseHeader(name="Last-Modified", description="Time of last modification of resource", response=long.class)}), @ApiResponse(code=400, message="Bad request - Request body (if provided) or when supplied ehr_id doesn't follow the specification."), @ApiResponse(code=406, message="Not Acceptable - Service can not fulfil requested Accept format."), @ApiResponse(code=409, message="Conflict - Unable to create a new EHR due to a conflict with an already existing EHR. Can happen when the supplied ehr_id is already already used by an existing EHR.")})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<EhrResponseData> createEhrWithId(@ApiParam(value="Optional custom request header for versioning") @RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @ApiParam(value="Optional custom request header for auditing") @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @ApiParam(value="Client should specify expected response format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="May be used by clients for resource representation negotiation") @RequestHeader(value="PREFER", required=false) String prefer, @ApiParam(value="User supplied EHR ID", required=true) @PathVariable(value="ehr_id") String ehrIdString, @ApiParam(value="An ehr_status may be supplied as the request body") @RequestBody(required=false) EhrStatus ehrStatus) {
        UUID ehrId;
        try {
            ehrId = UUID.fromString(ehrIdString);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidApiParameterException("EHR ID format not a UUID");
        }
        if (this.ehrService.hasEhr(ehrId).booleanValue()) {
            throw new StateConflictException("EHR with this ID already exists");
        }
        UUID resultEhrId = ehrStatus != null ? this.ehrService.create(ehrStatus, ehrId) : this.ehrService.create(null, ehrId);
        if (!ehrId.equals(resultEhrId)) {
            throw new InternalServerException("Error creating EHR with custom ID and/or status");
        }
        return this.internalPostEhrProcessing(accept, prefer, resultEhrId);
    }

    private ResponseEntity<EhrResponseData> internalPostEhrProcessing(String accept, String prefer, UUID resultEhrId) {
        URI url = URI.create(this.encodePath(this.getBaseEnvLinkURL() + "/rest/openehr/v1/ehr/" + resultEhrId.toString()));
        List<String> headerList = Arrays.asList("Content-Type", "Location", "ETag", "Last-Modified");
        Optional<InternalResponse<EhrResponseData>> respData = Optional.ofNullable(prefer).map(i -> i.equals("return=representation")).orElse(false) != false ? this.buildEhrResponseData(EhrResponseData::new, resultEhrId, accept, headerList) : this.buildEhrResponseData(() -> null, resultEhrId, accept, headerList);
        return respData.map(i -> Optional.ofNullable((EhrResponseData)i.getResponseData()).map(j -> ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)url).headers(i.getHeaders())).body(j)).orElse(ResponseEntity.noContent().headers(i.getHeaders()).build())).orElse(ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    @GetMapping(path={"/{ehr_id}"})
    @ApiOperation(value="Retrieve the EHR with the specified ehr_id.", response=EhrResponseData.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Ok - EHR resource is successfully retrieved.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="Last-Modified", description="Time of last modification of resource", response=long.class)}), @ApiResponse(code=404, message="Not Found - EHR with ehr_id does not exist"), @ApiResponse(code=406, message="Not Acceptable - Service can not fulfil requested Accept format."), @ApiResponse(code=415, message="Unsupported Media Type - Type not supported.")})
    public ResponseEntity<EhrResponseData> retrieveEhrById(@ApiParam(value="Client should specify expected response format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="User supplied EHR ID", required=true) @PathVariable(value="ehr_id") String ehrIdString) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        if (this.ehrService.hasEhr(ehrId).equals(Boolean.FALSE)) {
            throw new ObjectNotFoundException("ehr", "No EHR with this ID can be found");
        }
        return this.internalGetEhrProcessing(accept, ehrId);
    }

    @GetMapping(params={"subject_id", "subject_namespace"})
    @ApiOperation(value="Retrieve the EHR with the specified subject_id and subject_namespace.", response=EhrResponseData.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Ok - EHR resource is successfully retrieved.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="Last-Modified", description="Time of last modification of resource", response=long.class)}), @ApiResponse(code=404, message="Not Found - EHR with supplied subject parameters does not exist."), @ApiResponse(code=406, message="Not Acceptable - Service can not fulfil requested Accept format."), @ApiResponse(code=415, message="Unsupported Media Type - Type not supported.")})
    public ResponseEntity<EhrResponseData> retrieveEhrBySubject(@ApiParam(value="Client should specify expected response format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="subject id", required=true) @RequestParam(value="subject_id") String subjectId, @ApiParam(value="subject namespace", required=true) @RequestParam(value="subject_namespace") String subjectNamespace) {
        Optional ehrIdOpt = this.ehrService.findBySubject(subjectId, subjectNamespace);
        UUID ehrId = (UUID)ehrIdOpt.orElseThrow(() -> new ObjectNotFoundException("ehr", "No EHR with supplied subject parameters found"));
        return this.internalGetEhrProcessing(accept, ehrId);
    }

    private ResponseEntity<EhrResponseData> internalGetEhrProcessing(String accept, UUID ehrId) {
        List<String> headerList = Arrays.asList("Content-Type", "Location", "ETag", "Last-Modified");
        Optional<InternalResponse<EhrResponseData>> respData = this.buildEhrResponseData(EhrResponseData::new, ehrId, accept, headerList);
        return respData.map(i -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(i.getHeaders())).body((Object)((EhrResponseData)i.getResponseData()))).orElse(ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    private <T extends EhrResponseData> Optional<InternalResponse<T>> buildEhrResponseData(Supplier<T> factory, UUID ehrId, String accept, List<String> headerList) {
        MediaType contentTypeHeaderInput;
        if (StringUtils.isBlank((CharSequence)accept) || accept.equals("*/*")) {
            contentTypeHeaderInput = MediaType.APPLICATION_JSON;
        } else {
            MediaType mediaType = MediaType.parseMediaType((String)accept);
            if (mediaType.isCompatibleWith(MediaType.APPLICATION_JSON)) {
                contentTypeHeaderInput = MediaType.APPLICATION_JSON;
            } else if (mediaType.isCompatibleWith(MediaType.APPLICATION_XML)) {
                contentTypeHeaderInput = MediaType.APPLICATION_XML;
            } else {
                throw new InvalidApiParameterException("Wrong Content-Type header in request");
            }
        }
        Optional ehrStatus = this.ehrService.getEhrStatus(ehrId);
        if (!ehrStatus.isPresent()) {
            return Optional.empty();
        }
        EhrResponseData minimalOrRepresentation = (EhrResponseData)factory.get();
        if (minimalOrRepresentation != null) {
            EhrResponseData objByReference = minimalOrRepresentation;
            objByReference.setEhrId(new HierObjectId(ehrId.toString()));
            objByReference.setEhrStatus((EhrStatus)ehrStatus.get());
            objByReference.setSystemId(new HierObjectId(this.ehrService.getSystemUuid().toString()));
            objByReference.setTimeCreated(this.ehrService.getCreationTime(ehrId).toString());
            objByReference.setCompositions(null);
            objByReference.setContributions(null);
        }
        HttpHeaders respHeaders = new HttpHeaders();
        Iterator<String> iterator = headerList.iterator();
        while (iterator.hasNext()) {
            String header;
            switch (header = iterator.next()) {
                case "Content-Type": {
                    if (minimalOrRepresentation == null) break;
                    respHeaders.setContentType(contentTypeHeaderInput);
                    break;
                }
                case "Location": {
                    try {
                        URI url = new URI(this.getBaseEnvLinkURL() + "/rest/openehr/v1/ehr/" + ehrId);
                        respHeaders.setLocation(url);
                        break;
                    }
                    catch (Exception e) {
                        throw new InternalServerException(e.getMessage());
                    }
                }
                case "ETag": {
                    respHeaders.setETag("\"" + ehrId + "\"");
                    break;
                }
                case "Last-Modified": {
                    respHeaders.setLastModified(123124442L);
                }
            }
        }
        return Optional.of(new InternalResponse<EhrResponseData>(minimalOrRepresentation, respHeaders));
    }
}

