/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr.controller;

import com.nedap.archie.rm.changecontrol.OriginalVersion;
import com.nedap.archie.rm.ehr.EhrStatus;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import java.net.URI;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.PreconditionFailedException;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.rest.openehr.controller.BaseController;
import org.ehrbase.rest.openehr.controller.OperationNotesResourcesReaderOpenehr;
import org.ehrbase.rest.openehr.response.EhrStatusResponseData;
import org.ehrbase.rest.openehr.response.InternalResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"EHR_STATUS"})
@RestController
@RequestMapping(path={"/rest/openehr/v1/ehr/{ehr_id}/ehr_status"}, produces={"application/json", "application/xml"})
public class OpenehrEhrStatusController
extends BaseController {
    private final EhrService ehrService;

    @Autowired
    public OpenehrEhrStatusController(EhrService ehrService) {
        this.ehrService = Objects.requireNonNull(ehrService);
    }

    @GetMapping
    @ApiOperation(value="Retrieves the version of the EHR_STATUS associated with the EHR identified by ehr_id. If version_at_time is supplied, retrieves the version extant at specified time, otherwise retrieves the latest EHR_STATUS version.", response=EhrStatusResponseData.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Ok - requested EHR_STATUS resource is successfully retrieved.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="Last-Modified", description="Time of last modification of resource", response=long.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class), @ResponseHeader(name="Location", description="Location of resource", response=String.class)}), @ApiResponse(code=400, message="Bad Request - the request has invalid content such as an invalid version_at_time format."), @ApiResponse(code=404, message="Not Found - EHR with ehr_id does not exist or a version of an EHR_STATUS resource does not exist at the specified version_at_time."), @ApiResponse(code=406, message="Not Acceptable - Service can not fulfil requested Accept format.")})
    public ResponseEntity<EhrStatusResponseData> retrieveEhrStatusByTime(@ApiParam(value="Client should specify expected format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="User supplied EHR ID", required=true) @PathVariable(value="ehr_id") String ehrIdString, @ApiParam(value="Timestamp in the extended ISO8601 format, e.g. 2015-01-20T19:30:22.765+01:00") @RequestParam(value="version_at_time", required=false) String versionAtTime) {
        int version;
        UUID ehrId = this.getEhrUuid(ehrIdString);
        if (this.ehrService.hasEhr(ehrId).equals(Boolean.FALSE)) {
            throw new ObjectNotFoundException("EHR", "No EHR with id " + ehrId + " found");
        }
        if (versionAtTime != null) {
            OffsetDateTime time = OffsetDateTime.parse(versionAtTime);
            Timestamp timestamp = Timestamp.valueOf(time.toLocalDateTime());
            version = this.ehrService.getEhrStatusVersionByTimestamp(ehrId, timestamp);
        } else {
            version = Integer.parseInt(this.ehrService.getLatestVersionUidOfStatus(ehrId).split("::")[2]);
        }
        UUID statusUid = this.ehrService.getEhrStatusVersionedObjectUidByEhr(ehrId);
        return this.internalGetEhrStatusProcessing(accept, ehrId, statusUid, version);
    }

    @GetMapping(path={"/{version_uid}"})
    @ApiOperation(value="Retrieves a particular version of the EHR_STATUS identified by version_uid and associated with the EHR identified by ehr_id.", response=EhrStatusResponseData.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Ok - requested EHR_STATUS is successfully retrieved.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="Last-Modified", description="Time of last modification of resource", response=long.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class), @ResponseHeader(name="Location", description="Location of resource", response=String.class)}), @ApiResponse(code=404, message="Not Found - EHR with ehr_id does not exist or when an EHR_STATUS with version_uid does not exist."), @ApiResponse(code=406, message="Not Acceptable - Service can not fulfil requested Accept format.")})
    public ResponseEntity<EhrStatusResponseData> retrieveEhrStatusById(@ApiParam(value="Client should specify expected response format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="User supplied EHR ID", required=true) @PathVariable(value="ehr_id") String ehrIdString, @ApiParam(value="User supplied version UID of EHR_STATUS", required=true) @PathVariable(value="version_uid") String versionUid) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        if (this.ehrService.hasEhr(ehrId).equals(Boolean.FALSE)) {
            throw new ObjectNotFoundException("EHR", "No EHR with id " + ehrId + " found");
        }
        UUID versionedObjectUid = this.extractVersionedObjectUidFromVersionUid(versionUid);
        int version = this.extractVersionFromVersionUid(versionUid);
        Optional ehrStatus = this.ehrService.getEhrStatusAtVersion(ehrId, versionedObjectUid, version);
        UUID ehrStatusId = this.extractVersionedObjectUidFromVersionUid(((OriginalVersion)ehrStatus.orElseThrow(() -> new ObjectNotFoundException("ehr_status", "EHR_STATUS not found"))).getUid().toString());
        return this.internalGetEhrStatusProcessing(accept, ehrId, ehrStatusId, version);
    }

    private ResponseEntity<EhrStatusResponseData> internalGetEhrStatusProcessing(String accept, UUID ehrId, UUID ehrStatusId, int version) {
        List<String> headerList = Arrays.asList("Content-Type", "Location", "ETag", "Last-Modified");
        Optional<InternalResponse<EhrStatusResponseData>> respData = this.buildEhrStatusResponseData(EhrStatusResponseData::new, ehrId, ehrStatusId, version, accept, headerList);
        return respData.map(i -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(i.getHeaders())).body((Object)((EhrStatusResponseData)i.getResponseData()))).orElse(ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    @PutMapping
    @ApiOperation(value="Updates EHR_STATUS associated with the EHR identified by ehr_id. The existing latest version_uid of EHR_STATUS resource (i.e the preceding_version_uid) must be specified in the If-Match header. The response will contain the updated EHR_STATUS resource when the Prefer header has a value of return=representation")
    @OperationNotesResourcesReaderOpenehr.ApiNotes(value="ehrStatusPut.md")
    @ApiResponses(value={@ApiResponse(code=200, message="Ok - EHR_STATUS is successfully updated and the updated resource is returned in the body when Prefer header value is return=representation.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class), @ResponseHeader(name="Last-Modified", description="Time of last modification of resource", response=long.class), @ResponseHeader(name="ETag", description="Entity tag for resource", response=String.class), @ResponseHeader(name="Location", description="Location of resource", response=String.class)}), @ApiResponse(code=204, message="Not Content - Prefer header is missing or is set to return=minimal."), @ApiResponse(code=400, message="Bad Request - request has invalid content."), @ApiResponse(code=404, message="Not Found - EHR with ehr_id does not exist."), @ApiResponse(code=412, message="Precondition Failed - If-Match request header doesn\u2019t match the latest version on the service side. Returns also latest version_uid in the Location and ETag headers."), @ApiResponse(code=406, message="Not Acceptable - Service can not fulfil requested Accept format.")})
    public ResponseEntity<EhrStatusResponseData> updateEhrStatus(@ApiParam(value="Client should specify expected format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="Format of transferred body") @RequestHeader(value="Content-Type", required=false) String contentType, @ApiParam(value="May be used by clients for resource representation negotiation") @RequestHeader(value="PREFER", required=false) String prefer, @ApiParam(value="{preceding_version_uid}", required=true) @RequestHeader(value="If-Match") String ifMatch, @ApiParam(value="EHR ID", required=true) @PathVariable(value="ehr_id") String ehrIdString, @ApiParam(value="EHR status.", required=true) @RequestBody EhrStatus ehrStatus) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        if (this.ehrService.hasEhr(ehrId).equals(Boolean.FALSE)) {
            throw new ObjectNotFoundException("EHR", "No EHR with id " + ehrId + " found");
        }
        String latestVersionUid = this.ehrService.getLatestVersionUidOfStatus(ehrId);
        if (!latestVersionUid.equals(ifMatch)) {
            throw new PreconditionFailedException("Given If-Match header does not match latest existing version");
        }
        Optional updateStatus = this.ehrService.updateStatus(ehrId, ehrStatus);
        EhrStatus status = (EhrStatus)updateStatus.orElseThrow(() -> new InvalidApiParameterException("Could not update EHR_STATUS"));
        String newLatestVersionUid = this.ehrService.getLatestVersionUidOfStatus(ehrId);
        String[] split = latestVersionUid.split("::");
        if (latestVersionUid.equals(newLatestVersionUid) || split.length != 3) {
            throw new InvalidApiParameterException("Update of EHR_STATUS failed");
        }
        int version = Integer.parseInt(split[split.length - 1]) + 1;
        List<String> headerList = Arrays.asList("Content-Type", "Location", "ETag", "Last-Modified");
        Optional<InternalResponse<EhrStatusResponseData>> respData = Optional.ofNullable(prefer).map(i -> i.equals("return=representation")).orElse(false) != false ? this.buildEhrStatusResponseData(EhrStatusResponseData::new, ehrId, UUID.fromString(status.getUid().getRoot().getValue()), version, accept, headerList) : this.buildEhrStatusResponseData(EhrStatusResponseData::new, ehrId, UUID.fromString(status.getUid().getRoot().getValue()), version, accept, headerList);
        return respData.map(i -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(i.getHeaders())).body((Object)((EhrStatusResponseData)i.getResponseData()))).orElse(ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    private <T extends EhrStatusResponseData> Optional<InternalResponse<T>> buildEhrStatusResponseData(Supplier<T> factory, UUID ehrId, UUID ehrStatusId, int version, String accept, List<String> headerList) {
        MediaType contentTypeHeaderInput;
        EhrStatusResponseData minimalOrRepresentation = (EhrStatusResponseData)factory.get();
        if (StringUtils.isBlank((CharSequence)accept) || accept.equals("*/*")) {
            contentTypeHeaderInput = MediaType.APPLICATION_JSON;
        } else {
            MediaType mediaType = MediaType.parseMediaType((String)accept);
            if (mediaType.isCompatibleWith(MediaType.APPLICATION_JSON)) {
                contentTypeHeaderInput = MediaType.APPLICATION_JSON;
            } else if (mediaType.isCompatibleWith(MediaType.APPLICATION_XML)) {
                contentTypeHeaderInput = MediaType.APPLICATION_XML;
            } else {
                throw new InvalidApiParameterException("Wrong Content-Type header in request");
            }
        }
        if (minimalOrRepresentation != null) {
            EhrStatusResponseData objByReference = minimalOrRepresentation;
            Optional ehrStatus = this.ehrService.getEhrStatusAtVersion(ehrId, ehrStatusId, version);
            if (ehrStatus.isPresent()) {
                objByReference.setArchetypeNodeId(((EhrStatus)((OriginalVersion)ehrStatus.get()).getData()).getArchetypeNodeId());
                objByReference.setName(((EhrStatus)((OriginalVersion)ehrStatus.get()).getData()).getName());
                objByReference.setUid((UIDBasedId)((OriginalVersion)ehrStatus.get()).getUid());
                objByReference.setSubject(((EhrStatus)((OriginalVersion)ehrStatus.get()).getData()).getSubject());
                objByReference.setOtherDetails(((EhrStatus)((OriginalVersion)ehrStatus.get()).getData()).getOtherDetails());
                objByReference.setModifiable(((EhrStatus)((OriginalVersion)ehrStatus.get()).getData()).isModifiable());
                objByReference.setQueryable(((EhrStatus)((OriginalVersion)ehrStatus.get()).getData()).isQueryable());
            } else {
                return Optional.empty();
            }
        }
        HttpHeaders respHeaders = new HttpHeaders();
        Iterator<String> iterator = headerList.iterator();
        while (iterator.hasNext()) {
            String header;
            switch (header = iterator.next()) {
                case "Content-Type": {
                    respHeaders.setContentType(contentTypeHeaderInput);
                    break;
                }
                case "Location": {
                    try {
                        URI url = new URI(this.getBaseEnvLinkURL() + "/rest/openehr/v1/ehr/" + ehrId + "/ehr_status/" + ehrStatusId + "::" + this.ehrService.getServerConfig().getNodename() + "::" + version);
                        respHeaders.setLocation(url);
                        break;
                    }
                    catch (Exception e) {
                        throw new InternalServerException(e.getMessage());
                    }
                }
                case "ETag": {
                    respHeaders.setETag("\"" + ehrStatusId + "::" + this.ehrService.getServerConfig().getNodename() + "::" + version + "\"");
                    break;
                }
                case "Last-Modified": {
                    respHeaders.setLastModified(123124442L);
                }
            }
        }
        return Optional.of(new InternalResponse<EhrStatusResponseData>(minimalOrRepresentation, respHeaders));
    }
}

