/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr.controller;

import com.nedap.archie.rm.changecontrol.OriginalVersion;
import com.nedap.archie.rm.ehr.EhrStatus;
import com.nedap.archie.rm.ehr.VersionedEhrStatus;
import com.nedap.archie.rm.generic.RevisionHistory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.dto.ContributionDto;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.service.ContributionService;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.rest.openehr.controller.BaseController;
import org.ehrbase.rest.openehr.response.OriginalVersionResponseData;
import org.ehrbase.rest.openehr.response.RevisionHistoryResponseData;
import org.ehrbase.rest.openehr.response.VersionedObjectResponseData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api
@RestController
@RequestMapping(path={"/rest/openehr/v1/ehr/{ehr_id}/versioned_ehr_status"}, produces={"application/json", "application/xml"})
public class OpenehrVersionedEhrStatusController
extends BaseController {
    private final EhrService ehrService;
    private final ContributionService contributionService;

    @Autowired
    public OpenehrVersionedEhrStatusController(EhrService ehrService, ContributionService contributionService) {
        this.ehrService = Objects.requireNonNull(ehrService);
        this.contributionService = Objects.requireNonNull(contributionService);
    }

    @GetMapping
    @ApiOperation(value="Retrieves a VERSIONED_EHR_STATUS associated with an EHR identified by ehr_id.", response=VersionedObjectResponseData.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Ok - requested VERSIONED_EHR_STATUS is successfully retrieved.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class)}), @ApiResponse(code=404, message="Not Found - EHR with ehr_id does not exist."), @ApiResponse(code=406, message="Not Acceptable - Service can not fulfil requested Accept format.")})
    public ResponseEntity<VersionedObjectResponseData<EhrStatus>> retrieveVersionedEhrStatusByEhr(@ApiParam(value="Client should specify expected response format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="User supplied EHR ID", required=true) @PathVariable(value="ehr_id") String ehrIdString) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        if (this.ehrService.hasEhr(ehrId).equals(Boolean.FALSE)) {
            throw new ObjectNotFoundException("ehr", "No EHR with this ID can be found");
        }
        VersionedEhrStatus versionedEhrStatus = this.ehrService.getVersionedEhrStatus(ehrId);
        VersionedObjectResponseData response = new VersionedObjectResponseData(versionedEhrStatus);
        HttpHeaders respHeaders = new HttpHeaders();
        respHeaders.setContentType(this.getMediaType(accept));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(respHeaders)).body(response);
    }

    @GetMapping(path={"/revision_history"})
    @ApiOperation(value="Retrieves a VERSIONED_EHR_STATUS associated with an EHR identified by ehr_id.", response=RevisionHistoryResponseData.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Ok - requested VERSIONED_EHR_STATUS is successfully retrieved.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class)}), @ApiResponse(code=404, message="Not Found - EHR with ehr_id does not exist."), @ApiResponse(code=406, message="Not Acceptable - Service can not fulfil requested Accept format.")})
    public ResponseEntity<RevisionHistoryResponseData> retrieveVersionedEhrStatusRevisionHistoryByEhr(@ApiParam(value="Client should specify expected response format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="User supplied EHR ID", required=true) @PathVariable(value="ehr_id") String ehrIdString) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        if (this.ehrService.hasEhr(ehrId).equals(Boolean.FALSE)) {
            throw new ObjectNotFoundException("ehr", "No EHR with this ID can be found");
        }
        RevisionHistory revisionHistory = this.ehrService.getRevisionHistoryOfVersionedEhrStatus(ehrId);
        RevisionHistoryResponseData response = new RevisionHistoryResponseData(revisionHistory);
        HttpHeaders respHeaders = new HttpHeaders();
        respHeaders.setContentType(this.getMediaType(accept));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(respHeaders)).body((Object)response);
    }

    @GetMapping(path={"/version"})
    @ApiOperation(value="Retrieves the VERSION of an EHR_STATUS associated with the EHR identified by ehr_id. If version_at_time is supplied, retrieves the VERSION extant at specified time, otherwise retrieves the latest VERSION.", response=OriginalVersionResponseData.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Ok - requested VERSION is successfully retrieved.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class)}), @ApiResponse(code=404, message="Not Found - EHR with ehr_id does not exist."), @ApiResponse(code=406, message="Not Acceptable - Service can not fulfil requested Accept format.")})
    public ResponseEntity<OriginalVersionResponseData<EhrStatus>> retrieveVersionOfEhrStatusByTime(@ApiParam(value="Client should specify expected response format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="User supplied EHR ID", required=true) @PathVariable(value="ehr_id") String ehrIdString, @ApiParam(value="A timestamp in the ISO8601 format", hidden=true) @RequestParam(value="version_at_time", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime versionAtTime) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        if (this.ehrService.hasEhr(ehrId).equals(Boolean.FALSE)) {
            throw new ObjectNotFoundException("ehr", "No EHR with this ID can be found");
        }
        UUID versionedObjectId = this.ehrService.getEhrStatusVersionedObjectUidByEhr(ehrId);
        int version = versionAtTime != null ? this.ehrService.getEhrStatusVersionByTimestamp(ehrId, Timestamp.valueOf(versionAtTime)) : Integer.parseInt(this.ehrService.getLatestVersionUidOfStatus(ehrId).split("::")[2]);
        Optional ehrStatusOriginalVersion = this.ehrService.getEhrStatusAtVersion(ehrId, versionedObjectId, version);
        UUID contributionId = ehrStatusOriginalVersion.map(i -> UUID.fromString(i.getContribution().getId().getValue())).orElseThrow(() -> new InvalidApiParameterException("Couldn't retrieve EhrStatus with given parameters"));
        Optional optionalContributionDto = this.contributionService.getContribution(ehrId, contributionId);
        ContributionDto contributionDto = (ContributionDto)optionalContributionDto.orElseThrow(() -> new InternalServerException("Couldn't fetch contribution for existing EhrStatus"));
        OriginalVersionResponseData originalVersionResponseData = new OriginalVersionResponseData((OriginalVersion)ehrStatusOriginalVersion.get(), contributionDto);
        HttpHeaders respHeaders = new HttpHeaders();
        respHeaders.setContentType(this.getMediaType(accept));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(respHeaders)).body(originalVersionResponseData);
    }

    @GetMapping(path={"/version/{version_uid}"})
    @ApiOperation(value="Retrieves a VERSION identified by version_uid of an EHR_STATUS associated with the EHR identified by ehr_id.", response=OriginalVersionResponseData.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Ok - requested VERSION is successfully retrieved.", responseHeaders={@ResponseHeader(name="Content-Type", description="Format of response", response=MediaType.class)}), @ApiResponse(code=404, message="Not Found - EHR with ehr_id does not exist."), @ApiResponse(code=406, message="Not Acceptable - Service can not fulfil requested Accept format.")})
    public ResponseEntity<OriginalVersionResponseData<EhrStatus>> retrieveVersionOfEhrStatusByVersionUid(@ApiParam(value="Client should specify expected response format") @RequestHeader(value="Accept", required=false) String accept, @ApiParam(value="User supplied EHR ID", required=true) @PathVariable(value="ehr_id") String ehrIdString, @ApiParam(value="User supplied VERSION identifier", required=true) @PathVariable(value="version_uid") String versionUid) {
        int version;
        UUID versionedObjectId;
        UUID ehrId = this.getEhrUuid(ehrIdString);
        if (this.ehrService.hasEhr(ehrId).equals(Boolean.FALSE)) {
            throw new ObjectNotFoundException("ehr", "No EHR with this ID can be found");
        }
        try {
            versionedObjectId = UUID.fromString(versionUid.split("::")[0]);
            version = Integer.parseInt(versionUid.split("::")[2]);
        }
        catch (Exception e) {
            throw new InvalidApiParameterException("VERSION UID parameter has wrong format: " + e.getMessage());
        }
        Optional ehrStatusOriginalVersion = this.ehrService.getEhrStatusAtVersion(ehrId, versionedObjectId, version);
        UUID contributionId = ehrStatusOriginalVersion.map(i -> UUID.fromString(i.getContribution().getId().getValue())).orElseThrow(() -> new InvalidApiParameterException("Couldn't retrieve EhrStatus with given parameters"));
        Optional optionalContributionDto = this.contributionService.getContribution(ehrId, contributionId);
        ContributionDto contributionDto = (ContributionDto)optionalContributionDto.orElseThrow(() -> new InternalServerException("Couldn't fetch contribution for existing EhrStatus"));
        OriginalVersionResponseData originalVersionResponseData = new OriginalVersionResponseData((OriginalVersion)ehrStatusOriginalVersion.get(), contributionDto);
        HttpHeaders respHeaders = new HttpHeaders();
        respHeaders.setContentType(this.getMediaType(accept));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(respHeaders)).body(originalVersionResponseData);
    }

    private MediaType getMediaType(@RequestHeader(value="Accept", required=false) @ApiParam(value="Client should specify expected response format") String accept) {
        MediaType contentTypeHeaderInput;
        if (StringUtils.isBlank((CharSequence)accept) || accept.equals("*/*")) {
            contentTypeHeaderInput = MediaType.APPLICATION_JSON;
        } else {
            MediaType mediaType = MediaType.parseMediaType((String)accept);
            if (mediaType.isCompatibleWith(MediaType.APPLICATION_JSON)) {
                contentTypeHeaderInput = MediaType.APPLICATION_JSON;
            } else if (mediaType.isCompatibleWith(MediaType.APPLICATION_XML)) {
                contentTypeHeaderInput = MediaType.APPLICATION_XML;
            } else {
                throw new InvalidApiParameterException("Wrong Content-Type header in request");
            }
        }
        return contentTypeHeaderInput;
    }
}

