/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr.controller;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.io.Resources;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URL;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spring.web.DescriptionResolver;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component
@Order(value=-2147482648)
public class OperationNotesResourcesReaderOpenehr
implements OperationBuilderPlugin {
    private final DescriptionResolver descriptions;
    static final Logger logger = LoggerFactory.getLogger(OperationNotesResourcesReaderOpenehr.class);

    @Autowired
    public OperationNotesResourcesReaderOpenehr(DescriptionResolver descriptions) {
        this.descriptions = descriptions;
    }

    public void apply(OperationContext context) {
        Optional methodAnnotation = context.findAnnotation(ApiNotes.class);
        if (methodAnnotation.isPresent() && StringUtils.hasText((String)((ApiNotes)methodAnnotation.get()).value())) {
            Object text;
            String mdFile = ((ApiNotes)methodAnnotation.get()).value();
            URL url = Resources.getResource((String)mdFile);
            try {
                text = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                logger.error("Error while reading markdown description file {}", (Object)mdFile, (Object)e);
                text = "Markdown file " + mdFile + " not loaded";
            }
            context.operationBuilder().notes(this.descriptions.resolve((String)text));
        }
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply((DocumentationType)delimiter);
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ApiNotes {
        public String value() default "";
    }
}

