/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.nedap.archie.rm.changecontrol.Contribution;
import com.nedap.archie.rm.changecontrol.OriginalVersion;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.generic.Attestation;
import com.nedap.archie.rm.generic.AuditDetails;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.util.ArrayList;
import java.util.List;
import org.ehrbase.api.dto.ContributionDto;

@JacksonXmlRootElement(localName="original_version")
public class OriginalVersionResponseData<T> {
    @JsonProperty(value="_type")
    private String type;
    @JsonProperty(value="uid")
    private ObjectVersionId versionId;
    private Contribution contribution;
    private String signature;
    @JsonProperty(value="commit_audit")
    private AuditDetails auditDetails;
    @JsonProperty(value="preceding_version_uid")
    private ObjectVersionId precedingVersionUid;
    @JsonProperty(value="other_input_version_uids")
    private List<ObjectVersionId> otherInputVersionUids;
    @JsonProperty(value="lifecycle_state")
    private DvCodedText lifecycleState;
    private List<Attestation> attestations;
    private T data;

    public OriginalVersionResponseData(OriginalVersion<T> originalVersion, ContributionDto contributionDto) {
        this.setType("ORIGINAL_VERSION");
        this.setVersionId(originalVersion.getUid());
        HierObjectId contributionId = new HierObjectId(contributionDto.getUuid().toString());
        ArrayList versions = new ArrayList();
        contributionDto.getObjectReferences().forEach((k, v) -> versions.add(new ObjectRef((ObjectId)new HierObjectId(v), "local", k)));
        Contribution contribution = new Contribution(contributionId, versions, contributionDto.getAuditDetails());
        this.setContribution(contribution);
        this.setSignature(originalVersion.getSignature());
        this.setAuditDetails(originalVersion.getCommitAudit());
        this.setPrecedingVersionUid(originalVersion.getPrecedingVersionUid());
        this.setOtherInputVersionUids(originalVersion.getOtherInputVersionUids());
        this.setLifecycleState(originalVersion.getLifecycleState());
        this.setAttestations(originalVersion.getAttestations());
        this.setData(originalVersion.getData());
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ObjectVersionId getVersionId() {
        return this.versionId;
    }

    public void setVersionId(ObjectVersionId versionId) {
        this.versionId = versionId;
    }

    public Contribution getContribution() {
        return this.contribution;
    }

    public void setContribution(Contribution contribution) {
        this.contribution = contribution;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    public ObjectVersionId getPrecedingVersionUid() {
        return this.precedingVersionUid;
    }

    public void setPrecedingVersionUid(ObjectVersionId precedingVersionUid) {
        this.precedingVersionUid = precedingVersionUid;
    }

    public List<ObjectVersionId> getOtherInputVersionUids() {
        return this.otherInputVersionUids;
    }

    public void setOtherInputVersionUids(List<ObjectVersionId> otherInputVersionUids) {
        this.otherInputVersionUids = otherInputVersionUids;
    }

    public DvCodedText getLifecycleState() {
        return this.lifecycleState;
    }

    public void setLifecycleState(DvCodedText lifecycleState) {
        this.lifecycleState = lifecycleState;
    }

    public List<Attestation> getAttestations() {
        return this.attestations;
    }

    public void setAttestations(List<Attestation> attestations) {
        this.attestations = attestations;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }
}

