/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.NotAcceptableException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.response.ehrscape.CompositionFormat;
import org.springframework.http.MediaType;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriUtils;

public abstract class BaseController {
    public static final String OPENEHR_AUDIT_DETAILS = "openEHR-AUDIT_DETAILS";
    public static final String OPENEHR_VERSION = "openEHR-VERSION";
    public static final String PREFER = "Prefer";
    public static final String RETURN_MINIMAL = "return=minimal";
    public static final String RETURN_REPRESENTATION = "return=representation";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String ACCEPT = "Accept";
    public static final String REQ_CONTENT_TYPE = "Client may request content format";
    public static final String REQ_CONTENT_TYPE_BODY = "Format of transferred body";
    public static final String REQ_ACCEPT = "Client should specify expected format";
    public static final String RESP_CONTENT_TYPE_DESC = "Format of response";
    public static final String REST_OPERATION = "RestOperation";
    public static final String LOCATION = "Location";
    public static final String ETAG = "ETag";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String IF_MATCH = "If-Match";
    public static final String IF_NONE_MATCH = "If-None-Match";
    public static final String REQ_OPENEHR_VERSION = "Optional custom request header for versioning";
    public static final String REQ_OPENEHR_AUDIT = "Optional custom request header for auditing";
    public static final String REQ_PREFER = "May be used by clients for resource representation negotiation";
    public static final String RESP_LOCATION_DESC = "Location of resource";
    public static final String RESP_ETAG_DESC = "Entity tag for resource";
    public static final String RESP_LAST_MODIFIED_DESC = "Time of last modification of resource";
    public static final String RESP_NOT_ACCEPTABLE_DESC = "Not Acceptable - Service can not fulfill requested format via accept header.";
    public static final String RESP_UNSUPPORTED_MEDIA_DESC = "Unsupported Media Type - request's content-type not supported.";
    public static final String EHR = "ehr";
    public static final String EHR_STATUS = "ehrstatus";
    public static final String COMPOSITION = "composition";
    public static final String DIRECTORY = "directory";
    public static final String CONTRIBUTION = "contribution";
    public static final String QUERY = "query";
    public static final String DEFINITION = "definition";

    public Map<String, Map<String, String>> add2MetaMap(Map<String, Map<String, String>> metaMap, String key, String value) {
        Map<String, String> contentMap;
        if (metaMap == null) {
            metaMap = new HashMap<String, Map<String, String>>();
            contentMap = new HashMap<String, String>();
            metaMap.put("meta", contentMap);
        } else {
            contentMap = metaMap.get("meta");
        }
        contentMap.put(key, value);
        return metaMap;
    }

    protected String getBaseEnvLinkURL() {
        String baseEnvLinkURL = null;
        HttpServletRequest currentRequest = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        baseEnvLinkURL = "http://" + currentRequest.getLocalName();
        if (currentRequest.getLocalPort() != 80) {
            baseEnvLinkURL = baseEnvLinkURL + ":" + currentRequest.getLocalPort();
        }
        if (!StringUtils.isEmpty((CharSequence)currentRequest.getContextPath())) {
            baseEnvLinkURL = baseEnvLinkURL + currentRequest.getContextPath();
        }
        return baseEnvLinkURL;
    }

    protected UUID getEhrUuid(String ehrIdString) {
        return this.extractUUIDFromStringWithError(ehrIdString, EHR, "EHR not found, in fact, only UUID-type IDs are supported");
    }

    protected UUID getCompositionVersionedObjectUidString(String compositionVersionedObjectUidString) {
        return this.extractUUIDFromStringWithError(compositionVersionedObjectUidString, COMPOSITION, "Composition not found, in fact, only UUID-type versionedObjectUids are supported");
    }

    protected UUID getContributionVersionedObjectUidString(String compositionVersionedObjectUidString) {
        return this.extractUUIDFromStringWithError(compositionVersionedObjectUidString, CONTRIBUTION, "Contribution not found, in fact, only UUID-type versionedObjectUids are supported");
    }

    private UUID extractUUIDFromStringWithError(String uuidString, String type, String error) {
        UUID uuid;
        try {
            uuid = UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException e) {
            throw new ObjectNotFoundException(type, error);
        }
        return uuid;
    }

    protected CompositionFormat extractCompositionFormat(String contentType) {
        CompositionFormat compositionFormat;
        MediaType mediaType = this.resolveContentType(contentType);
        if (mediaType.isCompatibleWith(MediaType.APPLICATION_XML)) {
            compositionFormat = CompositionFormat.XML;
        } else if (mediaType.isCompatibleWith(MediaType.APPLICATION_JSON)) {
            compositionFormat = CompositionFormat.JSON;
        } else {
            throw new NotAcceptableException("Only compositions in XML or JSON are supported at the moment");
        }
        return compositionFormat;
    }

    public String encodePath(String path) {
        path = UriUtils.encodePath((String)path, (String)"UTF-8");
        return path;
    }

    protected UUID extractVersionedObjectUidFromVersionUid(String versionUid) {
        if (!versionUid.contains("::")) {
            return UUID.fromString(versionUid);
        }
        return UUID.fromString(versionUid.substring(0, versionUid.indexOf("::")));
    }

    protected int extractVersionFromVersionUid(String versionUid) {
        if (!versionUid.contains("::")) {
            return 0;
        }
        return Integer.parseInt(versionUid.substring(versionUid.lastIndexOf("::") + 2));
    }

    protected void enrichRequestAttribute(String attributeName, Object value) {
        RequestContextHolder.currentRequestAttributes().setAttribute(attributeName, value, 0);
    }

    protected MediaType resolveContentType(String acceptHeader) {
        return this.resolveContentType(acceptHeader, MediaType.APPLICATION_JSON);
    }

    protected MediaType resolveContentType(String acceptHeader, MediaType defaultMediaType) {
        List mediaTypes = MediaType.parseMediaTypes((String)acceptHeader);
        if (mediaTypes.isEmpty()) {
            return defaultMediaType;
        }
        MediaType.sortBySpecificityAndQuality((List)mediaTypes);
        MediaType contentType = mediaTypes.stream().filter(mediaType -> mediaType.isCompatibleWith(MediaType.APPLICATION_JSON) || mediaType.isCompatibleWith(MediaType.APPLICATION_XML)).findFirst().orElseThrow(() -> new InvalidApiParameterException("Wrong Content-Type header in request"));
        if (contentType.equals((Object)MediaType.ALL)) {
            return defaultMediaType;
        }
        return contentType;
    }

    protected Optional<OffsetDateTime> getVersionAtTimeParam() {
        Map queryParams = ServletUriComponentsBuilder.fromCurrentRequest().build().getQueryParams().toSingleValueMap();
        String versionAtTime = (String)queryParams.get("version_at_time");
        if (StringUtils.isBlank((CharSequence)versionAtTime)) {
            return Optional.empty();
        }
        try {
            return Optional.of(OffsetDateTime.parse(UriUtils.decode((String)versionAtTime, (Charset)StandardCharsets.UTF_8)));
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("Value '" + versionAtTime + "' is not valid for version_at_time parameter. Value must be in the extended ISO 8601 format.", e);
        }
    }
}

