/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr;

import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.directory.Folder;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.net.URI;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.PreconditionFailedException;
import org.ehrbase.api.exception.StateConflictException;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.api.service.FolderService;
import org.ehrbase.response.ehrscape.FolderDto;
import org.ehrbase.response.openehr.DirectoryResponseData;
import org.ehrbase.rest.BaseController;
import org.ehrbase.rest.openehr.specification.DirectoryApiSpecification;
import org.joda.time.DateTime;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"${openehr-api.context-path:/rest/openehr}/v1/ehr"})
public class OpenehrDirectoryController
extends BaseController
implements DirectoryApiSpecification {
    private final FolderService folderService;
    private final EhrService ehrService;

    public OpenehrDirectoryController(FolderService folderService, EhrService ehrService) {
        this.folderService = folderService;
        this.ehrService = ehrService;
    }

    @Override
    @PostMapping(path={"/{ehr_id}/directory"})
    public ResponseEntity<DirectoryResponseData> createDirectory(@PathVariable(name="ehr_id") UUID ehrId, @RequestHeader(name="openEHR-VERSION", required=false) String openEhrVersion, @RequestHeader(name="openEHR-AUDIT_DETAILS", required=false) String openEhrAuditDetails, @RequestHeader(name="Content-Type") String contentType, @RequestHeader(name="Accept", defaultValue="application/json") String accept, @RequestHeader(name="Prefer", defaultValue="return=minimal") String prefer, @RequestBody Folder folder) {
        this.checkEhrExists(ehrId);
        if (this.ehrService.getDirectoryId(ehrId) != null) {
            throw new StateConflictException(String.format("EHR with id %s already contains a directory.", ehrId.toString()));
        }
        FolderDto createdFolder = (FolderDto)this.folderService.create(ehrId, (Locatable)folder).orElseThrow(() -> new InternalServerException("An error occurred while creating folder"));
        return this.createDirectoryResponse(HttpMethod.POST, prefer, accept, createdFolder, ehrId);
    }

    @Override
    @PutMapping(path={"/{ehr_id}/directory"})
    public ResponseEntity<DirectoryResponseData> updateDirectory(@PathVariable(name="ehr_id") UUID ehrId, @RequestHeader(name="If-Match") ObjectVersionId folderId, @RequestHeader(name="Content-Type") String contentType, @RequestHeader(name="Accept", defaultValue="application/json") String accept, @RequestHeader(name="Prefer", defaultValue="return=minimal") String prefer, @RequestHeader(name="openEHR-VERSION", required=false) String openEhrVersion, @RequestHeader(name="openEHR-AUDIT_DETAILS", required=false) String openEhrAuditDetails, @RequestBody Folder folder) {
        this.checkEhrExists(ehrId);
        this.checkDirectoryExists(ehrId);
        this.checkDirectoryVersionConflicts(folderId, ehrId);
        Optional updatedFolder = this.folderService.update(ehrId, folderId, (Locatable)folder);
        if (updatedFolder.isEmpty()) {
            throw new InternalServerException("Something went wrong. Folder could be persisted but not fetched again.");
        }
        return this.createDirectoryResponse(HttpMethod.PUT, prefer, accept, (FolderDto)updatedFolder.get(), ehrId);
    }

    @Override
    @DeleteMapping(path={"/{ehr_id}/directory"})
    public ResponseEntity<DirectoryResponseData> deleteDirectory(@PathVariable(name="ehr_id") UUID ehrId, @RequestHeader(name="openEHR-VERSION", required=false) String openEhrVersion, @RequestHeader(name="openEHR-AUDIT_DETAILS", required=false) String openEhrAuditDetails, @RequestHeader(name="Accept", defaultValue="application/json") String accept, @RequestHeader(name="If-Match") ObjectVersionId folderId) {
        this.checkEhrExists(ehrId);
        this.checkDirectoryExists(ehrId);
        this.checkDirectoryVersionConflicts(folderId, ehrId);
        this.ehrService.removeDirectory(ehrId);
        this.folderService.delete(ehrId, folderId);
        return this.createDirectoryResponse(HttpMethod.DELETE, null, accept, null, ehrId);
    }

    @Override
    @GetMapping(path={"/{ehr_id}/directory/{version_uid}"})
    public ResponseEntity<DirectoryResponseData> getFolderInDirectory(@PathVariable(name="ehr_id") UUID ehrId, @PathVariable(name="version_uid") ObjectVersionId versionUid, @RequestParam(name="path", required=false) String path, @RequestHeader(name="Accept", defaultValue="application/json") String accept) {
        this.checkEhrExists(ehrId);
        this.assertValidPath(path);
        Optional foundFolder = this.folderService.get(versionUid, path);
        if (foundFolder.isEmpty()) {
            throw new ObjectNotFoundException("DIRECTORY", String.format("Folder with id %s does not exist.", versionUid.toString()));
        }
        return this.createDirectoryResponse(HttpMethod.GET, "return=representation", accept, (FolderDto)foundFolder.get(), ehrId);
    }

    @Override
    @GetMapping(path={"/{ehr_id}/directory"})
    public ResponseEntity<DirectoryResponseData> getFolderInDirectoryVersionAtTime(@PathVariable(name="ehr_id") UUID ehrId, @RequestParam(name="version_at_time", required=false) String versionAtTime, @RequestParam(name="path", required=false) String path, @RequestHeader(name="Accept", required=false, defaultValue="application/json") String accept) {
        this.checkEhrExists(ehrId);
        this.assertValidPath(path);
        UUID directoryUuid = this.ehrService.getDirectoryId(ehrId);
        if (directoryUuid == null) {
            throw new ObjectNotFoundException("DIRECTORY", String.format("There is no directory stored for EHR with id %s. Maybe it has been deleted?", ehrId.toString()));
        }
        ObjectVersionId directoryId = new ObjectVersionId(directoryUuid.toString());
        Optional<OffsetDateTime> temporal = this.getVersionAtTimeParam();
        Optional foundFolder = versionAtTime != null && temporal.isPresent() ? this.folderService.getByTimeStamp(directoryId, Timestamp.from(temporal.get().toInstant()), path) : this.folderService.getLatest(directoryId, path);
        if (foundFolder.isEmpty()) {
            throw new ObjectNotFoundException("folder", "The FOLDER for ehrId " + ehrId.toString() + " does not exist.");
        }
        return this.createDirectoryResponse(HttpMethod.GET, "return=representation", accept, (FolderDto)foundFolder.get(), ehrId);
    }

    private DirectoryResponseData buildResponse(FolderDto folderDto) {
        DirectoryResponseData resBody = new DirectoryResponseData();
        resBody.setDetails(folderDto.getDetails());
        resBody.setFolders(folderDto.getFolders());
        resBody.setItems(folderDto.getItems());
        resBody.setName(folderDto.getName());
        resBody.setUid(folderDto.getUid());
        return resBody;
    }

    private ResponseEntity<DirectoryResponseData> createDirectoryResponse(HttpMethod method, String prefer, String accept, FolderDto folderDto, UUID ehrId) {
        HttpStatus successStatus;
        DirectoryResponseData body;
        HttpHeaders headers = new HttpHeaders();
        if (prefer != null && prefer.equals("return=representation")) {
            headers.setContentType(this.resolveContentType(accept, MediaType.APPLICATION_XML));
            body = this.buildResponse(folderDto);
            successStatus = this.getSuccessStatus(method);
        } else {
            body = null;
            successStatus = HttpStatus.NO_CONTENT;
        }
        if (folderDto != null) {
            String versionUid = folderDto.getUid().toString();
            headers.setETag("\"" + versionUid + "\"");
            headers.setLocation(URI.create(this.encodePath(this.getBaseEnvLinkURL() + "/rest/openehr/v1/ehr/" + ehrId.toString() + "/directory/" + versionUid)));
            headers.setLastModified(DateTime.now().getMillis());
        }
        return new ResponseEntity(body, (MultiValueMap)headers, successStatus);
    }

    private HttpStatus getSuccessStatus(HttpMethod method) {
        switch (method) {
            case POST: {
                return HttpStatus.CREATED;
            }
            case DELETE: {
                return HttpStatus.NO_CONTENT;
            }
        }
        return HttpStatus.OK;
    }

    private void assertValidPath(String path) {
        if (path == null) {
            return;
        }
        try {
            Paths.get(path, new String[0]);
        }
        catch (InvalidPathException e) {
            throw new InvalidApiParameterException("The value of path parameter is invalid", (Throwable)e);
        }
    }

    private void checkEhrExists(UUID ehrId) {
        if (!this.ehrService.doesEhrExist(ehrId)) {
            throw new ObjectNotFoundException("DIRECTORY", String.format("EHR with id %s not found", ehrId.toString()));
        }
    }

    private void checkDirectoryExists(UUID ehrId) {
        if (this.ehrService.getDirectoryId(ehrId) == null) {
            throw new PreconditionFailedException(String.format("EHR with id %s does not contain a directory. Maybe it has been deleted?", ehrId.toString()));
        }
    }

    private void checkDirectoryVersionConflicts(ObjectVersionId requestedFolderId, UUID ehrId) {
        UUID directoryUuid = this.ehrService.getDirectoryId(ehrId);
        int latestVersion = this.folderService.getLastVersionNumber(new ObjectVersionId(directoryUuid.toString()));
        String directoryId = String.format("%s::%s::%d", directoryUuid, this.ehrService.getServerConfig().getNodename(), latestVersion);
        if (requestedFolderId != null && !requestedFolderId.toString().equals(directoryId)) {
            throw new PreconditionFailedException("If-Match version_uid does not match latest version.", directoryId, this.encodePath(this.getBaseEnvLinkURL() + "/rest/openehr/v1/ehr/" + ehrId.toString() + "/directory/" + directoryId));
        }
    }
}

