/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ehrbase.api.definitions.QueryMode;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.service.QueryService;
import org.ehrbase.response.ehrscape.QueryDefinitionResultDto;
import org.ehrbase.response.openehr.QueryResponseData;
import org.ehrbase.rest.BaseController;
import org.ehrbase.rest.openehr.audit.OpenEhrAuditInterceptor;
import org.ehrbase.rest.openehr.audit.QueryAuditInterceptor;
import org.ehrbase.rest.openehr.specification.QueryApiSpecification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"${openehr-api.context-path:/rest/openehr}/v1/query"})
public class OpenehrQueryController
extends BaseController
implements QueryApiSpecification {
    private static final String EHR_ID_VALUE = "ehr_id/value";
    private static final String LATEST = "LATEST";
    private static final String QUERY_PARAMETERS = "query_parameters";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final QueryService queryService;

    public OpenehrQueryController(QueryService queryService) {
        this.queryService = queryService;
    }

    @Override
    @GetMapping(path={"/aql"})
    @PostAuthorize(value="checkAbacPostQuery(@queryServiceImp.getAuditResultMap())")
    public ResponseEntity<QueryResponseData> executeAdHocQuery(@RequestParam(name="q") String query, @RequestParam(name="offset", required=false) Integer offset, @RequestParam(name="fetch", required=false) Integer fetch, @RequestParam(name="query_parameters", required=false) Map<String, Object> queryParameters, @RequestHeader(name="Accept", required=false) String accept, HttpServletRequest request) {
        if (fetch != null) {
            query = this.withFetch(query, fetch);
        }
        if (offset != null) {
            query = this.withOffset(query, offset);
        }
        request.setAttribute(QueryAuditInterceptor.QUERY_ATTRIBUTE, (Object)query);
        QueryResponseData body = this.executeQuery(query, queryParameters, request);
        if (!CollectionUtils.isEmpty((Collection)body.getRows())) {
            return ResponseEntity.ok((Object)body);
        }
        return ResponseEntity.noContent().build();
    }

    @Override
    @PostMapping(path={"/aql"})
    @PostAuthorize(value="checkAbacPostQuery(@queryServiceImp.getAuditResultMap())")
    public ResponseEntity<QueryResponseData> executeAdHocQuery(@RequestBody Map<String, Object> queryRequest, @RequestHeader(name="Accept", required=false) String accept, @RequestHeader(name="Content-Type") String contentType, HttpServletRequest request) {
        this.logger.debug("Got following input: {}", queryRequest);
        String aql = (String)queryRequest.get("q");
        if (aql == null) {
            throw new InvalidApiParameterException("No aql query provided");
        }
        aql = this.withOffsetLimit(aql, queryRequest);
        request.setAttribute(QueryAuditInterceptor.QUERY_ATTRIBUTE, (Object)aql);
        Map parameters = (Map)queryRequest.get(QUERY_PARAMETERS);
        QueryResponseData body = this.executeQuery(aql, parameters, request);
        return ResponseEntity.ok((Object)body);
    }

    @Override
    @GetMapping(path={"/{qualified_query_name}", "/{qualified_query_name}/{version}"})
    @PostAuthorize(value="checkAbacPostQuery(@queryServiceImp.getAuditResultMap())")
    public ResponseEntity<QueryResponseData> executeStoredQuery(@PathVariable(name="qualified_query_name") String qualifiedQueryName, @PathVariable(name="version", required=false) String version, @RequestParam(name="offset", required=false) Integer offset, @RequestParam(name="fetch", required=false) Integer fetch, @RequestParam(name="query_parameters", required=false) Map<String, Object> queryParameter, @RequestHeader(name="Accept", required=false) String accept, HttpServletRequest request) {
        this.logger.trace("getStoredQuery not implemented but got following input: {} - {} - {} - {} - {}", new Object[]{qualifiedQueryName, version, offset, fetch, queryParameter});
        request.setAttribute(QueryAuditInterceptor.QUERY_ID_ATTRIBUTE, (Object)qualifiedQueryName);
        QueryDefinitionResultDto queryDefinitionResultDto = this.queryService.retrieveStoredQuery(qualifiedQueryName, version != null ? version : LATEST);
        String query = queryDefinitionResultDto.getQueryText();
        request.setAttribute(QueryAuditInterceptor.QUERY_ATTRIBUTE, (Object)query);
        if (fetch != null) {
            query = this.withFetch(query, fetch);
        }
        if (offset != null) {
            query = this.withOffset(query, offset);
        }
        QueryResponseData queryResponseData = this.invoke(query, queryParameter, request);
        queryResponseData.setName(queryDefinitionResultDto.getQualifiedName() + "/" + queryDefinitionResultDto.getVersion());
        return ResponseEntity.ok((Object)queryResponseData);
    }

    @Override
    @PostMapping(path={"/{qualified_query_name}", "/{qualified_query_name}/{version}"})
    @PostAuthorize(value="checkAbacPostQuery(@queryServiceImp.getAuditResultMap())")
    public ResponseEntity<QueryResponseData> executeStoredQuery(@PathVariable(name="qualified_query_name") String qualifiedQueryName, @PathVariable(name="version", required=false) String version, @RequestHeader(name="Accept", required=false) String accept, @RequestHeader(name="Content-Type") String contentType, @RequestBody(required=false) Map<String, Object> queryRequest, HttpServletRequest request) {
        this.logger.trace("postStoredQuery with the following input: {}, {}, {}", new Object[]{qualifiedQueryName, version, queryRequest});
        request.setAttribute(QueryAuditInterceptor.QUERY_ID_ATTRIBUTE, (Object)qualifiedQueryName);
        QueryDefinitionResultDto queryDefinitionResultDto = this.queryService.retrieveStoredQuery(qualifiedQueryName, version != null ? version : LATEST);
        String query = queryDefinitionResultDto.getQueryText();
        if (query == null) {
            String message = MessageFormat.format("Could not retrieve AQL {0}/{1}", qualifiedQueryName, version != null ? version : LATEST);
            throw new ObjectNotFoundException("AQL", message);
        }
        request.setAttribute(QueryAuditInterceptor.QUERY_ATTRIBUTE, (Object)query);
        Map queryParameter = null;
        if (queryRequest != null && !queryRequest.isEmpty()) {
            queryParameter = (Map)queryRequest.get(QUERY_PARAMETERS);
            query = this.withOffsetLimit(query, queryRequest);
        }
        QueryResponseData queryResponseData = this.invoke(query, queryParameter, request);
        queryResponseData.setName(queryDefinitionResultDto.getQualifiedName() + "/" + queryDefinitionResultDto.getVersion());
        return ResponseEntity.ok((Object)queryResponseData);
    }

    private QueryResponseData executeQuery(String aql, Map<String, Object> parameters, HttpServletRequest request) {
        QueryResponseData queryResponseData = parameters != null && !parameters.isEmpty() ? new QueryResponseData(this.queryService.query(aql, parameters, QueryMode.AQL, false)) : new QueryResponseData(this.queryService.query(aql, QueryMode.AQL, false));
        Map auditResultMap = this.queryService.getAuditResultMap();
        request.setAttribute(OpenEhrAuditInterceptor.EHR_ID_ATTRIBUTE, auditResultMap.get(EHR_ID_VALUE));
        return queryResponseData;
    }

    private String withFetch(String query, String value) {
        return this.withFetch(query, this.double2int(value));
    }

    private String withFetch(String query, Integer value) {
        return this.orderedLimitOffset(query, "LIMIT", value);
    }

    private String orderedLimitOffset(String query, String keyword, Integer value) {
        Object queryFormatted;
        if (query.replace(" ", "").toUpperCase().contains("ORDERBY")) {
            String[] strings = query.split("(?i)ORDER");
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append(strings[0]);
            queryBuilder.append(keyword.toUpperCase());
            queryBuilder.append(" ");
            queryBuilder.append(value);
            queryBuilder.append(" ORDER");
            queryBuilder.append(strings[1]);
            queryFormatted = queryBuilder.toString();
        } else {
            queryFormatted = query + " " + keyword + " " + value;
        }
        return queryFormatted;
    }

    private String withOffset(String query, String value) {
        return this.withOffset(query, this.double2int(value));
    }

    private String withOffset(String query, Integer value) {
        return this.orderedLimitOffset(query, "OFFSET", value);
    }

    private Integer double2int(String value) {
        return Double.valueOf(value).intValue();
    }

    private QueryResponseData invoke(String query, Map<String, Object> queryParameter, HttpServletRequest request) {
        QueryResponseData queryResponseData;
        if (queryParameter != null && !queryParameter.isEmpty()) {
            HashMap<String, Object> parameters = new HashMap<String, Object>(queryParameter);
            queryResponseData = new QueryResponseData(this.queryService.query(query, parameters, QueryMode.AQL, false));
        } else {
            queryResponseData = new QueryResponseData(this.queryService.query(query, QueryMode.AQL, false));
        }
        Map auditResultMap = this.queryService.getAuditResultMap();
        request.setAttribute(OpenEhrAuditInterceptor.EHR_ID_ATTRIBUTE, auditResultMap.get(EHR_ID_VALUE));
        return queryResponseData;
    }

    String withOffsetLimit(String query, Map<String, Object> mapped) {
        if (mapped.containsKey("fetch")) {
            query = this.withFetch(query, mapped.get("fetch").toString());
        }
        if (mapped.containsKey("offset")) {
            query = this.withOffset(query, mapped.get("offset").toString());
        }
        return query;
    }
}

