/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr;

import com.nedap.archie.rm.changecontrol.OriginalVersion;
import com.nedap.archie.rm.changecontrol.VersionedObject;
import com.nedap.archie.rm.ehr.EhrStatus;
import com.nedap.archie.rm.ehr.VersionedEhrStatus;
import com.nedap.archie.rm.generic.RevisionHistory;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.service.ContributionService;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.response.ehrscape.ContributionDto;
import org.ehrbase.response.openehr.OriginalVersionResponseData;
import org.ehrbase.response.openehr.RevisionHistoryResponseData;
import org.ehrbase.response.openehr.VersionedObjectResponseData;
import org.ehrbase.rest.BaseController;
import org.ehrbase.rest.openehr.specification.VersionedEhrStatusApiSpecification;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"${openehr-api.context-path:/rest/openehr}/v1/ehr/{ehr_id}/versioned_ehr_status"}, produces={"application/json", "application/xml"})
public class OpenehrVersionedEhrStatusController
extends BaseController
implements VersionedEhrStatusApiSpecification {
    private final ContributionService contributionService;
    private final EhrService ehrService;

    public OpenehrVersionedEhrStatusController(EhrService ehrService, ContributionService contributionService) {
        this.ehrService = Objects.requireNonNull(ehrService);
        this.contributionService = Objects.requireNonNull(contributionService);
    }

    @Override
    @GetMapping
    public ResponseEntity<VersionedObjectResponseData<EhrStatus>> retrieveVersionedEhrStatusByEhr(@PathVariable(value="ehr_id") String ehrIdString, @RequestHeader(value="Accept", required=false) String accept) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        if (!this.ehrService.hasEhr(ehrId)) {
            throw new ObjectNotFoundException("ehr", "No EHR with this ID can be found");
        }
        VersionedEhrStatus versionedEhrStatus = this.ehrService.getVersionedEhrStatus(ehrId);
        VersionedObjectResponseData response = new VersionedObjectResponseData((VersionedObject)versionedEhrStatus);
        HttpHeaders respHeaders = new HttpHeaders();
        respHeaders.setContentType(this.resolveContentType(accept));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(respHeaders)).body((Object)response);
    }

    @Override
    @GetMapping(path={"/revision_history"})
    public ResponseEntity<RevisionHistoryResponseData> retrieveVersionedEhrStatusRevisionHistoryByEhr(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="ehr_id") String ehrIdString) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        if (!this.ehrService.hasEhr(ehrId)) {
            throw new ObjectNotFoundException("ehr", "No EHR with this ID can be found");
        }
        RevisionHistory revisionHistory = this.ehrService.getRevisionHistoryOfVersionedEhrStatus(ehrId);
        RevisionHistoryResponseData response = new RevisionHistoryResponseData(revisionHistory);
        HttpHeaders respHeaders = new HttpHeaders();
        respHeaders.setContentType(this.resolveContentType(accept));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(respHeaders)).body((Object)response);
    }

    @Override
    @GetMapping(path={"/version"})
    @PreAuthorize(value="checkAbacPre(@openehrVersionedEhrStatusController.EHR_STATUS, @ehrService.getSubjectExtRef(#ehrIdString), null, null)")
    public ResponseEntity<OriginalVersionResponseData<EhrStatus>> retrieveVersionOfEhrStatusByTime(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="ehr_id") String ehrIdString, @RequestParam(value="version_at_time", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime versionAtTime) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        if (!this.ehrService.hasEhr(ehrId)) {
            throw new ObjectNotFoundException("ehr", "No EHR with this ID can be found");
        }
        UUID versionedObjectId = this.ehrService.getEhrStatusVersionedObjectUidByEhr(ehrId);
        int version = versionAtTime != null ? this.ehrService.getEhrStatusVersionByTimestamp(ehrId, Timestamp.valueOf(versionAtTime)) : Integer.parseInt(this.ehrService.getLatestVersionUidOfStatus(ehrId).split("::")[2]);
        Optional ehrStatusOriginalVersion = this.ehrService.getEhrStatusAtVersion(ehrId, versionedObjectId, version);
        UUID contributionId = ehrStatusOriginalVersion.map(i -> UUID.fromString(i.getContribution().getId().getValue())).orElseThrow(() -> new InvalidApiParameterException("Couldn't retrieve EhrStatus with given parameters"));
        Optional optionalContributionDto = this.contributionService.getContribution(ehrId, contributionId);
        ContributionDto contributionDto = (ContributionDto)optionalContributionDto.orElseThrow(() -> new InternalServerException("Couldn't fetch contribution for existing EhrStatus"));
        OriginalVersionResponseData originalVersionResponseData = new OriginalVersionResponseData((OriginalVersion)ehrStatusOriginalVersion.get(), contributionDto);
        HttpHeaders respHeaders = new HttpHeaders();
        respHeaders.setContentType(this.resolveContentType(accept));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(respHeaders)).body((Object)originalVersionResponseData);
    }

    @Override
    @GetMapping(path={"/version/{version_uid}"})
    @PreAuthorize(value="checkAbacPre(@openehrVersionedEhrStatusController.EHR_STATUS, @ehrService.getSubjectExtRef(#ehrIdString), null, null)")
    public ResponseEntity<OriginalVersionResponseData<EhrStatus>> retrieveVersionOfEhrStatusByVersionUid(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="ehr_id") String ehrIdString, @PathVariable(value="version_uid") String versionUid) {
        int version;
        UUID versionedObjectId;
        UUID ehrId = this.getEhrUuid(ehrIdString);
        if (!this.ehrService.hasEhr(ehrId)) {
            throw new ObjectNotFoundException("ehr", "No EHR with this ID can be found.");
        }
        try {
            versionedObjectId = UUID.fromString(versionUid.split("::")[0]);
            version = Integer.parseInt(versionUid.split("::")[2]);
        }
        catch (Exception e) {
            throw new InvalidApiParameterException("VERSION UID parameter has wrong format: " + e.getMessage());
        }
        if (version < 1) {
            throw new InvalidApiParameterException("Version can't be negative.");
        }
        if (!this.ehrService.hasStatus(versionedObjectId)) {
            throw new ObjectNotFoundException("ehr_status", "No EHR_STATUS with given ID can be found.");
        }
        Optional ehrStatusOriginalVersion = this.ehrService.getEhrStatusAtVersion(ehrId, versionedObjectId, version);
        UUID contributionId = ehrStatusOriginalVersion.map(i -> UUID.fromString(i.getContribution().getId().getValue())).orElseThrow(() -> new InvalidApiParameterException("Couldn't retrieve EhrStatus with given parameters"));
        Optional optionalContributionDto = this.contributionService.getContribution(ehrId, contributionId);
        ContributionDto contributionDto = (ContributionDto)optionalContributionDto.orElseThrow(() -> new InternalServerException("Couldn't fetch contribution for existing EhrStatus"));
        OriginalVersionResponseData originalVersionResponseData = new OriginalVersionResponseData((OriginalVersion)ehrStatusOriginalVersion.get(), contributionDto);
        HttpHeaders respHeaders = new HttpHeaders();
        respHeaders.setContentType(this.resolveContentType(accept));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(respHeaders)).body((Object)originalVersionResponseData);
    }
}

