/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr.audit;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.rest.openehr.audit.CompositionAuditInterceptor;
import org.ehrbase.rest.openehr.audit.OpenEhrAuditInterceptor;
import org.ehrbase.rest.openehr.audit.QueryAuditDataset;
import org.ehrbase.rest.openehr.audit.support.QueryAuditMessageBuilder;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.model.AuditMessage;

public class QueryAuditInterceptor
extends OpenEhrAuditInterceptor<QueryAuditDataset> {
    public static final String QUERY_ATTRIBUTE = CompositionAuditInterceptor.class.getName() + ".QUERY";
    public static final String QUERY_ID_ATTRIBUTE = CompositionAuditInterceptor.class.getName() + ".QUERY_ID";

    public QueryAuditInterceptor(AuditContext auditContext, EhrService ehrService) {
        super(auditContext, ehrService);
    }

    @Override
    protected QueryAuditDataset createAuditDataset() {
        return new QueryAuditDataset();
    }

    @Override
    protected void enrichDataset(QueryAuditDataset auditDataset, HttpServletRequest request, HttpServletResponse response) {
        super.enrichDataset(auditDataset, request, response);
        auditDataset.setQuery((String)request.getAttribute(QUERY_ATTRIBUTE));
        auditDataset.setQueryId((String)request.getAttribute(QUERY_ID_ATTRIBUTE));
    }

    @Override
    protected AuditMessage[] getAuditMessages(QueryAuditDataset auditDataset) {
        return (AuditMessage[])auditDataset.getPatientParticipantObjectIds().stream().map(patientNumber -> new QueryAuditMessageBuilder(this.auditContext, auditDataset, (String)patientNumber).getMessage()).toArray(AuditMessage[]::new);
    }
}

