/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.admin;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.UUID;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.api.service.FolderService;
import org.ehrbase.response.openehr.admin.AdminDeleteResponseData;
import org.ehrbase.rest.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Admin - Directory")
@ConditionalOnProperty(prefix="admin-api", name={"active"})
@RestController
@RequestMapping(path={"${admin-api.context-path:/rest/admin}/ehr"}, produces={"application/json", "application/xml"})
public class AdminDirectoryController
extends BaseController {
    private final EhrService ehrService;
    private final FolderService folderService;

    @Autowired
    public AdminDirectoryController(EhrService ehrService, FolderService folderService) {
        this.ehrService = ehrService;
        this.folderService = folderService;
    }

    @DeleteMapping(path={"/{ehr_id}/directory/{directory_id}"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Directory has been deleted successfully", headers={@Header(name="Content-Type", description="Format of response", schema=@Schema(implementation=MediaType.class))}), @ApiResponse(responseCode="401", description="Client credentials are invalid or have expired."), @ApiResponse(responseCode="403", description="Client has no permission to access since admin role is missing."), @ApiResponse(responseCode="404", description="EHR or Directory could not be found.")})
    public ResponseEntity<AdminDeleteResponseData> deleteDirectory(@Parameter(description="Target EHR ed to remove Directory from", required=true) @PathVariable(value="ehr_id") String ehrId, @Parameter(description="Target Directory id to delete", required=true) @PathVariable(value="directory_id") String directoryId) {
        UUID ehrUuid = UUID.fromString(ehrId);
        if (!this.ehrService.hasEhr(ehrUuid)) {
            throw new ObjectNotFoundException("Admin Directory", String.format("EHR with id %s does not exist", ehrId));
        }
        UUID folderUid = UUID.fromString(directoryId);
        this.folderService.adminDeleteFolder(folderUid);
        return ResponseEntity.noContent().build();
    }
}

