/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.ehrbase.api.service.QueryService;
import org.ehrbase.response.openehr.ErrorBodyPayload;
import org.ehrbase.response.openehr.QueryDefinitionListResponseData;
import org.ehrbase.response.openehr.QueryDefinitionResponseData;
import org.ehrbase.rest.BaseController;
import org.ehrbase.rest.openehr.specification.DefinitionQueryApiSpecification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"${openehr-api.context-path:/rest/openehr}/v1/definition/query"}, produces={"application/json", "application/xml"})
public class OpenehrDefinitionQueryController
extends BaseController
implements DefinitionQueryApiSpecification {
    static final Logger log = LoggerFactory.getLogger(OpenehrDefinitionQueryController.class);
    private final QueryService queryService;

    @Autowired
    public OpenehrDefinitionQueryController(QueryService queryService) {
        this.queryService = Objects.requireNonNull(queryService);
    }

    @Override
    @RequestMapping(value={"/{qualified_query_name}", ""}, method={RequestMethod.GET})
    public ResponseEntity<QueryDefinitionListResponseData> getStoredQueryList(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="qualified_query_name", required=false) String qualifiedQueryName) {
        log.debug("getStoredQueryList invoked with the following input: " + qualifiedQueryName);
        QueryDefinitionListResponseData responseData = new QueryDefinitionListResponseData(this.queryService.retrieveStoredQueries(qualifiedQueryName));
        return ResponseEntity.ok((Object)responseData);
    }

    @Override
    @RequestMapping(value={"/{qualified_query_name}/{version}"}, method={RequestMethod.GET})
    public ResponseEntity<QueryDefinitionResponseData> getStoredQueryVersion(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="qualified_query_name") String qualifiedQueryName, @PathVariable(value="version") Optional<String> version) {
        log.debug("getStoredQueryVersion invoked with the following input: " + qualifiedQueryName + ", version:" + version);
        QueryDefinitionResponseData queryDefinitionResponseData = new QueryDefinitionResponseData(this.queryService.retrieveStoredQuery(qualifiedQueryName, version.isPresent() ? version.get() : null));
        return ResponseEntity.ok((Object)queryDefinitionResponseData);
    }

    @Override
    @RequestMapping(value={"/{qualified_query_name}/{version}{?type}", "/{qualified_query_name}{?type}"}, method={RequestMethod.PUT})
    public ResponseEntity<QueryDefinitionResponseData> putStoreQuery(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="qualified_query_name") String qualifiedQueryName, @PathVariable(value="version") Optional<String> version, @RequestParam(value="type", required=false, defaultValue="AQL") String type, @RequestBody String queryPayload) {
        log.debug("putStoreQuery invoked with the following input: " + qualifiedQueryName + ", version:" + version + ", query:" + queryPayload + ", type=" + type);
        Gson gson = new GsonBuilder().create();
        Map mapped = (Map)gson.fromJson(queryPayload, Map.class);
        String aql = (String)mapped.get("q");
        if (aql == null || aql.isEmpty()) {
            return new ResponseEntity((Object)new ErrorBodyPayload("Invalid query", "no aql query provided in payload").toString(), HttpStatus.BAD_REQUEST);
        }
        QueryDefinitionResponseData queryDefinitionResponseData = new QueryDefinitionResponseData(this.queryService.createStoredQuery(qualifiedQueryName, (String)version.orElse(null), aql));
        return ResponseEntity.ok((Object)queryDefinitionResponseData);
    }

    @Override
    @RequestMapping(value={"/{qualified_query_name}/{version}"}, method={RequestMethod.DELETE})
    public ResponseEntity<QueryDefinitionResponseData> deleteStoredQuery(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="qualified_query_name") String qualifiedQueryName, @PathVariable(value="version") String version) {
        log.debug("deleteStoredQuery for the following input: {} , version: {}", (Object)qualifiedQueryName, (Object)version);
        QueryDefinitionResponseData queryDefinitionResponseData = new QueryDefinitionResponseData(this.queryService.deleteStoredQuery(qualifiedQueryName, version));
        return ResponseEntity.ok((Object)queryDefinitionResponseData);
    }
}

