/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr.audit;

import java.net.URI;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.service.CompositionService;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.response.ehrscape.CompositionDto;
import org.ehrbase.rest.openehr.audit.CompositionAuditDataset;
import org.ehrbase.rest.openehr.audit.OpenEhrAuditInterceptor;
import org.ehrbase.rest.openehr.audit.support.CompositionAuditMessageBuilder;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.model.AuditMessage;
import org.springframework.web.util.UriComponentsBuilder;

public class CompositionAuditInterceptor
extends OpenEhrAuditInterceptor<CompositionAuditDataset> {
    public static final String COMPOSITION_ID_ATTRIBUTE = CompositionAuditInterceptor.class.getName() + ".COMPOSITION_ID";
    public static final String VERSION_ATTRIBUTE = CompositionAuditInterceptor.class.getName() + ".VERSION";
    private final CompositionService compositionService;

    public CompositionAuditInterceptor(AuditContext auditContext, EhrService ehrService, CompositionService compositionService) {
        super(auditContext, ehrService);
        this.compositionService = compositionService;
    }

    @Override
    protected CompositionAuditDataset createAuditDataset() {
        return new CompositionAuditDataset();
    }

    @Override
    protected void enrichDataset(CompositionAuditDataset auditDataset, HttpServletRequest request, HttpServletResponse response) {
        super.enrichDataset(auditDataset, request, response);
        auditDataset.setCompositionUri(this.getCompositionUri(request));
        auditDataset.setTemplateId(this.getTemplateId(request));
    }

    @Override
    protected AuditMessage[] getAuditMessages(CompositionAuditDataset auditDataset) {
        CompositionAuditMessageBuilder builder = new CompositionAuditMessageBuilder(this.auditContext, auditDataset);
        if (auditDataset.hasCompositionUri()) {
            builder.addCompositionParticipantObjectIdentification(auditDataset);
        }
        if (auditDataset.hasPatientParticipantObjectIds()) {
            builder.addPatientParticipantObjectIdentification(auditDataset);
        }
        return builder.getMessages();
    }

    private String getCompositionUri(HttpServletRequest request) {
        UUID compositionId = (UUID)request.getAttribute(COMPOSITION_ID_ATTRIBUTE);
        if (compositionId != null) {
            UUID ehrId = this.getUniqueEhrId(request);
            Integer version = (Integer)request.getAttribute(VERSION_ATTRIBUTE);
            if (version == null || version == 0) {
                version = this.compositionService.getLastVersionNumber(compositionId);
            }
            URI uri = UriComponentsBuilder.fromPath((String)"ehr/{ehrId}/composition/{compositionId}::{nodeName}::{version}").build(new Object[]{ehrId, compositionId, this.compositionService.getServerConfig().getNodename(), version});
            return uri.toString();
        }
        return StringUtils.remove((String)request.getRequestURI(), (String)"/ehrbase/rest/openehr/v1/");
    }

    private String getTemplateId(HttpServletRequest request) {
        UUID compositionId = (UUID)request.getAttribute(COMPOSITION_ID_ATTRIBUTE);
        if (compositionId == null) {
            return null;
        }
        Integer version = (Integer)request.getAttribute(VERSION_ATTRIBUTE);
        if (version == null || version == 0) {
            version = this.compositionService.getLastVersionNumber(compositionId);
        }
        return this.compositionService.retrieve(compositionId, version).map(CompositionDto::getTemplateId).orElse(null);
    }
}

