/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr.audit;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.ehrbase.api.exception.InternalServerException;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.springframework.http.HttpMethod;

public class OpenEhrAuditDataset
implements Serializable {
    private EventOutcomeIndicator eventOutcomeIndicator;
    private String eventOutcomeDescription;
    private String auditEnterpriseSiteId;
    private HttpMethod method;
    private String sourceParticipantUserId;
    private String sourceParticipantNetworkId;
    private Set<String> patientParticipantObjectIds = new HashSet<String>();
    private static final String MISSING_PAT_ID = "<unknown>";

    public EventOutcomeIndicator getEventOutcomeIndicator() {
        return this.eventOutcomeIndicator;
    }

    public void setEventOutcomeIndicator(EventOutcomeIndicator eventOutcomeIndicator) {
        this.eventOutcomeIndicator = eventOutcomeIndicator;
    }

    public String getEventOutcomeDescription() {
        return this.eventOutcomeDescription;
    }

    public void setEventOutcomeDescription(String eventOutcomeDescription) {
        this.eventOutcomeDescription = eventOutcomeDescription;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public String getSourceParticipantUserId() {
        return this.sourceParticipantUserId;
    }

    public void setSourceParticipantUserId(String sourceParticipantUserId) {
        this.sourceParticipantUserId = sourceParticipantUserId;
    }

    public String getSourceParticipantNetworkId() {
        return this.sourceParticipantNetworkId;
    }

    public void setSourceParticipantNetworkId(String sourceParticipantNetworkId) {
        this.sourceParticipantNetworkId = sourceParticipantNetworkId;
    }

    public Set<String> getPatientParticipantObjectIds() {
        return this.patientParticipantObjectIds.stream().filter(id -> id != null).collect(Collectors.toSet());
    }

    public void setPatientParticipantObjectIds(Set<String> patientParticipantObjectIds) {
        this.patientParticipantObjectIds = patientParticipantObjectIds;
    }

    public void addPatientParticipantObjectIds(Collection<String> patientParticipantObjectIds) {
        this.patientParticipantObjectIds.addAll(patientParticipantObjectIds);
    }

    public boolean hasPatientParticipantObjectIds() {
        return this.patientParticipantObjectIds != null && !this.patientParticipantObjectIds.isEmpty();
    }

    public String getUniquePatientParticipantObjectId() {
        Set<String> ids = this.getPatientParticipantObjectIds();
        if (ids.isEmpty()) {
            return MISSING_PAT_ID;
        }
        if (ids.size() == 1) {
            return ids.iterator().next();
        }
        throw new InternalServerException("Non unique patient number result");
    }

    public boolean hasUniqueParticipantObjectIds() {
        return this.hasPatientParticipantObjectIds() && this.patientParticipantObjectIds.size() == 1;
    }

    public String getAuditEnterpriseSiteId() {
        return this.auditEnterpriseSiteId;
    }

    public void setAuditEnterpriseSiteId(String auditEnterpriseSiteId) {
        this.auditEnterpriseSiteId = auditEnterpriseSiteId;
    }
}

