/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.admin;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.UUID;
import org.ehrbase.api.annotations.TenantAware;
import org.ehrbase.api.authorization.EhrbaseAuthorization;
import org.ehrbase.api.authorization.EhrbaseAuthorizations;
import org.ehrbase.api.authorization.EhrbasePermission;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.response.openehr.admin.AdminDeleteResponseData;
import org.ehrbase.response.openehr.admin.AdminUpdateResponseData;
import org.ehrbase.rest.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@TenantAware
@Tag(name="Admin - EHR")
@ConditionalOnProperty(prefix="admin-api", name={"active"})
@RestController
@RequestMapping(path={"${admin-api.context-path:/rest/admin}/ehr"}, produces={"application/json", "application/xml"})
public class AdminEhrController
extends BaseController {
    private final EhrService ehrService;

    @Autowired
    public AdminEhrController(EhrService ehrService) {
        this.ehrService = ehrService;
    }

    @EhrbaseAuthorizations(value={@EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_ADMIN_ACCESS), @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_EHR_UPDATE)})
    @PutMapping(path={"/{ehr_id}"}, consumes={"application/json", "application/xml"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="EHR has been updated and number of updated items will be returned in the body.", headers={@Header(name="Content-Type", description="Format of response", schema=@Schema(implementation=MediaType.class))}), @ApiResponse(responseCode="401", description="Client credentials are invalid or have been expired."), @ApiResponse(responseCode="403", description="Client is not permitted to access this resource since the admin role is missing."), @ApiResponse(responseCode="404", description="EHR with id could not be found.")})
    public ResponseEntity<AdminUpdateResponseData> updateEhr(@Parameter(description="Client requested response content type") @RequestHeader(value="Accept", required=false) String accept, @Parameter(description="Target EHR id to update", required=true) @PathVariable(value="ehr_id") String ehrId) {
        UUID ehrUuid = UUID.fromString(ehrId);
        if (!this.ehrService.hasEhr(ehrUuid)) {
            throw new ObjectNotFoundException("Admin EHR", String.format("EHR with id %s does not exist.", ehrId));
        }
        return ResponseEntity.ok().body((Object)new AdminUpdateResponseData(0));
    }

    @EhrbaseAuthorizations(value={@EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_ADMIN_ACCESS), @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_EHR_DELETE)})
    @DeleteMapping(path={"/{ehr_id}"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="EHR has been deleted successfully"), @ApiResponse(responseCode="401", description="Client credentials are invalid or have been expired."), @ApiResponse(responseCode="403", description="Client is not permitted to access this resource since the admin role is missing."), @ApiResponse(responseCode="404", description="EHR with id could not be found.")})
    public ResponseEntity<AdminDeleteResponseData> deleteEhr(@Parameter(description="Target EHR id to delete", required=true) @PathVariable(value="ehr_id") String ehrId) {
        UUID ehrUuid = UUID.fromString(ehrId);
        if (!this.ehrService.hasEhr(ehrUuid)) {
            throw new ObjectNotFoundException("Admin EHR", String.format("EHR with id %s does not exist.", ehrId));
        }
        this.ehrService.adminDeleteEhr(ehrUuid);
        return ResponseEntity.noContent().build();
    }
}

