/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.annotations.TenantAware;
import org.ehrbase.api.authorization.EhrbaseAuthorization;
import org.ehrbase.api.authorization.EhrbasePermission;
import org.ehrbase.api.exception.GeneralRequestProcessingException;
import org.ehrbase.api.exception.UnexpectedSwitchCaseException;
import org.ehrbase.api.exception.UnsupportedMediaTypeException;
import org.ehrbase.api.service.QueryService;
import org.ehrbase.response.ehrscape.QueryDefinitionResultDto;
import org.ehrbase.response.openehr.ErrorBodyPayload;
import org.ehrbase.response.openehr.QueryDefinitionListResponseData;
import org.ehrbase.response.openehr.QueryDefinitionResponseData;
import org.ehrbase.rest.BaseController;
import org.ehrbase.rest.openehr.specification.DefinitionQueryApiSpecification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@TenantAware
@RestController
@RequestMapping(path={"${openehr-api.context-path:/rest/openehr}/v1/definition/query"}, produces={"application/json", "application/xml"})
public class OpenehrDefinitionQueryController
extends BaseController
implements DefinitionQueryApiSpecification {
    private static final String AQL = "AQL";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final QueryService queryService;

    @Autowired
    public OpenehrDefinitionQueryController(QueryService queryService) {
        this.queryService = Objects.requireNonNull(queryService);
    }

    @Override
    @GetMapping(value={"/{qualified_query_name}", ""})
    @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_QUERY_READ)
    public ResponseEntity<QueryDefinitionListResponseData> getStoredQueryList(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="qualified_query_name", required=false) String qualifiedQueryName) {
        this.logger.debug("getStoredQueryList invoked with the following input: {}", (Object)qualifiedQueryName);
        QueryDefinitionListResponseData responseData = new QueryDefinitionListResponseData(this.queryService.retrieveStoredQueries(qualifiedQueryName));
        return ResponseEntity.ok((Object)responseData);
    }

    @Override
    @GetMapping(value={"/{qualified_query_name}/{version}"})
    @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_QUERY_READ)
    public ResponseEntity<QueryDefinitionResponseData> getStoredQueryVersion(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="qualified_query_name") String qualifiedQueryName, @PathVariable(value="version") Optional<String> version) {
        this.logger.debug("getStoredQueryVersion invoked with the following input: {}, version:{}", (Object)qualifiedQueryName, version);
        QueryDefinitionResponseData queryDefinitionResponseData = new QueryDefinitionResponseData(this.queryService.retrieveStoredQuery(qualifiedQueryName, (String)version.orElse(null)));
        return ResponseEntity.ok((Object)queryDefinitionResponseData);
    }

    @Override
    @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_QUERY_CREATE)
    @PutMapping(value={"/{qualified_query_name}/{version}", "/{qualified_query_name}"}, consumes={"text/plain", "application/json"}, produces={"application/json"})
    public ResponseEntity<QueryDefinitionResponseData> putStoredQuery(@RequestHeader(value="Content-Type", required=false) String contentType, @RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="qualified_query_name") String qualifiedQueryName, @PathVariable(value="version") Optional<String> version, @RequestParam(value="type", required=false, defaultValue="AQL") String type, @RequestBody String queryPayload) {
        String aql;
        this.logger.debug("putStoreQuery invoked with the following input: {}, version: {}, query: {}, type: {}", new Object[]{qualifiedQueryName, version, queryPayload, type});
        if (!AQL.equalsIgnoreCase(type)) {
            return new ResponseEntity((Object)new ErrorBodyPayload("Invalid query", String.format("Query type:%s not supported!", type)).toString(), HttpStatus.BAD_REQUEST);
        }
        MediaType mediaType = MediaType.parseMediaType((String)contentType);
        if (MediaType.APPLICATION_JSON.isCompatibleWith(mediaType)) {
            aql = Optional.of(queryPayload).map(p -> {
                try {
                    return new ObjectMapper().readTree(p);
                }
                catch (JsonProcessingException e) {
                    throw new GeneralRequestProcessingException("Invalid content format", (Throwable)e);
                }
            }).map(n -> n.get("q")).filter(JsonNode::isTextual).map(JsonNode::asText).orElse(null);
        } else if (MediaType.TEXT_PLAIN.isCompatibleWith(mediaType)) {
            aql = queryPayload;
        } else {
            throw new UnsupportedMediaTypeException(mediaType.getType());
        }
        if (StringUtils.isBlank((CharSequence)aql)) {
            return new ResponseEntity((Object)new ErrorBodyPayload("Invalid query", "no aql query provided").toString(), HttpStatus.BAD_REQUEST);
        }
        QueryDefinitionResultDto storedQuery = this.queryService.createStoredQuery(qualifiedQueryName, (String)version.orElse(null), aql);
        return this.getPutDefenitionResponseEntity(mediaType, storedQuery);
    }

    @Override
    @DeleteMapping(value={"/{qualified_query_name}/{version}"})
    @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_QUERY_DELETE)
    public ResponseEntity<QueryDefinitionResponseData> deleteStoredQuery(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="qualified_query_name") String qualifiedQueryName, @PathVariable(value="version") String version) {
        this.logger.debug("deleteStoredQuery for the following input: {} , version: {}", (Object)qualifiedQueryName, (Object)version);
        QueryDefinitionResponseData queryDefinitionResponseData = new QueryDefinitionResponseData(this.queryService.deleteStoredQuery(qualifiedQueryName, version));
        return ResponseEntity.ok((Object)queryDefinitionResponseData);
    }

    private ResponseEntity<QueryDefinitionResponseData> getPutDefenitionResponseEntity(MediaType mediaType, QueryDefinitionResultDto storedQuery) {
        if (MediaType.APPLICATION_JSON.isCompatibleWith(mediaType)) {
            return ResponseEntity.ok((Object)new QueryDefinitionResponseData(storedQuery));
        }
        if (MediaType.TEXT_PLAIN.isCompatibleWith(mediaType)) {
            HttpHeaders respHeaders = new HttpHeaders();
            respHeaders.setContentType(MediaType.APPLICATION_JSON);
            respHeaders.setLocation(this.createLocationUri("definition", "query", storedQuery.getQualifiedName(), storedQuery.getVersion()));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(respHeaders)).build();
        }
        throw new UnexpectedSwitchCaseException(mediaType.getType());
    }
}

