/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr;

import com.nedap.archie.rm.changecontrol.OriginalVersion;
import com.nedap.archie.rm.ehr.EhrStatus;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import java.net.URI;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.annotations.TenantAware;
import org.ehrbase.api.authorization.EhrbaseAuthorization;
import org.ehrbase.api.authorization.EhrbasePermission;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.PreconditionFailedException;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.response.openehr.EhrStatusResponseData;
import org.ehrbase.rest.BaseController;
import org.ehrbase.rest.openehr.specification.EhrStatusApiSpecification;
import org.ehrbase.rest.util.InternalResponse;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@TenantAware
@RestController
@RequestMapping(path={"${openehr-api.context-path:/rest/openehr}/v1/ehr/{ehr_id}/ehr_status"})
public class OpenehrEhrStatusController
extends BaseController
implements EhrStatusApiSpecification {
    private final EhrService ehrService;

    public OpenehrEhrStatusController(EhrService ehrService) {
        this.ehrService = ehrService;
    }

    @Override
    @GetMapping
    @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_EHR_READ_STATUS)
    @PreAuthorize(value="checkAbacPre(@openehrEhrStatusController.EHR_STATUS, @ehrService.getSubjectExtRef(#ehrId))")
    public ResponseEntity<EhrStatusResponseData> getEhrStatusVersionByTime(@PathVariable(name="ehr_id") UUID ehrId, @RequestParam(name="version_at_time", required=false) String versionAtTime, @RequestHeader(name="Accept", required=false) String accept) {
        int version;
        this.assertEhrExists(ehrId);
        if (versionAtTime != null) {
            OffsetDateTime time = OffsetDateTime.parse(versionAtTime);
            Timestamp timestamp = Timestamp.valueOf(time.toLocalDateTime());
            version = this.ehrService.getEhrStatusVersionByTimestamp(ehrId, timestamp);
        } else {
            version = Integer.parseInt(this.ehrService.getLatestVersionUidOfStatus(ehrId).split("::")[2]);
        }
        UUID statusUid = this.ehrService.getEhrStatusVersionedObjectUidByEhr(ehrId);
        return this.internalGetEhrStatusProcessing(accept, ehrId, statusUid, version);
    }

    @Override
    @GetMapping(path={"/{version_uid}"})
    @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_EHR_READ_STATUS)
    @PreAuthorize(value="checkAbacPre(@openehrEhrStatusController.EHR_STATUS, @ehrService.getSubjectExtRef(#ehrId))")
    public ResponseEntity<EhrStatusResponseData> getEhrStatusByVersionId(@PathVariable(name="ehr_id") UUID ehrId, @PathVariable(name="version_uid") String versionUid, @RequestHeader(name="Accept", required=false) String accept) {
        this.assertEhrExists(ehrId);
        UUID versionedObjectUid = this.extractVersionedObjectUidFromVersionUid(versionUid);
        int version = this.extractVersionFromVersionUid(versionUid);
        Optional ehrStatus = this.ehrService.getEhrStatusAtVersion(ehrId, versionedObjectUid, version);
        UUID ehrStatusId = this.extractVersionedObjectUidFromVersionUid(((OriginalVersion)ehrStatus.orElseThrow(() -> new ObjectNotFoundException("ehr_status", "EHR_STATUS not found"))).getUid().toString());
        return this.internalGetEhrStatusProcessing(accept, ehrId, ehrStatusId, version);
    }

    @Override
    @PutMapping
    @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_EHR_UPDATE_STATUS)
    @PreAuthorize(value="checkAbacPre(@openehrEhrStatusController.EHR_STATUS, @ehrService.getSubjectExtRef(#ehrId))")
    public ResponseEntity<EhrStatusResponseData> updateEhrStatus(@PathVariable(value="ehr_id") UUID ehrId, @RequestHeader(name="If-Match") String versionUid, @RequestHeader(name="Prefer", required=false) String prefer, @RequestHeader(name="Accept", required=false) String accept, @RequestHeader(name="Content-Type", required=false) String contentType, @RequestBody EhrStatus ehrStatus) {
        this.assertEhrExists(ehrId);
        String latestVersionUid = this.ehrService.getLatestVersionUidOfStatus(ehrId);
        versionUid = StringUtils.unwrap((String)versionUid, (char)'\"');
        if (!latestVersionUid.equals(versionUid)) {
            throw new PreconditionFailedException("Given If-Match header does not match latest existing version");
        }
        UUID statusUid = this.ehrService.updateStatus(ehrId, ehrStatus, null, null);
        String newLatestVersionUid = this.ehrService.getLatestVersionUidOfStatus(ehrId);
        String[] split = latestVersionUid.split("::");
        if (latestVersionUid.equals(newLatestVersionUid) || split.length != 3) {
            throw new InvalidApiParameterException("Update of EHR_STATUS failed");
        }
        int version = Integer.parseInt(split[split.length - 1]) + 1;
        List<String> headerList = Arrays.asList("Content-Type", "Location", "ETag", "Last-Modified");
        Optional<InternalResponse<EhrStatusResponseData>> respData = this.buildEhrStatusResponseData(EhrStatusResponseData::new, ehrId, statusUid, version, accept, headerList);
        return respData.map(i -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(i.getHeaders())).body((Object)((EhrStatusResponseData)i.getResponseData()))).orElse(ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    private void assertEhrExists(UUID ehrId) {
        if (!this.ehrService.hasEhr(ehrId)) {
            throw new ObjectNotFoundException("EHR", "The EHR with the specified id does not exist");
        }
    }

    private ResponseEntity<EhrStatusResponseData> internalGetEhrStatusProcessing(String accept, UUID ehrId, UUID ehrStatusId, int version) {
        List<String> headerList = Arrays.asList("Content-Type", "Location", "ETag", "Last-Modified");
        Optional<InternalResponse<EhrStatusResponseData>> respData = this.buildEhrStatusResponseData(EhrStatusResponseData::new, ehrId, ehrStatusId, version, accept, headerList);
        return respData.map(i -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(i.getHeaders())).body((Object)((EhrStatusResponseData)i.getResponseData()))).orElse(ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    private <T extends EhrStatusResponseData> Optional<InternalResponse<T>> buildEhrStatusResponseData(Supplier<T> factory, UUID ehrId, UUID ehrStatusId, int version, String accept, List<String> headerList) {
        EhrStatusResponseData minimalOrRepresentation = (EhrStatusResponseData)factory.get();
        MediaType contentType = this.resolveContentType(accept);
        Optional ehrStatus = this.ehrService.getEhrStatusAtVersion(ehrId, ehrStatusId, version);
        if (minimalOrRepresentation != null) {
            EhrStatusResponseData objByReference = minimalOrRepresentation;
            if (ehrStatus.isPresent()) {
                objByReference.setArchetypeNodeId(((EhrStatus)((OriginalVersion)ehrStatus.get()).getData()).getArchetypeNodeId());
                objByReference.setName(((EhrStatus)((OriginalVersion)ehrStatus.get()).getData()).getName());
                objByReference.setUid((UIDBasedId)((OriginalVersion)ehrStatus.get()).getUid());
                objByReference.setSubject(((EhrStatus)((OriginalVersion)ehrStatus.get()).getData()).getSubject());
                objByReference.setOtherDetails(((EhrStatus)((OriginalVersion)ehrStatus.get()).getData()).getOtherDetails());
                objByReference.setModifiable(Boolean.valueOf(((EhrStatus)((OriginalVersion)ehrStatus.get()).getData()).isModifiable()));
                objByReference.setQueryable(Boolean.valueOf(((EhrStatus)((OriginalVersion)ehrStatus.get()).getData()).isQueryable()));
            } else {
                return Optional.empty();
            }
        }
        HttpHeaders respHeaders = new HttpHeaders();
        Iterator<String> iterator = headerList.iterator();
        while (iterator.hasNext()) {
            String header;
            switch (header = iterator.next()) {
                case "Content-Type": {
                    respHeaders.setContentType(contentType);
                    break;
                }
                case "Location": {
                    try {
                        URI url = this.createLocationUri("ehr", ehrId.toString(), "ehr_status", String.format("%s::%s::%s", ehrStatusId, this.ehrService.getServerConfig().getNodename(), version));
                        respHeaders.setLocation(url);
                        break;
                    }
                    catch (Exception e) {
                        throw new InternalServerException(e.getMessage());
                    }
                }
                case "ETag": {
                    respHeaders.setETag("\"" + ehrStatusId + "::" + this.ehrService.getServerConfig().getNodename() + "::" + version + "\"");
                    break;
                }
                case "Last-Modified": {
                    ehrStatus.ifPresent(ehrStatusOriginalVersion -> respHeaders.setLastModified(ehrStatusOriginalVersion.getCommitAudit().getTimeCommitted().getMagnitude().longValue()));
                    break;
                }
            }
        }
        return Optional.of(new InternalResponse<EhrStatusResponseData>(minimalOrRepresentation, respHeaders));
    }
}

