/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.admin;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.UUID;
import org.ehrbase.api.annotations.TenantAware;
import org.ehrbase.api.authorization.EhrbaseAuthorization;
import org.ehrbase.api.authorization.EhrbaseAuthorizations;
import org.ehrbase.api.authorization.EhrbasePermission;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.service.ContributionService;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.response.openehr.admin.AdminDeleteResponseData;
import org.ehrbase.response.openehr.admin.AdminUpdateResponseData;
import org.ehrbase.rest.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@TenantAware
@Tag(name="Admin - Contribution")
@ConditionalOnProperty(prefix="admin-api", name={"active"})
@RestController
@RequestMapping(path={"${admin-api.context-path:/rest/admin}/ehr"}, produces={"application/json", "application/xml"})
public class AdminContributionController
extends BaseController {
    private final EhrService ehrService;
    private final ContributionService contributionService;

    @Autowired
    public AdminContributionController(EhrService ehrService, ContributionService contributionService) {
        this.ehrService = ehrService;
        this.contributionService = contributionService;
    }

    @EhrbaseAuthorizations(value={@EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_ADMIN_ACCESS), @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_CONTRIBUTION_UPDATE)})
    @PutMapping(path={"/{ehr_id}/contribution/{contribution_id}"}, consumes={"application/json", "application/xml"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Contribution has been updated successfully.", headers={@Header(name="Content-Type", description="Format of response", schema=@Schema(implementation=MediaType.class))}), @ApiResponse(responseCode="401", description="Client credentials invalid or have expired."), @ApiResponse(responseCode="403", description="Client does not have permission to access since admin role is missing."), @ApiResponse(responseCode="404", description="EHR or Contribution could not be found.")})
    public ResponseEntity<AdminUpdateResponseData> updateContribution(@Parameter(description="Target EHR id to update contribution inside.", required=true) @PathVariable(value="ehr_id") String ehrId, @Parameter(description="Target Contribution id to update", required=true) @PathVariable(value="contribution_id") String contributionId) {
        UUID ehrUuid = UUID.fromString(ehrId);
        if (!this.ehrService.hasEhr(ehrUuid)) {
            throw new ObjectNotFoundException("Admin Contribution", String.format("EHR with id %s does not exist", ehrId));
        }
        return ResponseEntity.ok().body((Object)new AdminUpdateResponseData(0));
    }

    @EhrbaseAuthorizations(value={@EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_ADMIN_ACCESS), @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_CONTRIBUTION_DELETE)})
    @DeleteMapping(path={"/{ehr_id}/contribution/{contribution_id}"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Contribution has been deleted successfully.", headers={@Header(name="Content-Type", description="Format of response", schema=@Schema(implementation=MediaType.class))}), @ApiResponse(responseCode="401", description="Client credentials invalid or have expired."), @ApiResponse(responseCode="403", description="Client does not have permission to access since admin role is missing."), @ApiResponse(responseCode="404", description="EHR or Contribution could not be found.")})
    public ResponseEntity<AdminDeleteResponseData> deleteContribution(@Parameter(description="Target EHR id to update contribution inside.", required=true) @PathVariable(value="ehr_id") String ehrId, @Parameter(description="Target Contribution id to update", required=true) @PathVariable(value="contribution_id") String contributionId) {
        UUID ehrUuid = UUID.fromString(ehrId);
        if (!this.ehrService.hasEhr(ehrUuid)) {
            throw new ObjectNotFoundException("Admin Contribution", String.format("EHR with id %s does not exist", ehrId));
        }
        UUID contributionUUID = UUID.fromString(contributionId);
        this.contributionService.adminDelete(contributionUUID);
        return ResponseEntity.noContent().build();
    }
}

