/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr;

import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.net.URI;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.annotations.TenantAware;
import org.ehrbase.api.authorization.EhrbaseAuthorization;
import org.ehrbase.api.authorization.EhrbasePermission;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.PreconditionFailedException;
import org.ehrbase.api.exception.StateConflictException;
import org.ehrbase.api.service.CompositionService;
import org.ehrbase.response.ehrscape.CompositionDto;
import org.ehrbase.response.ehrscape.CompositionFormat;
import org.ehrbase.response.ehrscape.StructuredString;
import org.ehrbase.response.openehr.CompositionResponseData;
import org.ehrbase.rest.BaseController;
import org.ehrbase.rest.openehr.audit.CompositionAuditInterceptor;
import org.ehrbase.rest.openehr.audit.OpenEhrAuditInterceptor;
import org.ehrbase.rest.openehr.specification.CompositionApiSpecification;
import org.ehrbase.rest.util.InternalResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@TenantAware
@RestController
@RequestMapping(path={"${openehr-api.context-path:/rest/openehr}/v1/ehr"}, produces={"application/json", "application/xml"})
public class OpenehrCompositionController
extends BaseController
implements CompositionApiSpecification {
    final CompositionService compositionService;

    @Autowired
    public OpenehrCompositionController(CompositionService compositionService) {
        this.compositionService = Objects.requireNonNull(compositionService);
    }

    @Override
    @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_COMPOSITION_CREATE)
    @PostMapping(value={"/{ehr_id}/composition"}, consumes={"application/xml", "application/json"})
    @PreAuthorize(value="checkAbacPre(@openehrCompositionController.COMPOSITION, @ehrService.getSubjectExtRef(#ehrIdString), #composition, #contentType)")
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity createComposition(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @RequestHeader(value="Content-Type") String contentType, @RequestHeader(value="Accept", required=false) String accept, @RequestHeader(value="Prefer", required=false) String prefer, @PathVariable(value="ehr_id") String ehrIdString, @RequestBody String composition, HttpServletRequest request) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        CompositionFormat compositionFormat = this.extractCompositionFormat(contentType);
        Composition compoObj = this.compositionService.buildComposition(composition, compositionFormat, null);
        UUID compositionUuid = (UUID)this.compositionService.create(ehrId, (Locatable)compoObj).orElseThrow(() -> new InternalServerException("Failed to create composition"));
        URI uri = this.createLocationUri("ehr", ehrId.toString(), "composition", compositionUuid.toString());
        List<String> headerList = Arrays.asList("Location", "ETag", "Last-Modified");
        Supplier<CompositionResponseData> responseDataSupplier = Optional.ofNullable(prefer).map(i -> i.equals("return=representation")).orElse(false) != false ? () -> new CompositionResponseData(null, null) : () -> null;
        Optional<InternalResponse<CompositionResponseData>> respData = this.buildCompositionResponseData(ehrId, compositionUuid, 1, accept, uri, headerList, responseDataSupplier);
        request.setAttribute(OpenEhrAuditInterceptor.EHR_ID_ATTRIBUTE, Collections.singleton(ehrId));
        request.setAttribute(CompositionAuditInterceptor.COMPOSITION_ID_ATTRIBUTE, (Object)compositionUuid);
        return respData.map(i -> Optional.ofNullable((CompositionResponseData)i.getResponseData()).map(StructuredString::getValue).map(j -> ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)uri).headers(i.getHeaders())).body(j)).orElse(ResponseEntity.noContent().headers(i.getHeaders()).build())).orElse(ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    @Override
    @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_COMPOSITION_UPDATE)
    @PutMapping(value={"/{ehr_id}/composition/{versioned_object_uid}"})
    @PreAuthorize(value="checkAbacPre(@openehrCompositionController.COMPOSITION, @ehrService.getSubjectExtRef(#ehrIdString), #composition, #contentType)")
    public ResponseEntity updateComposition(String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @RequestHeader(value="Content-Type", required=false) String contentType, @RequestHeader(value="Accept", required=false) String accept, @RequestHeader(value="Prefer", required=false) String prefer, @RequestHeader(value="If-Match") String ifMatch, @PathVariable(value="ehr_id") String ehrIdString, @PathVariable(value="versioned_object_uid") String versionedObjectUidString, @RequestBody String composition, HttpServletRequest request) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        UUID versionedObjectUid = this.getCompositionVersionedObjectUidString(versionedObjectUidString);
        CompositionFormat compositionFormat = this.extractCompositionFormat(contentType);
        this.compositionService.exists(versionedObjectUid);
        ifMatch = StringUtils.unwrap((String)ifMatch, (char)'\"');
        if (!(versionedObjectUid + "::" + this.compositionService.getServerConfig().getNodename() + "::" + this.compositionService.getLastVersionNumber(this.extractVersionedObjectUidFromVersionUid(versionedObjectUid.toString()))).equals(ifMatch)) {
            throw new PreconditionFailedException("If-Match header does not match latest existing version");
        }
        Composition compoObj = this.compositionService.buildComposition(composition, compositionFormat, null);
        Optional<String> inputUuid = this.getUidFrom(compoObj);
        inputUuid.ifPresent(id -> {
            if (!versionedObjectUid.equals(this.extractVersionedObjectUidFromVersionUid((String)id))) {
                throw new PreconditionFailedException("UUID from input must match given versioned_object_uid in request URL");
            }
        });
        Optional<Object> respData = Optional.empty();
        try {
            String compositionVersionUid = ((UUID)this.compositionService.update(ehrId, new ObjectVersionId(ifMatch), (Locatable)compoObj).orElseThrow(() -> new InternalServerException("Failed to create composition"))).toString();
            URI uri = this.createLocationUri("ehr", ehrId.toString(), "composition", compositionVersionUid);
            List<String> headerList = Arrays.asList("Location", "ETag", "Last-Modified");
            UUID compositionId = this.extractVersionedObjectUidFromVersionUid(compositionVersionUid);
            respData = "return=representation".equals(prefer) ? this.buildCompositionResponseData(ehrId, compositionId, this.extractVersionFromVersionUid(compositionVersionUid), accept, uri, headerList, () -> new CompositionResponseData(null, null)) : this.buildCompositionResponseData(ehrId, compositionId, this.extractVersionFromVersionUid(compositionVersionUid), accept, uri, headerList, () -> null);
            request.setAttribute(OpenEhrAuditInterceptor.EHR_ID_ATTRIBUTE, Collections.singleton(ehrId));
            request.setAttribute(CompositionAuditInterceptor.COMPOSITION_ID_ATTRIBUTE, (Object)compositionId);
        }
        catch (ObjectNotFoundException e) {
            return ResponseEntity.notFound().build();
        }
        return respData.map(i -> Optional.ofNullable((CompositionResponseData)i.getResponseData()).map(StructuredString::getValue).map(j -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(i.getHeaders())).body(j)).orElse(ResponseEntity.noContent().headers(i.getHeaders()).build())).orElse(ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    @Override
    @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_COMPOSITION_DELETE)
    @DeleteMapping(value={"/{ehr_id}/composition/{preceding_version_uid}"})
    @PreAuthorize(value="checkAbacPre(@openehrCompositionController.COMPOSITION, @ehrService.getSubjectExtRef(#ehrIdString), #precedingVersionUid, null)")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity deleteComposition(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @PathVariable(value="ehr_id") String ehrIdString, @PathVariable(value="preceding_version_uid") String precedingVersionUid, HttpServletRequest request) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        HttpHeaders headers = new HttpHeaders();
        this.compositionService.retrieve(ehrId, this.extractVersionedObjectUidFromVersionUid(precedingVersionUid), Integer.valueOf(1)).orElseThrow(() -> new ObjectNotFoundException("composition", "No EHR with the supplied ehr_id or no COMPOSITION with the supplied preceding_version_uid."));
        String latestVersionId = this.extractVersionedObjectUidFromVersionUid(precedingVersionUid) + "::" + this.compositionService.getServerConfig().getNodename() + "::" + this.compositionService.getLastVersionNumber(this.extractVersionedObjectUidFromVersionUid(precedingVersionUid));
        URI uri = this.createLocationUri("ehr", ehrId.toString(), "composition", latestVersionId);
        if (!this.compositionService.getLastVersionNumber(this.extractVersionedObjectUidFromVersionUid(precedingVersionUid)).equals(this.extractVersionFromVersionUid(precedingVersionUid))) {
            headers.setLocation(uri);
            headers.setETag("\"" + latestVersionId + "\"");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).headers(headers)).build();
        }
        try {
            this.compositionService.delete(ehrId, new ObjectVersionId(precedingVersionUid));
            headers.setLocation(uri);
            headers.setETag("\"" + latestVersionId + "\"");
            headers.setLastModified(ZonedDateTime.of(LocalDateTime.now(), ZoneId.systemDefault()).toInstant().toEpochMilli());
            request.setAttribute(OpenEhrAuditInterceptor.EHR_ID_ATTRIBUTE, Collections.singleton(ehrId));
            request.setAttribute(CompositionAuditInterceptor.COMPOSITION_ID_ATTRIBUTE, (Object)this.extractVersionedObjectUidFromVersionUid(precedingVersionUid));
            return ResponseEntity.noContent().headers(headers).build();
        }
        catch (ObjectNotFoundException e) {
            throw new ObjectNotFoundException("composition", "No EHR with the supplied ehr_id or no COMPOSITION with the supplied preceding_version_uid.");
        }
        catch (StateConflictException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerException("Deleting of composition failed", (Throwable)e);
        }
    }

    @Override
    @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_COMPOSITION_READ)
    @GetMapping(value={"/{ehr_id}/composition/{versioned_object_uid}"})
    @PostAuthorize(value="checkAbacPost(@openehrCompositionController.COMPOSITION, @ehrService.getSubjectExtRef(#ehrIdString), returnObject, #accept)")
    public ResponseEntity getComposition(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="ehr_id") String ehrIdString, @PathVariable(value="versioned_object_uid") String versionedObjectUid, @RequestParam(value="version_at_time", required=false) String versionAtTime, HttpServletRequest request) {
        Optional<OffsetDateTime> temporal;
        UUID ehrId = this.getEhrUuid(ehrIdString);
        UUID compositionUid = this.extractVersionedObjectUidFromVersionUid(versionedObjectUid);
        if (this.compositionService.isDeleted(compositionUid)) {
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        int version = this.extractVersionFromVersionUid(versionedObjectUid);
        if (version == 0 && (temporal = OpenehrCompositionController.decodeVersionAtTime(versionAtTime)).isPresent()) {
            version = temporal.map(OffsetDateTime::toLocalDateTime).map(t -> this.compositionService.getVersionByTimestamp(compositionUid, t)).orElseThrow(() -> new ObjectNotFoundException("composition", "No composition version matching the timestamp condition"));
        }
        URI uri = this.createLocationUri("ehr", ehrId.toString(), "composition", versionedObjectUid);
        List<String> headerList = Arrays.asList("Location", "ETag", "Last-Modified");
        Optional<InternalResponse<CompositionResponseData>> respData = this.buildCompositionResponseData(ehrId, compositionUid, version, accept, uri, headerList, () -> new CompositionResponseData(null, null));
        request.setAttribute(OpenEhrAuditInterceptor.EHR_ID_ATTRIBUTE, Collections.singleton(ehrId));
        request.setAttribute(CompositionAuditInterceptor.COMPOSITION_ID_ATTRIBUTE, (Object)compositionUid);
        request.setAttribute(CompositionAuditInterceptor.VERSION_ATTRIBUTE, (Object)version);
        return respData.map(i -> Optional.ofNullable(((CompositionResponseData)i.getResponseData()).getValue()).map(j -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(i.getHeaders())).body(j)).orElse(ResponseEntity.noContent().headers(i.getHeaders()).build())).orElse(ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    private <T extends CompositionResponseData> Optional<InternalResponse<T>> buildCompositionResponseData(UUID ehrId, UUID compositionId, int version, String accept, URI uri, List<String> headerList, Supplier<T> factory) {
        CompositionResponseData minimalOrRepresentation = (CompositionResponseData)factory.get();
        int versionNumber = version <= 0 ? this.compositionService.getLastVersionNumber(compositionId) : version;
        HttpHeaders respHeaders = new HttpHeaders();
        Iterator<String> iterator = headerList.iterator();
        while (iterator.hasNext()) {
            String header;
            switch (header = iterator.next()) {
                case "Location": {
                    respHeaders.setLocation(uri);
                    break;
                }
                case "ETag": {
                    respHeaders.setETag("\"" + compositionId + "::" + this.compositionService.getServerConfig().getNodename() + "::" + versionNumber + "\"");
                    break;
                }
                case "Last-Modified": {
                    respHeaders.setLastModified(123124442L);
                    break;
                }
            }
        }
        if (minimalOrRepresentation != null) {
            CompositionResponseData objByReference = minimalOrRepresentation;
            CompositionFormat format = this.extractCompositionFormat(accept);
            Optional<CompositionDto> compositionDto = this.compositionService.retrieve(ehrId, compositionId, Integer.valueOf(versionNumber)).map(c -> CompositionService.from((UUID)ehrId, (Composition)c));
            if (!compositionDto.isPresent()) {
                throw new ObjectNotFoundException("composition", "Couldn't retrieve composition");
            }
            StructuredString ss = this.compositionService.serialize(compositionDto.get(), format);
            objByReference.setValue(ss.getValue());
            objByReference.setFormat(ss.getFormat());
            if (format.equals((Object)CompositionFormat.XML)) {
                respHeaders.setContentType(MediaType.APPLICATION_XML);
            } else if (format.equals((Object)CompositionFormat.FLAT) || format.equals((Object)CompositionFormat.ECISFLAT) || format.equals((Object)CompositionFormat.RAW)) {
                respHeaders.setContentType(MediaType.APPLICATION_JSON);
            }
        }
        return Optional.of(new InternalResponse<CompositionResponseData>(minimalOrRepresentation, respHeaders));
    }

    private Optional<String> getUidFrom(Composition composition) {
        return Optional.ofNullable(composition.getUid()).map(uid -> uid.toString());
    }
}

