/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr.audit;

import java.time.Instant;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.api.service.TenantService;
import org.ehrbase.rest.openehr.audit.OpenEhrAuditDataset;
import org.ehrbase.rest.util.AuthHelper;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.audit.model.AuditMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerInterceptor;

public abstract class OpenEhrAuditInterceptor<T extends OpenEhrAuditDataset>
implements HandlerInterceptor {
    public static final String EHR_ID_ATTRIBUTE = OpenEhrAuditInterceptor.class.getName() + ".EHR_ID";
    public static final String START_TIME_ATTRIBUTE = OpenEhrAuditInterceptor.class.getName() + ".START_TIME";
    protected final AuditContext auditContext;
    protected final EhrService ehrService;
    protected final TenantService tenantService;

    protected OpenEhrAuditInterceptor(AuditContext auditContext, EhrService ehrService, TenantService tenantService) {
        this.auditContext = auditContext;
        this.ehrService = ehrService;
        this.tenantService = tenantService;
    }

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        request.setAttribute(START_TIME_ATTRIBUTE, (Object)Instant.now());
        return true;
    }

    public void afterCompletion(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, Exception ex) {
        T auditDataset = this.createAuditDataset();
        this.enrichDataset(auditDataset, request, response);
        AuditMessage[] messages = this.getAuditMessages(auditDataset);
        this.auditContext.audit(messages);
    }

    protected abstract T createAuditDataset();

    protected void enrichDataset(T auditDataset, HttpServletRequest request, HttpServletResponse response) {
        ((OpenEhrAuditDataset)auditDataset).setMethod(HttpMethod.valueOf((String)request.getMethod()));
        String username = AuthHelper.getCurrentAuthenticatedUsername(request);
        ((OpenEhrAuditDataset)auditDataset).setSourceParticipantUserId(username);
        ((OpenEhrAuditDataset)auditDataset).setSourceParticipantNetworkId(this.getClientIpAddress(request));
        HttpStatus status = HttpStatus.valueOf((int)response.getStatus());
        if (!status.isError()) {
            ((OpenEhrAuditDataset)auditDataset).setEventOutcomeIndicator(EventOutcomeIndicator.Success);
            ((OpenEhrAuditDataset)auditDataset).setEventOutcomeDescription("Operation performed successfully");
        } else {
            if (status.is4xxClientError()) {
                ((OpenEhrAuditDataset)auditDataset).setEventOutcomeIndicator(EventOutcomeIndicator.SeriousFailure);
            } else {
                ((OpenEhrAuditDataset)auditDataset).setEventOutcomeIndicator(EventOutcomeIndicator.MajorFailure);
            }
            Object eventOutcomeDescription = "Operation failed";
            Throwable ex = (Throwable)request.getAttribute(DispatcherServlet.EXCEPTION_ATTRIBUTE);
            if (ex != null) {
                eventOutcomeDescription = (String)eventOutcomeDescription + "; " + ex.getMessage();
            }
            ((OpenEhrAuditDataset)auditDataset).setEventOutcomeDescription((String)eventOutcomeDescription);
        }
        ((OpenEhrAuditDataset)auditDataset).addPatientParticipantObjectIds(this.getPatientNumbers(request));
        ((OpenEhrAuditDataset)auditDataset).setAuditEnterpriseSiteId(this.tenantService.getCurrentTenantIdentifier());
    }

    protected abstract AuditMessage[] getAuditMessages(T var1);

    protected String getClientIpAddress(HttpServletRequest request) {
        String address = request.getHeader("X-Forwarded-For");
        if (StringUtils.isEmpty((CharSequence)address)) {
            address = request.getRemoteAddr();
        }
        return address;
    }

    protected UUID getUniqueEhrId(HttpServletRequest request) {
        Set<UUID> ehrIds = this.getEhrIds(request);
        if (ehrIds.isEmpty()) {
            return null;
        }
        if (ehrIds.size() == 1) {
            return ehrIds.iterator().next();
        }
        throw new InternalServerException("Non unique EhrId result");
    }

    protected Set<UUID> getEhrIds(HttpServletRequest request) {
        Set ehrIds = (Set)request.getAttribute(EHR_ID_ATTRIBUTE);
        if (ehrIds == null) {
            return Collections.emptySet();
        }
        return ehrIds;
    }

    protected Set<String> getPatientNumbers(HttpServletRequest request) {
        return this.getEhrIds(request).stream().map(ehrId -> this.ehrService.getSubjectExtRef(ehrId.toString())).collect(Collectors.toSet());
    }
}

