/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr.audit.support;

import org.ehrbase.rest.openehr.audit.CompositionAuditDataset;
import org.ehrbase.rest.openehr.audit.OpenEhrEventIdCode;
import org.ehrbase.rest.openehr.audit.OpenEhrEventTypeCode;
import org.ehrbase.rest.openehr.audit.support.OpenEhrAuditMessageBuilder;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectDataLifeCycle;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectIdTypeCode;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectTypeCode;
import org.openehealth.ipf.commons.audit.event.CustomAuditMessageBuilder;
import org.openehealth.ipf.commons.audit.types.EventType;
import org.openehealth.ipf.commons.audit.types.ParticipantObjectIdType;
import org.springframework.http.HttpMethod;

public class CompositionAuditMessageBuilder
extends OpenEhrAuditMessageBuilder<CompositionAuditMessageBuilder> {
    public CompositionAuditMessageBuilder(AuditContext auditContext, CompositionAuditDataset auditDataset) {
        super(auditContext, auditDataset, CompositionAuditMessageBuilder.resolveEventActionCode(auditDataset.getMethod()), OpenEhrEventIdCode.COMPOSITION, CompositionAuditMessageBuilder.resolveEventType(auditDataset.getMethod()));
    }

    private static EventActionCode resolveEventActionCode(HttpMethod method) {
        switch (method) {
            case POST: {
                return EventActionCode.Create;
            }
            case GET: {
                return EventActionCode.Read;
            }
            case PUT: {
                return EventActionCode.Update;
            }
            case DELETE: {
                return EventActionCode.Delete;
            }
        }
        throw new IllegalArgumentException("Cannot resolve EventActionCode, method not supported");
    }

    private static EventType resolveEventType(HttpMethod method) {
        switch (method) {
            case POST: {
                return OpenEhrEventTypeCode.CREATE;
            }
            case GET: {
                return null;
            }
            case PUT: {
                return OpenEhrEventTypeCode.UPDATE;
            }
            case DELETE: {
                return OpenEhrEventTypeCode.DELETE;
            }
        }
        throw new IllegalArgumentException("Cannot resolve EventType, method not supported");
    }

    public CompositionAuditMessageBuilder addCompositionParticipantObjectIdentification(CompositionAuditDataset auditDataset) {
        ((CustomAuditMessageBuilder)this.delegate).addParticipantObjectIdentification((ParticipantObjectIdType)ParticipantObjectIdTypeCode.URI, auditDataset.getTemplateId(), null, null, auditDataset.getCompositionUri(), ParticipantObjectTypeCode.System, null, this.resolveLifeCycle(auditDataset.getMethod()), null);
        return this;
    }

    public CompositionAuditMessageBuilder addPatientParticipantObjectIdentification(CompositionAuditDataset auditDataset) {
        ((CustomAuditMessageBuilder)this.delegate).addPatientParticipantObject(auditDataset.getUniquePatientParticipantObjectId(), null, null, null);
        return this;
    }

    private ParticipantObjectDataLifeCycle resolveLifeCycle(HttpMethod method) {
        switch (method) {
            case POST: {
                return ParticipantObjectDataLifeCycle.Origination;
            }
            case PUT: {
                return ParticipantObjectDataLifeCycle.Amendment;
            }
            case GET: {
                return ParticipantObjectDataLifeCycle.Disclosure;
            }
            case DELETE: {
                return null;
            }
        }
        throw new IllegalArgumentException("Cannot resolve ParticipantObjectDataLifeCycle, method not supported");
    }
}

