/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr.audit.support;

import org.ehrbase.rest.openehr.audit.OpenEhrAuditDataset;
import org.ehrbase.rest.openehr.audit.support.OpenEhrAuditMessageBuilder;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.codes.EventIdCode;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectDataLifeCycle;
import org.openehealth.ipf.commons.audit.event.CustomAuditMessageBuilder;
import org.openehealth.ipf.commons.audit.types.EventId;
import org.springframework.http.HttpMethod;

public class EhrAuditMessageBuilder
extends OpenEhrAuditMessageBuilder<EhrAuditMessageBuilder> {
    public EhrAuditMessageBuilder(AuditContext auditContext, OpenEhrAuditDataset auditDataset) {
        super(auditContext, auditDataset, EhrAuditMessageBuilder.resolveEventActionCode(auditDataset.getMethod()), (EventId)EventIdCode.PatientRecord, null);
    }

    protected static EventActionCode resolveEventActionCode(HttpMethod method) {
        switch (method) {
            case POST: 
            case PUT: {
                return EventActionCode.Create;
            }
            case GET: {
                return EventActionCode.Read;
            }
        }
        throw new IllegalArgumentException("Cannot resolve EventActionCode, method not supported");
    }

    public EhrAuditMessageBuilder addPatientParticipantObjectIdentification(OpenEhrAuditDataset auditDataset) {
        ((CustomAuditMessageBuilder)this.delegate).addPatientParticipantObject(auditDataset.getUniquePatientParticipantObjectId(), null, null, this.resolveLifeCycle(auditDataset.getMethod()));
        return this;
    }

    private ParticipantObjectDataLifeCycle resolveLifeCycle(HttpMethod method) {
        switch (method) {
            case POST: 
            case PUT: {
                return ParticipantObjectDataLifeCycle.Origination;
            }
            case GET: {
                return ParticipantObjectDataLifeCycle.Disclosure;
            }
        }
        throw new IllegalArgumentException("Cannot resolve ParticipantObjectDataLifeCycle, method not supported");
    }
}

