/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.util;

import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.Payload;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.jwt.Jwt;

public class AuthHelper {
    private static final String AUTHENTICATION_SCHEME_BASIC = "Basic";

    private AuthHelper() {
    }

    public static String getCurrentAuthenticatedUsername(HttpServletRequest request) {
        Principal principal = request.getUserPrincipal();
        return AuthHelper.getJwtSubject(principal).orElseGet(() -> Optional.of(request).map(AuthHelper::getBasicAuthUsername).filter(StringUtils::isNotBlank).orElseGet(() -> Optional.ofNullable(principal).map(Principal::getName).orElse(null)));
    }

    private static Optional<String> getJwtSubject(Principal principal) {
        return Optional.ofNullable(principal).filter(AbstractAuthenticationToken.class::isInstance).map(AbstractAuthenticationToken.class::cast).map(Authentication::getPrincipal).filter(DecodedJWT.class::isInstance).map(DecodedJWT.class::cast).map(Payload::getSubject).filter(StringUtils::isNotBlank);
    }

    public static String getRequestedJwtClaim(AbstractAuthenticationToken token, String requestedClaim) {
        String claim = "";
        Object principal = token.getCredentials();
        if (principal instanceof Jwt) {
            Jwt jwt = (Jwt)principal;
            Map claims = jwt.getClaims();
            if (claims != null && claims.containsKey(requestedClaim)) {
                claim = claims.get(requestedClaim).toString();
            }
        } else if (principal instanceof DecodedJWT) {
            DecodedJWT jwt = (DecodedJWT)principal;
            Map claims = jwt.getClaims();
            if (claims != null && claims.containsKey(requestedClaim)) {
                claim = ((Claim)claims.get(requestedClaim)).asString();
            }
        } else {
            throw new IllegalArgumentException("Invalid authentication, no claims available.");
        }
        return claim;
    }

    private static String getBasicAuthUsername(HttpServletRequest request) {
        String authorization = request.getHeader("Authorization");
        if (authorization == null || !StringUtils.startsWithIgnoreCase((CharSequence)authorization, (CharSequence)"basic ")) {
            return null;
        }
        if (!StringUtils.startsWithIgnoreCase((CharSequence)(authorization = authorization.trim()), (CharSequence)AUTHENTICATION_SCHEME_BASIC)) {
            return null;
        }
        if (authorization.equalsIgnoreCase(AUTHENTICATION_SCHEME_BASIC)) {
            return null;
        }
        byte[] base64Token = authorization.substring(6).getBytes(StandardCharsets.UTF_8);
        String credentials = new String(AuthHelper.base64Decode(base64Token), StandardCharsets.UTF_8);
        int colonIndex = credentials.indexOf(":");
        if (colonIndex == -1) {
            return null;
        }
        return credentials.substring(0, colonIndex);
    }

    private static byte[] base64Decode(byte[] value) {
        try {
            return Base64.getDecoder().decode(value);
        }
        catch (Exception ex) {
            return new byte[0];
        }
    }
}

