/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr;

import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.ehrbase.api.annotations.TenantAware;
import org.ehrbase.api.audit.msg.AuditMsgBuilder;
import org.ehrbase.api.authorization.EhrbaseAuthorization;
import org.ehrbase.api.authorization.EhrbasePermission;
import org.ehrbase.api.exception.NotAcceptableException;
import org.ehrbase.api.service.ContributionService;
import org.ehrbase.openehr.sdk.response.dto.ContributionResponseData;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.CompositionFormat;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.ContributionDto;
import org.ehrbase.rest.BaseController;
import org.ehrbase.rest.openehr.specification.ContributionApiSpecification;
import org.ehrbase.rest.util.InternalResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@TenantAware
@RestController
@RequestMapping(path={"${openehr-api.context-path:/rest/openehr}/v1/ehr"}, produces={"application/json", "application/xml"})
public class OpenehrContributionController
extends BaseController
implements ContributionApiSpecification {
    private final ContributionService contributionService;

    @Autowired
    public OpenehrContributionController(ContributionService contributionService) {
        this.contributionService = Objects.requireNonNull(contributionService);
    }

    @Override
    @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_CONTRIBUTION_CREATE)
    @PostMapping(value={"/{ehr_id}/contribution"}, consumes={"application/xml", "application/json"})
    @PreAuthorize(value="checkAbacPre(@openehrContributionController.CONTRIBUTION, @ehrService.getSubjectExtRef(#ehrIdString), #contribution, #contentType)")
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity createContribution(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @RequestHeader(value="Content-Type") String contentType, @RequestHeader(value="Accept", required=false) String accept, @RequestHeader(value="Prefer", required=false) String prefer, @PathVariable(value="ehr_id") String ehrIdString, @RequestBody String contribution) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        UUID contributionId = this.contributionService.commitContribution(ehrId, contribution, this.extractCompositionFormat(contentType));
        URI uri = this.createLocationUri("ehr", ehrId.toString(), "contribution", contributionId.toString());
        List<String> headerList = Arrays.asList("Location", "ETag");
        Optional<InternalResponse<ContributionResponseData>> respData = Optional.ofNullable(prefer).map(i -> i.equals("return=representation")).orElse(false) != false ? this.buildContributionResponseData(contributionId, ehrId, accept, uri, headerList, () -> new ContributionResponseData(null, null, null)) : this.buildContributionResponseData(contributionId, ehrId, accept, uri, headerList, () -> null);
        this.createAuditLogsMsgBuilder(ehrId, contributionId);
        return respData.map(i -> Optional.ofNullable((ContributionResponseData)i.getResponseData()).map(j -> ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)uri).headers(i.getHeaders())).body(j)).orElse(ResponseEntity.noContent().headers(i.getHeaders()).build())).orElse(ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    @Override
    @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_CONTRIBUTION_READ)
    @GetMapping(value={"/{ehr_id}/contribution/{contribution_uid}"})
    public ResponseEntity getContribution(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="ehr_id") String ehrIdString, @PathVariable(value="contribution_uid") String contributionUidString) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        UUID contributionUid = this.getContributionVersionedObjectUidString(contributionUidString);
        URI uri = this.createLocationUri("ehr", ehrId.toString(), "contribution", contributionUid.toString());
        List<String> headerList = Arrays.asList("Location", "ETag", "Last-Modified");
        Optional<InternalResponse<ContributionResponseData>> respData = this.buildContributionResponseData(contributionUid, ehrId, accept, uri, headerList, () -> new ContributionResponseData(null, null, null));
        this.createAuditLogsMsgBuilder(ehrId, contributionUid);
        return respData.map(i -> Optional.ofNullable((ContributionResponseData)i.getResponseData()).map(j -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(i.getHeaders())).body(j)).orElse(ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build())).orElse(ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    private <T extends ContributionResponseData> Optional<InternalResponse<T>> buildContributionResponseData(UUID contributionId, UUID ehrId, String accept, URI uri, List<String> headerList, Supplier<T> factory) {
        ContributionResponseData minimalOrRepresentation = (ContributionResponseData)factory.get();
        HttpHeaders respHeaders = new HttpHeaders();
        Iterator<String> iterator = headerList.iterator();
        while (iterator.hasNext()) {
            String header;
            switch (header = iterator.next()) {
                case "Location": {
                    respHeaders.setLocation(uri);
                    break;
                }
                case "ETag": {
                    respHeaders.setETag("\"" + contributionId + "\"");
                    break;
                }
                case "Last-Modified": {
                    respHeaders.setLastModified(123124442L);
                    break;
                }
            }
        }
        if (minimalOrRepresentation != null) {
            ContributionResponseData objByReference = minimalOrRepresentation;
            Optional contribution = this.contributionService.getContribution(ehrId, contributionId);
            objByReference.setUid(new HierObjectId(contributionId.toString()));
            LinkedList refs = new LinkedList();
            ((ContributionDto)contribution.get()).getObjectReferences().forEach((id, type) -> refs.add(new ObjectRef((ObjectId)new ObjectVersionId(id), "local", type)));
            objByReference.setVersions(refs);
            objByReference.setAudit(((ContributionDto)contribution.get()).getAuditDetails());
            CompositionFormat format = this.extractCompositionFormat(accept);
            if (format.equals((Object)CompositionFormat.XML)) {
                respHeaders.setContentType(MediaType.APPLICATION_XML);
            } else if (format.equals((Object)CompositionFormat.JSON) || format.equals((Object)CompositionFormat.FLAT) || format.equals((Object)CompositionFormat.ECISFLAT) || format.equals((Object)CompositionFormat.RAW)) {
                respHeaders.setContentType(MediaType.APPLICATION_JSON);
            } else {
                throw new NotAcceptableException("Wrong Accept header in request");
            }
        }
        return Optional.of(new InternalResponse<ContributionResponseData>(minimalOrRepresentation, respHeaders));
    }

    private void createAuditLogsMsgBuilder(UUID ehrId, UUID contributionId) {
        AuditMsgBuilder.getInstance().setEhrIds(new Object[]{ehrId}).setContributionId(contributionId.toString()).setLocation(UriComponentsBuilder.fromPath((String)"").pathSegment(new String[]{"ehr", ehrId.toString(), "contribution", contributionId.toString()}).build().toString());
    }
}

