/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr;

import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.ehr.EhrStatus;
import com.nedap.archie.rm.support.identification.HierObjectId;
import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.ehrbase.api.annotations.TenantAware;
import org.ehrbase.api.audit.msg.AuditMsgBuilder;
import org.ehrbase.api.authorization.EhrbaseAuthorization;
import org.ehrbase.api.authorization.EhrbasePermission;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.StateConflictException;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.openehr.sdk.response.dto.EhrResponseData;
import org.ehrbase.rest.BaseController;
import org.ehrbase.rest.openehr.specification.EhrApiSpecification;
import org.ehrbase.rest.util.InternalResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@TenantAware
@RestController
@RequestMapping(path={"${openehr-api.context-path:/rest/openehr}/v1/ehr"}, produces={"application/json", "application/xml"})
public class OpenehrEhrController
extends BaseController
implements EhrApiSpecification {
    private final EhrService ehrService;

    @Autowired
    public OpenehrEhrController(EhrService ehrService) {
        this.ehrService = Objects.requireNonNull(ehrService);
    }

    @Override
    @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_EHR_CREATE)
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity createEhr(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @RequestHeader(value="Content-Type", required=false) String contentType, @RequestHeader(value="Accept", required=false) String accept, @RequestHeader(value="Prefer", required=false, defaultValue="return=minimal") String prefer, @RequestBody(required=false) EhrStatus ehrStatus) {
        UUID ehrId = ehrStatus != null ? this.ehrService.create(null, ehrStatus) : this.ehrService.create(null, null);
        return this.internalPostEhrProcessing(accept, prefer, ehrId);
    }

    @Override
    @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_EHR_CREATE)
    @PutMapping(path={"/{ehr_id}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<EhrResponseData> createEhrWithId(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @RequestHeader(value="Accept", required=false) String accept, @RequestHeader(value="Prefer", required=false) String prefer, @PathVariable(value="ehr_id") String ehrIdString, @RequestBody(required=false) EhrStatus ehrStatus) {
        UUID ehrId;
        try {
            ehrId = UUID.fromString(ehrIdString);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidApiParameterException("EHR ID format not a UUID");
        }
        if (this.ehrService.hasEhr(ehrId)) {
            throw new StateConflictException("EHR with this ID already exists");
        }
        UUID resultEhrId = ehrStatus != null ? this.ehrService.create(ehrId, ehrStatus) : this.ehrService.create(ehrId, null);
        if (!ehrId.equals(resultEhrId)) {
            throw new InternalServerException("Error creating EHR with custom ID and/or status");
        }
        return this.internalPostEhrProcessing(accept, prefer, resultEhrId);
    }

    private ResponseEntity<EhrResponseData> internalPostEhrProcessing(String accept, String prefer, UUID resultEhrId) {
        this.createAuditLogsMsgBuilder(resultEhrId);
        URI url = this.createLocationUri("ehr", resultEhrId.toString());
        List<String> headerList = Arrays.asList("Content-Type", "Location", "ETag", "Last-Modified");
        Optional<InternalResponse<EhrResponseData>> respData = Optional.ofNullable(prefer).map(i -> i.equals("return=representation")).orElse(false) != false ? this.buildEhrResponseData(EhrResponseData::new, resultEhrId, accept, headerList) : this.buildEhrResponseData(() -> null, resultEhrId, accept, headerList);
        return respData.map(i -> Optional.ofNullable((EhrResponseData)i.getResponseData()).map(j -> ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)url).headers(i.getHeaders())).body(j)).orElse(ResponseEntity.noContent().headers(i.getHeaders()).build())).orElse(ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    private void createAuditLogsMsgBuilder(UUID resultEhrId) {
        AuditMsgBuilder.getInstance().setEhrIds(new Object[]{resultEhrId});
    }

    @Override
    @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_EHR_READ)
    @GetMapping(path={"/{ehr_id}"})
    @PreAuthorize(value="checkAbacPre(@openehrEhrController.EHR, @ehrService.getSubjectExtRef(#ehrIdString))")
    public ResponseEntity<EhrResponseData> retrieveEhrById(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="ehr_id") String ehrIdString) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        if (!this.ehrService.hasEhr(ehrId)) {
            throw new ObjectNotFoundException("ehr", "No EHR with this ID can be found");
        }
        return this.internalGetEhrProcessing(accept, ehrId);
    }

    @Override
    @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_EHR_READ)
    @GetMapping(params={"subject_id", "subject_namespace"})
    @PreAuthorize(value="checkAbacPre(@openehrEhrController.EHR, #subjectId)")
    public ResponseEntity<EhrResponseData> retrieveEhrBySubject(@RequestHeader(value="Accept", required=false) String accept, @RequestParam(value="subject_id") String subjectId, @RequestParam(value="subject_namespace") String subjectNamespace) {
        Optional ehrIdOpt = this.ehrService.findBySubject(subjectId, subjectNamespace);
        UUID ehrId = (UUID)ehrIdOpt.orElseThrow(() -> new ObjectNotFoundException("ehr", "No EHR with supplied subject parameters found"));
        return this.internalGetEhrProcessing(accept, ehrId);
    }

    private ResponseEntity<EhrResponseData> internalGetEhrProcessing(String accept, UUID ehrId) {
        this.createAuditLogsMsgBuilder(ehrId);
        List<String> headerList = Arrays.asList("Content-Type", "Location", "ETag", "Last-Modified");
        Optional<InternalResponse<EhrResponseData>> respData = this.buildEhrResponseData(EhrResponseData::new, ehrId, accept, headerList);
        return respData.map(i -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(i.getHeaders())).body((Object)((EhrResponseData)i.getResponseData()))).orElse(ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    private <T extends EhrResponseData> Optional<InternalResponse<T>> buildEhrResponseData(Supplier<T> factory, UUID ehrId, String accept, List<String> headerList) {
        MediaType contentType = this.resolveContentType(accept);
        EhrResponseData minimalOrRepresentation = (EhrResponseData)factory.get();
        if (minimalOrRepresentation != null) {
            EhrStatus ehrStatus = this.ehrService.getEhrStatus(ehrId);
            EhrResponseData objByReference = minimalOrRepresentation;
            objByReference.setEhrId(new HierObjectId(ehrId.toString()));
            objByReference.setEhrStatus(ehrStatus);
            objByReference.setSystemId(new HierObjectId(this.ehrService.getSystemUuid().toString()));
            DvDateTime timeCreated = this.ehrService.getCreationTime(ehrId);
            objByReference.setTimeCreated(timeCreated.getValue().toString());
        }
        HttpHeaders respHeaders = new HttpHeaders();
        Iterator<String> iterator = headerList.iterator();
        while (iterator.hasNext()) {
            String header;
            switch (header = iterator.next()) {
                case "Content-Type": {
                    if (minimalOrRepresentation == null) break;
                    respHeaders.setContentType(contentType);
                    break;
                }
                case "Location": {
                    try {
                        URI url = this.createLocationUri("ehr", ehrId.toString());
                        respHeaders.setLocation(url);
                        break;
                    }
                    catch (Exception e) {
                        throw new InternalServerException(e.getMessage());
                    }
                }
                case "ETag": {
                    respHeaders.setETag("\"" + ehrId + "\"");
                    break;
                }
                case "Last-Modified": {
                    respHeaders.setLastModified(123124442L);
                    break;
                }
            }
        }
        return Optional.of(new InternalResponse<EhrResponseData>(minimalOrRepresentation, respHeaders));
    }
}

