/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ehrbase.api.tenant.TenantAuthentication;
import org.ehrbase.api.tenant.ThreadLocalSupplier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ComponentScan(basePackages={"org.ehrbase.rest", "org.ehrbase.rest.admin", "org.ehrbase.rest.openehr"})
@EnableAspectJAutoProxy
public class RestModuleConfiguration
implements WebMvcConfigurer {
    public static final String HTTP_HEADER_TENANT_ID = "Tenant-Id";
    public static final String NONE = "none";
    @Value(value="${security.auth-type}")
    private String authType;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new HttpRequestSupplierInterceptor());
        if (NONE.equalsIgnoreCase(this.authType)) {
            registry.addInterceptor((HandlerInterceptor)new SecurityContextCleanupInterceptor());
        }
    }

    public static class HttpRequestSupplierInterceptor
    implements HandlerInterceptor {
        public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
            ThreadLocalSupplier threadLocalSupplier = ThreadLocalSupplier.supplyFor(HttpServletRequest.class);
            threadLocalSupplier.accept((Object)request);
            return true;
        }

        public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
            ThreadLocalSupplier threadLocalSupplier = ThreadLocalSupplier.supplyFor(HttpServletRequest.class);
            threadLocalSupplier.reset();
            this.extractTenantId().ifPresent(id -> response.setHeader(RestModuleConfiguration.HTTP_HEADER_TENANT_ID, id));
        }

        private Optional<String> extractTenantId() {
            SecurityContext secCtx = SecurityContextHolder.getContext();
            return Optional.ofNullable(secCtx.getAuthentication()).filter(TenantAuthentication.class::isInstance).map(auth -> (TenantAuthentication)auth).map(TenantAuthentication::getTenantId);
        }
    }

    public static class SecurityContextCleanupInterceptor
    implements HandlerInterceptor {
        public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
            SecurityContextHolder.clearContext();
            return true;
        }
    }
}

