/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections4.MapUtils;
import org.ehrbase.api.annotations.TenantAware;
import org.ehrbase.api.audit.msg.AuditMsgBuilder;
import org.ehrbase.api.authorization.EhrbaseAuthorization;
import org.ehrbase.api.authorization.EhrbasePermission;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.service.QueryService;
import org.ehrbase.openehr.sdk.response.dto.QueryResponseData;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.QueryDefinitionResultDto;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.QueryResultDto;
import org.ehrbase.rest.BaseController;
import org.ehrbase.rest.openehr.RequestAwareAuditResultMapHolder;
import org.ehrbase.rest.openehr.specification.QueryApiSpecification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@TenantAware
@RestController
@RequestMapping(path={"${openehr-api.context-path:/rest/openehr}/v1/query"})
public class OpenehrQueryController
extends BaseController
implements QueryApiSpecification {
    private static final String EHR_ID_VALUE = "ehr_id/value";
    private static final String QUERY_PARAMETERS = "query_parameters";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final QueryService queryService;
    @Autowired(required=true)
    @Qualifier(value="requestAwareAuditResultMapHolder")
    private RequestAwareAuditResultMapHolder auditResultMapHolder;

    public OpenehrQueryController(QueryService queryService) {
        this.queryService = queryService;
    }

    @Override
    @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_QUERY_SEARCH_AD_HOC)
    @GetMapping(path={"/aql"})
    @PostAuthorize(value="checkAbacPostQuery(@requestAwareAuditResultMapHolder.getAuditResultMap())")
    public ResponseEntity<QueryResponseData> executeAdHocQuery(@RequestParam(name="q") String query, @RequestParam(name="offset", required=false) Integer offset, @RequestParam(name="fetch", required=false) Integer fetch, @RequestParam(name="query_parameters", required=false) Map<String, Object> queryParameters, @RequestHeader(name="Accept", required=false) String accept) {
        if (fetch != null) {
            query = this.withFetch(query, fetch);
        }
        if (offset != null) {
            query = this.withOffset(query, offset);
        }
        this.createAdHocAuditLogsMsgBuilder();
        QueryResponseData body = this.executeQuery(query, queryParameters);
        if (!CollectionUtils.isEmpty((Collection)body.getRows())) {
            return ResponseEntity.ok((Object)body);
        }
        return ResponseEntity.noContent().build();
    }

    @Override
    @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_QUERY_SEARCH_AD_HOC)
    @PostMapping(path={"/aql"})
    @PostAuthorize(value="checkAbacPostQuery(@requestAwareAuditResultMapHolder.getAuditResultMap())")
    public ResponseEntity<QueryResponseData> executeAdHocQuery(@RequestBody Map<String, Object> queryRequest, @RequestHeader(name="Accept", required=false) String accept, @RequestHeader(name="Content-Type") String contentType) {
        this.logger.debug("Got following input: {}", queryRequest);
        String aql = (String)queryRequest.get("q");
        if (aql == null) {
            throw new InvalidApiParameterException("No aql query provided");
        }
        aql = this.withOffsetLimit(aql, queryRequest);
        this.createAdHocAuditLogsMsgBuilder();
        Map parameters = (Map)queryRequest.get(QUERY_PARAMETERS);
        QueryResponseData body = this.executeQuery(aql, parameters);
        return ResponseEntity.ok((Object)body);
    }

    @Override
    @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_QUERY_SEARCH)
    @GetMapping(path={"/{qualified_query_name}", "/{qualified_query_name}/{version}"})
    @PostAuthorize(value="checkAbacPostQuery(@requestAwareAuditResultMapHolder.getAuditResultMap())")
    public ResponseEntity<QueryResponseData> executeStoredQuery(@PathVariable(name="qualified_query_name") String qualifiedQueryName, @PathVariable(name="version", required=false) String version, @RequestParam(name="offset", required=false) Integer offset, @RequestParam(name="fetch", required=false) Integer fetch, @RequestParam(name="query_parameters", required=false) Map<String, Object> queryParameter, @RequestHeader(name="Accept", required=false) String accept) {
        this.logger.trace("getStoredQuery not implemented but got following input: {} - {} - {} - {} - {}", new Object[]{qualifiedQueryName, version, offset, fetch, queryParameter});
        this.createAuditLogsMsgBuilder(qualifiedQueryName, version);
        QueryDefinitionResultDto queryResultDto = this.queryService.retrieveStoredQuery(qualifiedQueryName, version);
        String query = queryResultDto.getQueryText();
        if (fetch != null) {
            query = this.withFetch(query, fetch);
        }
        if (offset != null) {
            query = this.withOffset(query, offset);
        }
        QueryResponseData queryResponseData = this.invoke(query, queryParameter);
        OpenehrQueryController.setQueryName(queryResultDto, queryResponseData);
        AuditMsgBuilder.getInstance().setQueryId(queryResultDto.getQualifiedName());
        return ResponseEntity.ok((Object)queryResponseData);
    }

    @Override
    @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_QUERY_SEARCH)
    @PostMapping(path={"/{qualified_query_name}", "/{qualified_query_name}/{version}"})
    @PostAuthorize(value="checkAbacPostQuery(@requestAwareAuditResultMapHolder.getAuditResultMap())")
    public ResponseEntity<QueryResponseData> executeStoredQuery(@PathVariable(name="qualified_query_name") String qualifiedQueryName, @PathVariable(name="version", required=false) String version, @RequestHeader(name="Accept", required=false) String accept, @RequestHeader(name="Content-Type") String contentType, @RequestBody(required=false) Map<String, Object> queryRequest) {
        this.logger.trace("postStoredQuery with the following input: {}, {}, {}", new Object[]{qualifiedQueryName, version, queryRequest});
        this.createAuditLogsMsgBuilder(qualifiedQueryName, version);
        QueryDefinitionResultDto queryResultDto = this.queryService.retrieveStoredQuery(qualifiedQueryName, version);
        String query = queryResultDto.getQueryText();
        if (query == null) {
            String message = MessageFormat.format("Could not retrieve AQL {0}/{1}", qualifiedQueryName, version);
            throw new ObjectNotFoundException("AQL", message);
        }
        Map queryParameter = null;
        if (queryRequest != null && !queryRequest.isEmpty()) {
            queryParameter = (Map)queryRequest.get(QUERY_PARAMETERS);
            query = this.withOffsetLimit(query, queryRequest);
        }
        QueryResponseData queryResponseData = this.invoke(query, queryParameter);
        OpenehrQueryController.setQueryName(queryResultDto, queryResponseData);
        AuditMsgBuilder.getInstance().setQueryId(queryResultDto.getQualifiedName());
        return ResponseEntity.ok((Object)queryResponseData);
    }

    private void createAuditLogsMsgBuilder(String qualifiedName, @Nullable String version) {
        AuditMsgBuilder.getInstance().setIsQueryExecuteEndpoint(Boolean.valueOf(true)).setLocation(UriComponentsBuilder.fromPath((String)"").pathSegment(new String[]{"query", qualifiedName, version}).build().toString());
    }

    private void createAdHocAuditLogsMsgBuilder() {
        AuditMsgBuilder.getInstance().setIsQueryExecuteEndpoint(Boolean.valueOf(true));
    }

    private static void setQueryName(QueryDefinitionResultDto queryDefinitionResultDto, QueryResponseData queryResponseData) {
        queryResponseData.setName(queryDefinitionResultDto.getQualifiedName() + "/" + queryDefinitionResultDto.getVersion());
    }

    private QueryResponseData executeQuery(String aql, Map<String, Object> parameters) {
        Map<String, Set<Object>> auditResultMap = this.auditResultMapHolder.getAuditResultMap();
        QueryResponseData queryResponseData = new QueryResponseData(this.queryService.query(aql, parameters, false, auditResultMap));
        AuditMsgBuilder.getInstance().setEhrIds(new Object[]{auditResultMap.get(EHR_ID_VALUE)});
        return queryResponseData;
    }

    private String withFetch(String query, String value) {
        return this.withFetch(query, this.double2int(value));
    }

    private String withFetch(String query, Integer value) {
        return this.orderedLimitOffset(query, "LIMIT", value);
    }

    private String orderedLimitOffset(String query, String keyword, Integer value) {
        Object queryFormatted;
        if (query.replace(" ", "").toUpperCase().contains("ORDERBY")) {
            String[] strings = query.split("(?i)ORDER");
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append(strings[0]);
            queryBuilder.append(keyword.toUpperCase());
            queryBuilder.append(" ");
            queryBuilder.append(value);
            queryBuilder.append(" ORDER");
            queryBuilder.append(strings[1]);
            queryFormatted = queryBuilder.toString();
        } else {
            queryFormatted = query + " " + keyword + " " + value;
        }
        return queryFormatted;
    }

    private String withOffset(String query, String value) {
        return this.withOffset(query, this.double2int(value));
    }

    private String withOffset(String query, Integer value) {
        return this.orderedLimitOffset(query, "OFFSET", value);
    }

    private Integer double2int(String value) {
        return Double.valueOf(value).intValue();
    }

    private QueryResponseData invoke(String query, Map<String, Object> queryParameter) {
        Map<String, Set<Object>> auditResultMap = this.auditResultMapHolder.getAuditResultMap();
        Map parameters = Optional.ofNullable(queryParameter).filter(MapUtils::isNotEmpty).map(HashMap::new).orElse(null);
        QueryResultDto resultDto = this.queryService.query(query, parameters, false, auditResultMap);
        AuditMsgBuilder.getInstance().setEhrIds(new Object[]{auditResultMap.get(EHR_ID_VALUE)});
        return new QueryResponseData(resultDto);
    }

    String withOffsetLimit(String query, Map<String, Object> mapped) {
        if (mapped.containsKey("fetch")) {
            query = this.withFetch(query, mapped.get("fetch").toString());
        }
        if (mapped.containsKey("offset")) {
            query = this.withOffset(query, mapped.get("offset").toString());
        }
        return query;
    }
}

