/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr;

import com.nedap.archie.rm.changecontrol.OriginalVersion;
import com.nedap.archie.rm.changecontrol.VersionedObject;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.ehr.VersionedComposition;
import com.nedap.archie.rm.generic.RevisionHistory;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.ehrbase.api.annotations.TenantAware;
import org.ehrbase.api.audit.msg.AuditMsgBuilder;
import org.ehrbase.api.authorization.EhrbaseAuthorization;
import org.ehrbase.api.authorization.EhrbasePermission;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.service.CompositionService;
import org.ehrbase.api.service.ContributionService;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.openehr.sdk.response.dto.OriginalVersionResponseData;
import org.ehrbase.openehr.sdk.response.dto.RevisionHistoryResponseData;
import org.ehrbase.openehr.sdk.response.dto.VersionedObjectResponseData;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.ContributionDto;
import org.ehrbase.rest.BaseController;
import org.ehrbase.rest.openehr.specification.VersionedCompositionApiSpecification;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@TenantAware
@RestController
@RequestMapping(path={"${openehr-api.context-path:/rest/openehr}/v1/ehr/{ehr_id}/versioned_composition"}, produces={"application/json", "application/xml"})
public class OpenehrVersionedCompositionController
extends BaseController
implements VersionedCompositionApiSpecification {
    private final EhrService ehrService;
    private final CompositionService compositionService;
    private final ContributionService contributionService;

    @Autowired
    public OpenehrVersionedCompositionController(EhrService ehrService, CompositionService compositionService, ContributionService contributionService) {
        this.ehrService = Objects.requireNonNull(ehrService);
        this.compositionService = Objects.requireNonNull(compositionService);
        this.contributionService = Objects.requireNonNull(contributionService);
    }

    @Override
    @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_COMPOSITION_READ)
    @GetMapping(path={"/{versioned_object_uid}"})
    public ResponseEntity<VersionedObjectResponseData<Composition>> retrieveVersionedCompositionByVersionedObjectUid(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="ehr_id") String ehrIdString, @PathVariable(value="versioned_object_uid") String versionedObjectUid) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        UUID versionedCompoUid = this.getCompositionVersionedObjectUidString(versionedObjectUid);
        this.checkForValidEhrAndCompositionParameter(ehrId, versionedCompoUid);
        VersionedComposition versionedComposition = this.compositionService.getVersionedComposition(ehrId, versionedCompoUid);
        VersionedObjectResponseData response = new VersionedObjectResponseData((VersionedObject)versionedComposition);
        String auditLocation = this.getLocationUrl(versionedCompoUid, ehrId, 0, new String[0]);
        this.createAuditLogsMsgBuilder(ehrId, versionedCompoUid, auditLocation);
        HttpHeaders respHeaders = new HttpHeaders();
        respHeaders.setContentType(this.resolveContentType(accept));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(respHeaders)).body((Object)response);
    }

    @Override
    @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_COMPOSITION_READ)
    @GetMapping(path={"/{versioned_object_uid}/revision_history"})
    public ResponseEntity<RevisionHistoryResponseData> retrieveVersionedCompositionRevisionHistoryByEhr(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="ehr_id") String ehrIdString, @PathVariable(value="versioned_object_uid") String versionedObjectUid) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        UUID versionedCompoUid = this.getCompositionVersionedObjectUidString(versionedObjectUid);
        this.checkForValidEhrAndCompositionParameter(ehrId, versionedCompoUid);
        RevisionHistory revisionHistory = this.compositionService.getRevisionHistoryOfVersionedComposition(ehrId, versionedCompoUid);
        RevisionHistoryResponseData response = new RevisionHistoryResponseData(revisionHistory);
        String auditLocation = this.getLocationUrl(versionedCompoUid, ehrId, 0, "revision_history");
        this.createAuditLogsMsgBuilder(ehrId, versionedCompoUid, auditLocation);
        HttpHeaders respHeaders = new HttpHeaders();
        respHeaders.setContentType(this.resolveContentType(accept));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(respHeaders)).body((Object)response);
    }

    @Override
    @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_COMPOSITION_READ)
    @GetMapping(path={"/{versioned_object_uid}/version/{version_uid}"})
    @PostAuthorize(value="checkAbacPost(@openehrVersionedCompositionController.COMPOSITION, @ehrService.getSubjectExtRef(#ehrIdString), returnObject, #accept)")
    public ResponseEntity<OriginalVersionResponseData<Composition>> retrieveVersionOfCompositionByVersionUid(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="ehr_id") String ehrIdString, @PathVariable(value="versioned_object_uid") String versionedObjectUid, @PathVariable(value="version_uid") String versionUid) {
        int version;
        UUID versionedObjectId;
        UUID ehrId = this.getEhrUuid(ehrIdString);
        UUID versionedCompoUid = this.getCompositionVersionedObjectUidString(versionedObjectUid);
        this.checkForValidEhrAndCompositionParameter(ehrId, versionedCompoUid);
        ObjectVersionId compositionVersionId = new ObjectVersionId(versionUid);
        if (!compositionVersionId.getRoot().getValue().equals(versionedObjectUid)) {
            throw new IllegalArgumentException("Composition parameters are not matching.");
        }
        try {
            versionedObjectId = UUID.fromString(compositionVersionId.getRoot().getValue());
            version = Integer.parseInt(compositionVersionId.getVersionTreeId().getValue());
        }
        catch (Exception e) {
            throw new InvalidApiParameterException("VERSION UID parameter has wrong format: " + e.getMessage());
        }
        String auditLocation = this.getLocationUrl(versionedObjectId, ehrId, version, "version", versionUid);
        this.createAuditLogsMsgBuilder(ehrId, versionedCompoUid, auditLocation);
        return this.getOriginalVersionResponseDataResponseEntity(accept, ehrId, versionedObjectId, version);
    }

    @Override
    @EhrbaseAuthorization(permission=EhrbasePermission.EHRBASE_COMPOSITION_READ)
    @GetMapping(path={"/{versioned_object_uid}/version"})
    @PostAuthorize(value="checkAbacPost(@openehrVersionedCompositionController.COMPOSITION, @ehrService.getSubjectExtRef(#ehrIdString), returnObject, #accept)")
    public ResponseEntity<OriginalVersionResponseData<Composition>> retrieveVersionOfCompositionByTime(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="ehr_id") String ehrIdString, @PathVariable(value="versioned_object_uid") String versionedObjectUid, @RequestParam(value="version_at_time", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime versionAtTime) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        UUID versionedCompoUid = this.getCompositionVersionedObjectUidString(versionedObjectUid);
        this.checkForValidEhrAndCompositionParameter(ehrId, versionedCompoUid);
        int version = versionAtTime != null ? this.compositionService.getVersionByTimestamp(versionedCompoUid, versionAtTime).intValue() : this.compositionService.getLastVersionNumber(versionedCompoUid).intValue();
        String auditLocation = this.getLocationUrl(versionedCompoUid, ehrId, version, "version");
        this.createAuditLogsMsgBuilder(ehrId, versionedCompoUid, auditLocation);
        return this.getOriginalVersionResponseDataResponseEntity(accept, ehrId, versionedCompoUid, version);
    }

    private void checkForValidEhrAndCompositionParameter(UUID ehrId, UUID versionedCompoUid) {
        if (!this.ehrService.hasEhr(ehrId)) {
            throw new ObjectNotFoundException("ehr", "No EHR with this ID can be found");
        }
        if (!this.compositionService.exists(versionedCompoUid)) {
            throw new ObjectNotFoundException("composition", "No composition with this ID can be found.");
        }
    }

    private ResponseEntity<OriginalVersionResponseData<Composition>> getOriginalVersionResponseDataResponseEntity(String accept, UUID ehrId, UUID versionedObjectId, int version) {
        Optional compositionOriginalVersion = this.compositionService.getOriginalVersionComposition(ehrId, versionedObjectId, version);
        UUID contributionId = compositionOriginalVersion.map(i -> UUID.fromString(i.getContribution().getId().getValue())).orElseThrow(() -> new InvalidApiParameterException("Couldn't retrieve Composition with given parameters"));
        Optional optionalContributionDto = this.contributionService.getContribution(ehrId, contributionId);
        ContributionDto contributionDto = (ContributionDto)optionalContributionDto.orElseThrow(() -> new InternalServerException("Couldn't fetch contribution for existing Composition"));
        OriginalVersionResponseData originalVersionResponseData = new OriginalVersionResponseData((OriginalVersion)compositionOriginalVersion.orElseThrow(() -> new InternalServerException("Composition exists but can't be retrieved as Original Version.")), contributionDto);
        HttpHeaders respHeaders = new HttpHeaders();
        respHeaders.setContentType(this.resolveContentType(accept));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(respHeaders)).body((Object)originalVersionResponseData);
    }

    private void createAuditLogsMsgBuilder(UUID ehrId, UUID versionedCompoUid, String auditLocation) {
        AuditMsgBuilder.getInstance().setEhrIds(new Object[]{ehrId}).setCompositionId(versionedCompoUid.toString()).setTemplateId(this.compositionService.retrieveTemplateId(versionedCompoUid)).setLocation(auditLocation);
    }

    private String getLocationUrl(UUID versionedObjectUid, UUID ehrId, int version, String ... pathSegments) {
        if (version == 0) {
            version = this.compositionService.getLastVersionNumber(versionedObjectUid);
        }
        String versionedComposition = String.format("%s::%s::%s", versionedObjectUid, this.compositionService.getServerConfig().getNodename(), version);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromPath((String)"").pathSegment(new String[]{"ehr", ehrId.toString(), "versioned_composition", versionedComposition});
        if (pathSegments.length > 0) {
            uriComponentsBuilder.pathSegment(pathSegments);
        }
        return uriComponentsBuilder.build().toString();
    }
}

