/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.admin;

import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Objects;
import org.ehrbase.api.audit.msg.AuditMsgBuilder;
import org.ehrbase.api.service.StoredQueryService;
import org.ehrbase.rest.BaseController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@ConditionalOnMissingBean(name={"primaryadmindefinitioncontroller"})
@ConditionalOnProperty(prefix="admin-api", name={"active"})
@Tag(name="Admin - Stored-Query")
@RestController
@RequestMapping(path={"${admin-api.context-path:/rest/admin}/query"}, produces={"application/json", "application/xml"})
public class AdminDefinitionController
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final StoredQueryService storedQueryService;

    @Autowired
    public AdminDefinitionController(StoredQueryService storedQueryService) {
        this.storedQueryService = Objects.requireNonNull(storedQueryService);
    }

    @DeleteMapping(value={"/{qualified_query_name}/{version}"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Stored-Query has been deleted successfully"), @ApiResponse(responseCode="401", description="Client credentials are invalid or have expired."), @ApiResponse(responseCode="403", description="Client has no permission to access since admin role is missing."), @ApiResponse(responseCode="404", description="Stored-Query could not be found.")})
    public ResponseEntity<Void> deleteStoredQuery(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="qualified_query_name") String qualifiedQueryName, @PathVariable(value="version") String version) {
        this.logger.debug("deleteStoredQuery for the following input: {} , version: {}", (Object)qualifiedQueryName, (Object)version);
        this.createAuditLogsMsgBuilder(qualifiedQueryName, version);
        this.storedQueryService.deleteStoredQuery(qualifiedQueryName, version);
        AuditMsgBuilder.getInstance().setQueryId(qualifiedQueryName);
        return ResponseEntity.ok().build();
    }

    private void createAuditLogsMsgBuilder(String queryName, @Nullable String version) {
        AuditMsgBuilder.getInstance().setLocation(UriComponentsBuilder.fromPath((String)"").pathSegment(new String[]{"definition", "query", queryName, version}).build().toString());
    }
}

